/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.hibernate.util;

import com.foreach.across.modules.hibernate.types.IdLookup;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.BinaryType;
import org.hibernate.type.ByteType;
import org.hibernate.type.CharArrayType;
import org.hibernate.type.CharacterArrayType;
import org.hibernate.type.CharacterType;
import org.hibernate.type.ClassType;
import org.hibernate.type.CurrencyType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LocaleType;
import org.hibernate.type.LongType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.hibernate.type.UUIDBinaryType;
import org.hibernate.type.UrlType;
import org.hibernate.type.WrapperBinaryType;

public class HibernateTypeLookup {
    private static final Map<Class<?>, AbstractSingleColumnStandardBasicType> typeForClass = new HashMap();

    public static <K> AbstractSingleColumnStandardBasicType<K> getForIdLookupType(Class<? extends IdLookup<K>> clazz) {
        Type[] genericInterfaces = clazz.getGenericInterfaces();
        Class idClazz = null;
        for (Type genericInterface : genericInterfaces) {
            if (genericInterface instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
                if (!IdLookup.class.isAssignableFrom((Class)parameterizedType.getRawType())) continue;
                idClazz = (Class)parameterizedType.getActualTypeArguments()[0];
                break;
            }
            if (!IdLookup.class.isAssignableFrom((Class)genericInterface)) continue;
            return HibernateTypeLookup.getForIdLookupType((Class)genericInterface);
        }
        if (idClazz == null) {
            throw new IllegalArgumentException("You should implement IdLookup interface");
        }
        if (typeForClass.containsKey(idClazz)) {
            return typeForClass.get(idClazz);
        }
        throw new IllegalArgumentException("Class " + idClazz.getName() + " is not supported for id lookup");
    }

    static {
        typeForClass.put(BigDecimal.class, (AbstractSingleColumnStandardBasicType)BigDecimalType.INSTANCE);
        typeForClass.put(BigInteger.class, (AbstractSingleColumnStandardBasicType)BigIntegerType.INSTANCE);
        typeForClass.put(Byte.class, (AbstractSingleColumnStandardBasicType)ByteType.INSTANCE);
        typeForClass.put(byte[].class, (AbstractSingleColumnStandardBasicType)BinaryType.INSTANCE);
        typeForClass.put(Byte[].class, (AbstractSingleColumnStandardBasicType)WrapperBinaryType.INSTANCE);
        typeForClass.put(char[].class, (AbstractSingleColumnStandardBasicType)CharArrayType.INSTANCE);
        typeForClass.put(Character.class, (AbstractSingleColumnStandardBasicType)CharacterType.INSTANCE);
        typeForClass.put(Character[].class, (AbstractSingleColumnStandardBasicType)CharacterArrayType.INSTANCE);
        typeForClass.put(Class.class, (AbstractSingleColumnStandardBasicType)ClassType.INSTANCE);
        typeForClass.put(Currency.class, (AbstractSingleColumnStandardBasicType)CurrencyType.INSTANCE);
        typeForClass.put(Date.class, (AbstractSingleColumnStandardBasicType)DateType.INSTANCE);
        typeForClass.put(Double.class, (AbstractSingleColumnStandardBasicType)DoubleType.INSTANCE);
        typeForClass.put(Float.class, (AbstractSingleColumnStandardBasicType)FloatType.INSTANCE);
        typeForClass.put(Integer.class, (AbstractSingleColumnStandardBasicType)IntegerType.INSTANCE);
        typeForClass.put(Locale.class, (AbstractSingleColumnStandardBasicType)LocaleType.INSTANCE);
        typeForClass.put(Long.class, (AbstractSingleColumnStandardBasicType)LongType.INSTANCE);
        typeForClass.put(Short.class, (AbstractSingleColumnStandardBasicType)ShortType.INSTANCE);
        typeForClass.put(String.class, (AbstractSingleColumnStandardBasicType)StringType.INSTANCE);
        typeForClass.put(URL.class, (AbstractSingleColumnStandardBasicType)UrlType.INSTANCE);
        typeForClass.put(UUID.class, (AbstractSingleColumnStandardBasicType)UUIDBinaryType.INSTANCE);
    }
}

