/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.components.builder;

import com.foreach.across.modules.bootstrapui.components.builder.NavComponentBuilder;
import com.foreach.across.modules.bootstrapui.elements.LinkViewElement;
import com.foreach.across.modules.bootstrapui.styles.BootstrapStyles;
import com.foreach.across.modules.web.menu.Menu;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.AbstractNodeViewElement;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElements;
import com.foreach.across.modules.web.ui.elements.NodeViewElement;
import java.util.List;
import java.util.stream.Collectors;

public class BreadcrumbNavComponentBuilder
extends NavComponentBuilder<BreadcrumbNavComponentBuilder> {
    private int iconLevels = Integer.MAX_VALUE;
    private int iconOnlyLevels = Integer.MAX_VALUE;

    public BreadcrumbNavComponentBuilder iconAllowedLevels(int iconLevels) {
        this.iconLevels = iconLevels;
        return this;
    }

    public BreadcrumbNavComponentBuilder iconOnlyLevels(int iconOnlyLevels) {
        this.iconOnlyLevels = iconOnlyLevels;
        return this;
    }

    @Override
    protected NodeViewElement buildMenu(Menu menu, ViewElementBuilderContext builderContext) {
        NodeViewElement list = (NodeViewElement)this.apply((AbstractNodeViewElement)HtmlViewElements.html.ol(new ViewElement.WitherSetter[]{BootstrapStyles.css.breadcrumb}), builderContext);
        if (menu != null) {
            List segments = menu.getSelectedItemPath().stream().filter(this::shouldIncludeItem).collect(Collectors.toList());
            for (int i = 0; i < segments.size(); ++i) {
                this.addBreadcrumbSegment(list, (Menu)segments.get(i), builderContext, i, i == segments.size() - 1);
            }
        }
        return list;
    }

    protected void addBreadcrumbSegment(NodeViewElement list, Menu item, ViewElementBuilderContext builderContext, int level, boolean isLastItem) {
        boolean iconAllowed;
        if (this.addViewElementIfAttributeExists(item, "nav:itemViewElement", (ContainerViewElement)list, builderContext)) {
            return;
        }
        NodeViewElement li = HtmlViewElements.html.li(new ViewElement.WitherSetter[]{BootstrapStyles.css.breadcrumb.item});
        boolean iconOnly = level < this.iconOnlyLevels && Boolean.TRUE.equals(item.getAttribute("nav:iconOnly"));
        boolean bl = iconAllowed = level < this.iconLevels;
        if (isLastItem) {
            li.set(new ViewElement.WitherSetter[]{BootstrapStyles.css.active});
            if (!this.addViewElementIfAttributeExists(item, "nav:viewElement", (ContainerViewElement)li, builderContext)) {
                this.addIconAndText((AbstractNodeViewElement)li, item, builderContext.resolveText(item.getTitle()), iconAllowed, iconOnly, builderContext);
            }
        } else if (item.hasUrl() || !item.isGroup()) {
            this.addItemLink(li, item, iconAllowed, iconOnly, builderContext);
        } else {
            String url = this.findFirstNonDisabledChildUrl(item);
            if (url != null) {
                LinkViewElement link = this.addItemLink(li, item, iconAllowed, iconOnly, builderContext);
                if (link != null) {
                    link.setUrl(this.buildLink(url, builderContext));
                }
            } else {
                this.addIconAndText((AbstractNodeViewElement)li, item, builderContext.resolveText(item.getTitle()), iconAllowed, iconOnly, builderContext);
            }
        }
        li.set(new ViewElement.WitherSetter[]{this.witherAttribute(item, null)});
        list.addChild((ViewElement)li);
    }

    @Override
    protected LinkViewElement addItemLink(NodeViewElement container, Menu item, boolean iconAllowed, boolean iconOnly, ViewElementBuilderContext builderContext) {
        return super.addItemLink(container, item, iconAllowed, iconOnly, builderContext).remove(BootstrapStyles.css.nav.link);
    }

    private String findFirstNonDisabledChildUrl(Menu menu) {
        for (Menu item : menu.getItems()) {
            if (item.isDisabled()) continue;
            if (item.isGroup()) {
                return this.findFirstNonDisabledChildUrl(item);
            }
            return item.getUrl();
        }
        return null;
    }
}

