/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.components.builder;

import com.foreach.across.modules.bootstrapui.attributes.BootstrapAttributes;
import com.foreach.across.modules.bootstrapui.components.builder.NavComponentBuilder;
import com.foreach.across.modules.bootstrapui.elements.LinkViewElement;
import com.foreach.across.modules.bootstrapui.styles.AcrossBootstrapStyles;
import com.foreach.across.modules.bootstrapui.styles.BootstrapStyleRule;
import com.foreach.across.modules.bootstrapui.styles.BootstrapStyles;
import com.foreach.across.modules.web.menu.Menu;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.AbstractNodeViewElement;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElements;
import com.foreach.across.modules.web.ui.elements.NodeViewElement;
import com.foreach.across.modules.web.ui.elements.TextViewElement;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultNavComponentBuilder
extends NavComponentBuilder<DefaultNavComponentBuilder> {
    private BootstrapStyleRule navStyle;
    private ViewElement.WitherSetter<HtmlViewElement> dropDownWither;
    private boolean replaceGroupBySelectedItem;

    public DefaultNavComponentBuilder() {
        this.navStyle = BootstrapStyles.css.nav;
        this.replaceGroupBySelectedItem = false;
    }

    public DefaultNavComponentBuilder simple() {
        this.navStyle = BootstrapStyles.css.nav;
        return this;
    }

    public DefaultNavComponentBuilder tabs() {
        this.navStyle = BootstrapStyles.css.nav.tabs;
        return this;
    }

    public DefaultNavComponentBuilder pills() {
        this.navStyle = BootstrapStyles.css.nav.pills;
        return this;
    }

    public DefaultNavComponentBuilder stacked() {
        this.navStyle = BootstrapStyleRule.combine(BootstrapStyles.css.nav.pills, AcrossBootstrapStyles.css.flex.column);
        this.dropDownWither = BootstrapStyles.css.dropdown.direction.right;
        return this;
    }

    public DefaultNavComponentBuilder navbar() {
        this.navStyle = BootstrapStyles.css.navbar.nav;
        return this;
    }

    public DefaultNavComponentBuilder replaceGroupBySelectedItem() {
        return this.replaceGroupBySelectedItem(true);
    }

    public DefaultNavComponentBuilder dropDownWither(ViewElement.WitherSetter<HtmlViewElement> dropDownWither) {
        return this.replaceGroupBySelectedItem(true);
    }

    public DefaultNavComponentBuilder replaceGroupBySelectedItem(boolean replaceGroup) {
        this.replaceGroupBySelectedItem = replaceGroup;
        return this;
    }

    @Override
    protected NodeViewElement buildMenu(Menu menuToRender, ViewElementBuilderContext builderContext) {
        NodeViewElement list = (NodeViewElement)this.apply((AbstractNodeViewElement)HtmlViewElements.html.ul(new ViewElement.WitherSetter[]{this.navStyle}), builderContext);
        if (menuToRender != null) {
            this.includedItems(menuToRender).forEach(item -> this.addMenuItemToList(list, (Menu)item, builderContext));
        }
        return list;
    }

    private void addMenuItemToList(NodeViewElement list, Menu item, ViewElementBuilderContext builderContext) {
        Menu itemToRender = this.findItemToRender(item);
        if (itemToRender != null) {
            boolean iconOnly;
            boolean bl = iconOnly = item.isGroup() ? Boolean.TRUE.equals(item.getAttribute("nav:iconOnly")) : Boolean.TRUE.equals(itemToRender.getAttribute("nav:iconOnly"));
            if (iconOnly || !this.addViewElementIfAttributeExists(item, "nav:itemViewElement", (ContainerViewElement)list, builderContext)) {
                NodeViewElement li = HtmlViewElements.html.li(new ViewElement.WitherSetter[]{BootstrapStyles.css.nav.item, this.htmlAttributesOf(item)});
                if (itemToRender.isGroup()) {
                    this.buildDropDownItem(li, itemToRender, iconOnly, builderContext);
                } else {
                    this.addItemLink(li, itemToRender, true, iconOnly, builderContext);
                }
                li.set(new ViewElement.WitherSetter[]{this.witherAttribute(itemToRender, item)});
                list.addChild((ViewElement)li);
            }
        }
    }

    private void buildDropDownItem(NodeViewElement li, Menu item, boolean iconOnly, ViewElementBuilderContext builderContext) {
        li.set(new ViewElement.WitherSetter[]{BootstrapStyles.css.dropdown, this.witherAttribute(item, null)});
        if (this.dropDownWither != null) {
            li.set(new ViewElement.WitherSetter[]{this.dropDownWither});
        }
        if (!this.addViewElementIfAttributeExists(item, "nav:viewElement", (ContainerViewElement)li, builderContext)) {
            LinkViewElement link = new LinkViewElement();
            link.setUrl("#");
            link.set(new ViewElement.WitherSetter[]{BootstrapStyles.css.nav.link, BootstrapStyles.css.dropdown.toggle, BootstrapAttributes.attribute.role("button"), BootstrapAttributes.attribute.data.toggle.dropdown, BootstrapAttributes.attribute.aria.hasPopup(true), BootstrapAttributes.attribute.aria.expanded(false)});
            if (item.isSelected()) {
                link.set(BootstrapStyles.css.active);
            }
            if (item.isSelected() && this.replaceGroupBySelectedItem && !Boolean.TRUE.equals(item.getAttribute("nav:keepGroupItem"))) {
                Menu selected = this.getFirstNonGroupSelectedItem(item);
                String resolvedTitle = builderContext.resolveText(selected.getTitle());
                link.setTitle(resolvedTitle);
                this.addIconAndText((AbstractNodeViewElement)link, selected, resolvedTitle, true, iconOnly, builderContext);
            } else {
                String resolvedTitle = builderContext.resolveText(item.getTitle());
                link.setTitle(resolvedTitle);
                this.addIconAndText((AbstractNodeViewElement)link, item, resolvedTitle, true, iconOnly, builderContext);
            }
            link.addChild((ViewElement)new TextViewElement(" "));
            li.addChild((ViewElement)link);
        }
        NodeViewElement children = new NodeViewElement("div").set(new ViewElement.WitherSetter[]{BootstrapStyles.css.dropdown.menu});
        if (li.hasCssClass("float-right")) {
            children.set(new ViewElement.WitherSetter[]{BootstrapStyles.css.dropdown.menu.right, BootstrapStyles.css.dropdown.menu.left});
        }
        AtomicBoolean nextChildShouldBeSeparator = new AtomicBoolean(false);
        this.includedItems(item).forEach(child -> this.addDropDownChildItem(children, (Menu)child, nextChildShouldBeSeparator, builderContext));
        li.addChild((ViewElement)children);
    }

    private void addDropDownChildItem(NodeViewElement dropDown, Menu item, AtomicBoolean nextChildShouldBeSeparator, ViewElementBuilderContext builderContext) {
        Menu itemToRender = this.findItemToRender(item);
        if (itemToRender != null) {
            boolean shouldInsertSeparator;
            boolean bl = shouldInsertSeparator = nextChildShouldBeSeparator.get() || dropDown.hasChildren() && (itemToRender.isGroup() || NavComponentBuilder.Separator.insertBefore(itemToRender));
            if (shouldInsertSeparator) {
                dropDown.addChild((ViewElement)HtmlViewElements.html.div(new ViewElement.WitherSetter[]{BootstrapStyles.css.dropdown.divider}));
                nextChildShouldBeSeparator.set(false);
            }
            if (itemToRender.isGroup()) {
                NodeViewElement header = HtmlViewElements.html.h6(new ViewElement.WitherSetter[]{BootstrapStyles.css.dropdown.header});
                this.addIconAndText((AbstractNodeViewElement)header, itemToRender, builderContext.resolveText(itemToRender.getTitle()), true, false, builderContext);
                header.set(new ViewElement.WitherSetter[]{this.witherAttribute(itemToRender, item)});
                dropDown.addChild((ViewElement)header);
                this.includedItems(itemToRender).filter((? super T i) -> !i.isGroup()).forEach(child -> this.addDropDownChildItem(dropDown, (Menu)child, nextChildShouldBeSeparator, builderContext));
                nextChildShouldBeSeparator.set(true);
            } else {
                LinkViewElement link = this.addItemLink(dropDown, itemToRender, true, false, builderContext);
                link.set(BootstrapStyles.css.dropdown.item);
                link.remove(BootstrapStyles.css.nav.link);
                this.addHtmlAttributes((AbstractNodeViewElement)link, itemToRender.getAttributes());
                if (itemToRender.isSelected()) {
                    link.set(BootstrapStyles.css.active);
                }
                link.set(this.witherAttribute(itemToRender, item));
                nextChildShouldBeSeparator.set(NavComponentBuilder.Separator.insertAfter(itemToRender));
            }
        }
    }
}

