/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.components.builder;

import com.foreach.across.modules.bootstrapui.elements.LinkViewElement;
import com.foreach.across.modules.bootstrapui.elements.builder.AbstractLinkSupportingNodeViewElementBuilder;
import com.foreach.across.modules.bootstrapui.styles.BootstrapStyles;
import com.foreach.across.modules.bootstrapui.ui.factories.BootstrapViewElements;
import com.foreach.across.modules.web.menu.Menu;
import com.foreach.across.modules.web.ui.MutableViewElement;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilder;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.AbstractNodeViewElement;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElements;
import com.foreach.across.modules.web.ui.elements.NodeViewElement;
import com.foreach.across.modules.web.ui.elements.TextViewElement;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public abstract class NavComponentBuilder<SELF extends NavComponentBuilder<SELF>>
extends AbstractLinkSupportingNodeViewElementBuilder<NodeViewElement, SELF> {
    private static final String PREFIX_HTML_ATTRIBUTE = "html:";
    public static final String ATTR_ICON = "nav:icon";
    public static final String ATTR_ICON_ONLY = "nav:iconOnly";
    public static final String ATTR_ITEM_VIEW_ELEMENT = "nav:itemViewElement";
    public static final String ATTR_LINK_VIEW_ELEMENT = "nav:viewElement";
    public static final String ATTR_VIEW_ELEMENT_WITHER = "nav:viewElementWither";
    public static final String ATTR_KEEP_AS_GROUP = "nav:keepAsGroup";
    public static final String ATTR_KEEP_GROUP_ITEM = "nav:keepGroupItem";
    public static final String ATTR_INSERT_SEPARATOR = "nav:insertSeparator";
    public static final String CTX_CURRENT_MENU_ITEM = "NavComponentBuilder.currentMenuItem";
    private Menu menu;
    private String menuName;
    private boolean includePathAsDataAttribute;
    private boolean keepGroupsAsGroup = false;
    private Predicate<Menu> predicate = menu -> true;

    public SELF menu(String menuName) {
        this.menuName = menuName;
        return (SELF)((Object)this);
    }

    public SELF menu(Menu menu) {
        this.menu = menu;
        return (SELF)((Object)this);
    }

    public SELF includePathAsDataAttribute(boolean shouldInclude) {
        this.includePathAsDataAttribute = shouldInclude;
        return (SELF)((Object)this);
    }

    public SELF filter(@NonNull Predicate<Menu> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("predicate is marked non-null but is null");
        }
        this.predicate = predicate;
        return (SELF)((Object)this);
    }

    public SELF keepGroupsAsGroup(boolean keepGroupsAsGroup) {
        this.keepGroupsAsGroup = keepGroupsAsGroup;
        return (SELF)((Object)this);
    }

    protected NodeViewElement createElement(ViewElementBuilderContext builderContext) {
        return this.buildMenu(this.retrieveMenu(builderContext), builderContext);
    }

    protected abstract NodeViewElement buildMenu(Menu var1, ViewElementBuilderContext var2);

    protected Stream<Menu> includedItems(Menu menu) {
        return menu.getItems().stream().filter(this::shouldIncludeItem);
    }

    protected boolean shouldIncludeItem(Menu item) {
        return !item.isDisabled() && this.predicate.test(item);
    }

    protected Menu findItemToRender(Menu item) {
        if (item.isDisabled()) {
            return null;
        }
        if (item.isGroup()) {
            Menu candidate;
            int numberOfChildren = this.numberOfChildrenToInclude(item);
            if (numberOfChildren == 1 && !item.hasAttribute(ATTR_ITEM_VIEW_ELEMENT) && !this.shouldKeepAsGroup(item) && (candidate = this.findFirstIncludedChild(item)) != null) {
                return candidate;
            }
            return numberOfChildren > 0 ? item : null;
        }
        return item;
    }

    protected Menu findFirstIncludedChild(Menu menu) {
        for (Menu item : menu.getItems()) {
            if (!this.shouldIncludeItem(item)) continue;
            if (item.isGroup()) {
                return this.findFirstIncludedChild(item);
            }
            return item;
        }
        return null;
    }

    @Deprecated
    protected ViewElement.WitherSetter<AbstractNodeViewElement> htmlAttributesOf(Menu item) {
        return node -> item.getAttributes().forEach((name, value) -> {
            if (StringUtils.startsWith((CharSequence)name, (CharSequence)PREFIX_HTML_ATTRIBUTE)) {
                // empty if block
            }
        });
    }

    @Deprecated
    protected void addHtmlAttributes(AbstractNodeViewElement node, Map<String, Object> attributes) {
        attributes.forEach((name, value) -> {
            if (StringUtils.startsWith((CharSequence)name, (CharSequence)PREFIX_HTML_ATTRIBUTE)) {
                node.setAttribute(StringUtils.removeStart((String)name, (String)PREFIX_HTML_ATTRIBUTE), value);
            }
        });
    }

    protected boolean shouldKeepAsGroup(Menu item) {
        return this.keepGroupsAsGroup && !Boolean.FALSE.equals(item.getAttribute(ATTR_KEEP_AS_GROUP)) || Boolean.TRUE.equals(item.getAttribute(ATTR_KEEP_AS_GROUP));
    }

    protected Menu getFirstNonGroupSelectedItem(Menu menu) {
        Menu selected = menu.getSelectedItem();
        return selected.isGroup() ? this.getFirstNonGroupSelectedItem(selected) : selected;
    }

    protected LinkViewElement addItemLink(NodeViewElement container, Menu item, boolean iconAllowed, boolean iconOnly, ViewElementBuilderContext builderContext) {
        if (iconOnly || !this.addViewElementIfAttributeExists(item, ATTR_LINK_VIEW_ELEMENT, (ContainerViewElement)container, builderContext)) {
            LinkViewElement link = BootstrapViewElements.bootstrap.link(BootstrapStyles.css.nav.link).setUrl(this.buildLink(item.getUrl(), builderContext));
            if (item.isSelected()) {
                link.set(BootstrapStyles.css.active);
            }
            String resolvedTitle = builderContext.resolveText(item.getTitle());
            link.setTitle(builderContext.resolveText(resolvedTitle));
            this.addIconAndText((AbstractNodeViewElement)link, item, resolvedTitle, iconAllowed, iconOnly, builderContext);
            container.addChild((ViewElement)link);
            return link;
        }
        return BootstrapViewElements.bootstrap.link(BootstrapStyles.css.nav.link);
    }

    protected void addIconAndText(AbstractNodeViewElement node, Menu item, String resolvedTitle, boolean iconAllowed, boolean iconOnly, ViewElementBuilderContext builderContext) {
        boolean iconAdded;
        boolean bl = iconAdded = iconAllowed && this.addViewElementIfAttributeExists(item, ATTR_ICON, (ContainerViewElement)node, builderContext);
        if (!iconAdded || !iconOnly) {
            node.addChild((ViewElement)this.toTextElement((iconAdded ? " " : "") + resolvedTitle));
        }
        if (iconAdded && iconOnly) {
            node.addChild((ViewElement)TextViewElement.text((String)" "));
            node.addChild((ViewElement)HtmlViewElements.html.span(new ViewElement.WitherSetter[]{BootstrapStyles.css.screenReaderOnly, HtmlViewElements.html.text(resolvedTitle)}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addViewElementIfAttributeExists(Menu item, String attributeName, ContainerViewElement container, ViewElementBuilderContext builderContext) {
        Object attributeValue = item.getAttribute(attributeName);
        if (attributeValue instanceof ViewElement) {
            container.addChild((ViewElement)attributeValue);
            return true;
        }
        if (attributeValue instanceof ViewElementBuilder) {
            try {
                builderContext.setAttribute(CTX_CURRENT_MENU_ITEM, (Object)item);
                container.addChild(((ViewElementBuilder)attributeValue).build(builderContext));
                boolean bl = true;
                return bl;
            }
            finally {
                builderContext.removeAttribute(CTX_CURRENT_MENU_ITEM);
            }
        }
        return false;
    }

    protected int numberOfChildrenToInclude(Menu menu) {
        return menu.getItems().stream().filter(this::shouldIncludeItem).mapToInt(i -> i.isGroup() ? this.numberOfChildrenToInclude((Menu)i) : 1).sum();
    }

    protected ViewElement.WitherSetter witherAttribute(Menu itemToRender, Menu originalItem) {
        return element -> {
            ViewElement.WitherSetter setter;
            ViewElement.WitherSetter originalSetter;
            if (originalItem != null && originalItem != itemToRender && (originalSetter = (ViewElement.WitherSetter)originalItem.getAttribute(ATTR_VIEW_ELEMENT_WITHER)) != null) {
                originalSetter.applyTo(element);
            }
            if ((setter = (ViewElement.WitherSetter)itemToRender.getAttribute(ATTR_VIEW_ELEMENT_WITHER)) != null) {
                setter.applyTo(element);
            }
            if (this.includePathAsDataAttribute && !StringUtils.isEmpty((CharSequence)itemToRender.getPath())) {
                element.set(new ViewElement.WitherSetter[]{HtmlViewElement.Functions.data((String)"ax-menu-path", (Object)itemToRender.getPath())});
            }
        };
    }

    private Menu retrieveMenu(ViewElementBuilderContext builderContext) {
        if (this.menu != null) {
            return this.menu;
        }
        return this.menuName != null ? (Menu)builderContext.getAttribute(this.menuName, Menu.class) : null;
    }

    @Deprecated
    public static String htmlAttribute(String attributeName) {
        return PREFIX_HTML_ATTRIBUTE + attributeName;
    }

    public static Consumer<Map<String, Object>> customizeViewElement(ViewElement.WitherSetter ... setters) {
        return NavComponentBuilder.customizeViewElement(false, setters);
    }

    public static Consumer<Map<String, Object>> customizeViewElement(boolean replacePreviousRules, ViewElement.WitherSetter ... setters) {
        return attributes -> attributes.compute(ATTR_VIEW_ELEMENT_WITHER, (key, value) -> {
            if (replacePreviousRules || value == null) {
                return MutableViewElement.Functions.wither((ViewElement.WitherSetter[])setters);
            }
            return MutableViewElement.Functions.wither((ViewElement.WitherSetter[])new ViewElement.WitherSetter[]{(ViewElement.WitherSetter)value, MutableViewElement.Functions.wither((ViewElement.WitherSetter[])setters)});
        });
    }

    public static enum Separator {
        BEFORE,
        AFTER,
        AROUND;


        static boolean insertAfter(Menu menu) {
            Separator separator = Separator.parseValue(menu.getAttribute(NavComponentBuilder.ATTR_INSERT_SEPARATOR));
            return AFTER.equals((Object)separator) || AROUND.equals((Object)separator);
        }

        static boolean insertBefore(Menu menu) {
            Separator separator = Separator.parseValue(menu.getAttribute(NavComponentBuilder.ATTR_INSERT_SEPARATOR));
            return BEFORE.equals((Object)separator) || AROUND.equals((Object)separator);
        }

        static Separator parseValue(Object attributeValue) {
            if (attributeValue == null) {
                return null;
            }
            if (attributeValue instanceof Separator) {
                return (Separator)((Object)attributeValue);
            }
            return Separator.valueOf(StringUtils.upperCase((String)Objects.toString(attributeValue)));
        }
    }
}

