/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements;

import com.foreach.across.modules.bootstrapui.elements.Style;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.elements.AbstractTextNodeViewElement;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.NodeViewElement;
import com.foreach.across.modules.web.ui.elements.TextViewElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class AlertViewElement
extends AbstractTextNodeViewElement {
    public static final String CSS_LINK = "alert-link";
    private static final String CSS_DISMISSIBLE = "alert-dismissible";
    private static final String CSS_PREFIX = "alert";
    private String closeLabel = "Close";
    private Style style;

    public AlertViewElement() {
        super("div");
        this.setAttribute("role", CSS_PREFIX);
        this.addCssClass(CSS_PREFIX);
    }

    public AlertViewElement setStyle(Style style) {
        if (this.style != null) {
            this.removeCssClass(this.style.forPrefix(CSS_PREFIX));
        }
        this.style = style;
        if (style != null) {
            this.addCssClass(style.forPrefix(CSS_PREFIX));
        }
        return this;
    }

    public AlertViewElement setDismissible(boolean dismissible) {
        if (dismissible) {
            return this.addCssClass(CSS_DISMISSIBLE);
        }
        return this.removeCssClass(CSS_DISMISSIBLE);
    }

    public boolean isDismissible() {
        return this.hasCssClass(CSS_DISMISSIBLE);
    }

    public boolean hasChildren() {
        return this.isDismissible() || super.hasChildren();
    }

    public List<ViewElement> getChildren() {
        if (this.isDismissible()) {
            ArrayList<ViewElement> children = new ArrayList<ViewElement>();
            children.add(this.createButton());
            children.addAll(super.getChildren());
            return children;
        }
        return super.getChildren();
    }

    private ViewElement createButton() {
        NodeViewElement button = new NodeViewElement("button");
        button.setAttribute("type", (Object)"button");
        button.setAttribute("class", (Object)"close");
        button.setAttribute("data-dismiss", (Object)CSS_PREFIX);
        button.setAttribute("aria-label", (Object)this.getCloseLabel());
        NodeViewElement span = new NodeViewElement("span");
        span.setAttribute("aria-hidden", (Object)"true");
        span.addChild((ViewElement)TextViewElement.xml((String)"&times;"));
        button.addChild((ViewElement)span);
        return button;
    }

    protected AlertViewElement setTagName(String tagName) {
        super.setTagName(tagName);
        return this;
    }

    public AlertViewElement setHtmlId(String htmlId) {
        super.setHtmlId(htmlId);
        return this;
    }

    public AlertViewElement addCssClass(String ... cssClass) {
        super.addCssClass(cssClass);
        return this;
    }

    public AlertViewElement removeCssClass(String ... cssClass) {
        super.removeCssClass(cssClass);
        return this;
    }

    public AlertViewElement setAttributes(Map<String, Object> attributes) {
        super.setAttributes(attributes);
        return this;
    }

    public AlertViewElement setAttribute(String attributeName, Object attributeValue) {
        super.setAttribute(attributeName, attributeValue);
        return this;
    }

    public AlertViewElement addAttributes(Map<String, Object> attributes) {
        super.addAttributes(attributes);
        return this;
    }

    public AlertViewElement removeAttribute(String attributeName) {
        super.removeAttribute(attributeName);
        return this;
    }

    public AlertViewElement setName(String name) {
        super.setName(name);
        return this;
    }

    public AlertViewElement setCustomTemplate(String customTemplate) {
        super.setCustomTemplate(customTemplate);
        return this;
    }

    protected AlertViewElement setElementType(String elementType) {
        super.setElementType(elementType);
        return this;
    }

    public AlertViewElement addChild(ViewElement element) {
        super.addChild(element);
        return this;
    }

    public AlertViewElement addChildren(Collection<? extends ViewElement> elements) {
        super.addChildren(elements);
        return this;
    }

    public AlertViewElement addFirstChild(ViewElement element) {
        super.addFirstChild(element);
        return this;
    }

    public AlertViewElement clearChildren() {
        super.clearChildren();
        return this;
    }

    public AlertViewElement apply(Consumer<ContainerViewElement> consumer) {
        super.apply(consumer);
        return this;
    }

    public <U extends ViewElement> AlertViewElement applyUnsafe(Consumer<U> consumer) {
        super.applyUnsafe(consumer);
        return this;
    }

    public AlertViewElement setText(String text) {
        super.setText(text);
        return this;
    }

    public AlertViewElement set(ViewElement.WitherSetter ... setters) {
        super.set(setters);
        return this;
    }

    public AlertViewElement remove(ViewElement.WitherRemover ... functions) {
        super.remove(functions);
        return this;
    }

    public String getCloseLabel() {
        return this.closeLabel;
    }

    public AlertViewElement setCloseLabel(String closeLabel) {
        this.closeLabel = closeLabel;
        return this;
    }

    public Style getStyle() {
        return this.style;
    }
}

