/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements;

import com.foreach.across.modules.bootstrapui.elements.FormInputElement;
import com.foreach.across.modules.bootstrapui.elements.Size;
import com.foreach.across.modules.bootstrapui.elements.Style;
import com.foreach.across.modules.bootstrapui.styles.BootstrapStyleRule;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.elements.AbstractNodeViewElement;
import com.foreach.across.modules.web.ui.elements.ConfigurableTextViewElement;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.NonNull;

public class ButtonViewElement
extends AbstractNodeViewElement
implements ConfigurableTextViewElement,
FormInputElement {
    public static final String ELEMENT_TYPE = "bootstrapButton";
    private String text;
    private String title;
    private String url = "#";
    private Style style;
    private BootstrapStyleRule styleRule;
    @NonNull
    private Type type = Type.BUTTON;
    private State state;
    @Deprecated
    private Size size;
    private ViewElement icon;
    private String controlName;
    private String value;
    private boolean htmlIdSpecified;

    public ButtonViewElement() {
        super(ELEMENT_TYPE);
        this.setTagName("button");
        this.setStyle(Style.Button.DEFAULT);
    }

    public ButtonViewElement setStyle(Style style) {
        this.style = style;
        if (this.styleRule != null) {
            this.remove(this.styleRule);
        }
        this.styleRule = Style.Button.toBootstrapStyleRule(style);
        if (this.styleRule != null) {
            super.set(new ViewElement.WitherSetter[]{this.styleRule});
        }
        return this;
    }

    @Deprecated
    public ButtonViewElement setSize(Size newSize) {
        BootstrapStyleRule styleRule;
        if (this.size != null && (styleRule = this.size.toBootstrapStyleRule()) != null) {
            super.remove(new ViewElement.WitherRemover[]{styleRule});
        }
        this.size = newSize;
        if (newSize != null && (styleRule = newSize.toBootstrapStyleRule()) != null) {
            super.set(new ViewElement.WitherSetter[]{styleRule});
        }
        return this;
    }

    public ButtonViewElement setName(String name) {
        super.setName(name);
        if (this.controlName == null) {
            this.setControlName(name);
        }
        return this;
    }

    @Override
    public String getControlName() {
        return this.controlName;
    }

    @Override
    public ButtonViewElement setControlName(String controlName) {
        this.controlName = controlName;
        if (!this.htmlIdSpecified) {
            super.setHtmlId(controlName);
        }
        return this;
    }

    public ButtonViewElement setHtmlId(String htmlId) {
        this.htmlIdSpecified = true;
        super.setHtmlId(htmlId);
        return this;
    }

    @Override
    public boolean isDisabled() {
        return this.state == State.DISABLED;
    }

    @Override
    public ButtonViewElement setDisabled(boolean disabled) {
        return this.setState(disabled ? State.DISABLED : null);
    }

    public ButtonViewElement addCssClass(String ... cssClass) {
        super.addCssClass(cssClass);
        return this;
    }

    public ButtonViewElement removeCssClass(String ... cssClass) {
        super.removeCssClass(cssClass);
        return this;
    }

    public ButtonViewElement setAttributes(Map<String, Object> attributes) {
        super.setAttributes(attributes);
        return this;
    }

    public ButtonViewElement setAttribute(String attributeName, Object attributeValue) {
        super.setAttribute(attributeName, attributeValue);
        return this;
    }

    public ButtonViewElement addAttributes(Map<String, Object> attributes) {
        super.addAttributes(attributes);
        return this;
    }

    public ButtonViewElement removeAttribute(String attributeName) {
        super.removeAttribute(attributeName);
        return this;
    }

    public ButtonViewElement setCustomTemplate(String customTemplate) {
        super.setCustomTemplate(customTemplate);
        return this;
    }

    protected ButtonViewElement setElementType(String elementType) {
        super.setElementType(elementType);
        return this;
    }

    public ButtonViewElement addChild(ViewElement element) {
        super.addChild(element);
        return this;
    }

    public ButtonViewElement addChildren(Collection<? extends ViewElement> elements) {
        super.addChildren(elements);
        return this;
    }

    public ButtonViewElement addFirstChild(ViewElement element) {
        super.addFirstChild(element);
        return this;
    }

    public ButtonViewElement clearChildren() {
        super.clearChildren();
        return this;
    }

    public ButtonViewElement apply(Consumer<ContainerViewElement> consumer) {
        super.apply(consumer);
        return this;
    }

    public <U extends ViewElement> ButtonViewElement applyUnsafe(Consumer<U> consumer) {
        super.applyUnsafe(consumer);
        return this;
    }

    protected ButtonViewElement setTagName(String tagName) {
        super.setTagName(tagName);
        return this;
    }

    public ButtonViewElement set(ViewElement.WitherSetter ... setters) {
        Stream.of(setters).forEach(setter -> {
            if (setter instanceof BootstrapStyleRule) {
                Size buttonSize;
                BootstrapStyleRule sr = (BootstrapStyleRule)setter;
                Style buttonStyle = Style.Button.fromBootstrapStyleRule(sr);
                if (buttonStyle != null) {
                    if (this.styleRule != null) {
                        this.remove(this.styleRule);
                    }
                    this.style = buttonStyle;
                    this.styleRule = sr;
                }
                if ((buttonSize = Size.fromBootstrapStyleRule(sr)) != null) {
                    this.setSize(null);
                    this.size = buttonSize;
                }
            }
            super.set(new ViewElement.WitherSetter[]{setter});
        });
        return this;
    }

    public ButtonViewElement remove(ViewElement.WitherRemover ... functions) {
        super.remove(functions);
        return this;
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public Style getStyle() {
        return this.style;
    }

    public BootstrapStyleRule getStyleRule() {
        return this.styleRule;
    }

    @NonNull
    public Type getType() {
        return this.type;
    }

    public State getState() {
        return this.state;
    }

    @Deprecated
    public Size getSize() {
        return this.size;
    }

    public ViewElement getIcon() {
        return this.icon;
    }

    public String getValue() {
        return this.value;
    }

    public ButtonViewElement setText(String text) {
        this.text = text;
        return this;
    }

    public ButtonViewElement setTitle(String title) {
        this.title = title;
        return this;
    }

    public ButtonViewElement setUrl(String url) {
        this.url = url;
        return this;
    }

    public ButtonViewElement setStyleRule(BootstrapStyleRule styleRule) {
        this.styleRule = styleRule;
        return this;
    }

    public ButtonViewElement setType(@NonNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException("type is marked non-null but is null");
        }
        this.type = type;
        return this;
    }

    public ButtonViewElement setState(State state) {
        this.state = state;
        return this;
    }

    public ButtonViewElement setIcon(ViewElement icon) {
        this.icon = icon;
        return this;
    }

    public ButtonViewElement setValue(String value) {
        this.value = value;
        return this;
    }

    public static enum State {
        ACTIVE,
        DISABLED;

    }

    public static enum Type {
        BUTTON,
        BUTTON_SUBMIT,
        BUTTON_RESET,
        INPUT,
        INPUT_SUBMIT,
        INPUT_RESET,
        LINK;

    }
}

