/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements;

import com.foreach.across.modules.bootstrapui.elements.DateTimeFormElementConfiguration;
import com.foreach.across.modules.bootstrapui.elements.FormControlElement;
import com.foreach.across.modules.bootstrapui.elements.HiddenFormElement;
import com.foreach.across.modules.bootstrapui.elements.InputGroupFormElement;
import com.foreach.across.modules.bootstrapui.styles.BootstrapStyles;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.elements.AbstractNodeViewElement;
import com.foreach.across.modules.web.ui.elements.ConfigurableTextViewElement;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElements;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

public class DateTimeFormElement
extends InputGroupFormElement {
    public static final String ATTRIBUTE_DATA_DATEPICKER = "data-bootstrapui-datetimepicker";
    public static final String ATTRIBUTE_DATA_TARGET = "data-target";
    public static final String ATTRIBUTE_DATA_TOGGLE = "data-toggle";
    public static final String ATTRIBUTE_DATA_TARGET_INPUT = "data-target-input";
    public static final String CSS_JS_CONTROL = "js-form-datetimepicker";
    public static final String CSS_DATE = "date";
    public static final String CSS_DATETIMEPICKER_INPUT = "datetimepicker-input";
    private final HiddenFormElement hidden = new HiddenFormElement();
    private LocalDateTime value;

    public DateTimeFormElement() {
        this.setAppend((ViewElement)HtmlViewElements.html.div(new ViewElement.WitherSetter[]{BootstrapStyles.css.inputGroup.text, HtmlViewElement.Functions.children((ViewElement[])new ViewElement[]{HtmlViewElements.html.i(new ViewElement.WitherSetter[]{BootstrapStyles.css.fa.solid("calendar")})})}));
        this.addCssClass(CSS_JS_CONTROL, CSS_DATE);
        this.setAttribute(ATTRIBUTE_DATA_DATEPICKER, new DateTimeFormElementConfiguration());
        this.setAttribute(ATTRIBUTE_DATA_TARGET_INPUT, "nearest");
        this.setAttribute("data-bootstrapui-adapter-type", "datetime");
    }

    public DateTimeFormElementConfiguration getConfiguration() {
        return (DateTimeFormElementConfiguration)this.getAttribute(ATTRIBUTE_DATA_DATEPICKER, DateTimeFormElementConfiguration.class);
    }

    public void setConfiguration(@NonNull DateTimeFormElementConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is marked non-null but is null");
        }
        this.setAttribute(ATTRIBUTE_DATA_DATEPICKER, configuration);
    }

    @Override
    public String getControlName() {
        return this.hidden.getControlName();
    }

    @Override
    public DateTimeFormElement setControlName(String controlName) {
        if (StringUtils.isBlank((CharSequence)this.getHtmlId()) && StringUtils.isNotBlank((CharSequence)controlName)) {
            this.setHtmlId(String.format("_dp-controller--%s", controlName));
        }
        this.hidden.setControlName(controlName);
        return this;
    }

    @Deprecated
    public Date getValue() {
        return this.getConfiguration().localDateTimeToDate(this.value);
    }

    @Deprecated
    public DateTimeFormElement setValue(Date value) {
        this.setLocalDateTime(this.getConfiguration().dateToLocalDateTime(value));
        return this;
    }

    public DateTimeFormElement setLocalDate(LocalDate value) {
        this.setLocalDateTime(DateTimeFormElementConfiguration.localDateToLocalDateTime(value));
        return this;
    }

    public LocalDate getLocalDate() {
        return this.value.toLocalDate();
    }

    public DateTimeFormElement setLocalTime(LocalTime value) {
        this.setLocalDateTime(DateTimeFormElementConfiguration.localTimeToLocalDateTime(value));
        return this;
    }

    public LocalTime getLocalTime() {
        return this.value.toLocalTime();
    }

    public DateTimeFormElement setLocalDateTime(LocalDateTime value) {
        this.value = value;
        return this;
    }

    public LocalDateTime getLocalDateTime() {
        return this.value;
    }

    @Override
    public List<ViewElement> getChildren() {
        FormControlElement controlElement = this.getControl(FormControlElement.class);
        controlElement.removeAttribute("data-bootstrapui-adapter-type");
        String controlName = this.hidden.getControlName();
        controlElement.setAttribute(ATTRIBUTE_DATA_TARGET, this.getTarget());
        controlElement.addCssClass(new String[]{CSS_DATETIMEPICKER_INPUT});
        if (controlName != null) {
            controlElement.setControlName("_" + controlName);
            controlElement.setHtmlId(controlName);
        } else {
            controlElement.setControlName(null);
        }
        if (this.value != null) {
            String dateAsString = DateTimeFormElementConfiguration.JAVA_DATE_TIME_FORMATTER.format(this.value);
            this.hidden.setValue(dateAsString);
            if (controlElement instanceof ConfigurableTextViewElement) {
                ((ConfigurableTextViewElement)controlElement).setText(dateAsString);
            }
        }
        ArrayList<ViewElement> elements = new ArrayList<ViewElement>(super.getChildren());
        ViewElement append = this.getAppend();
        if (AbstractNodeViewElement.class.isAssignableFrom(append.getClass())) {
            append.set(new ViewElement.WitherSetter[]{HtmlViewElement.Functions.attribute((String)ATTRIBUTE_DATA_TOGGLE, (Object)"datetimepicker")}).set(new ViewElement.WitherSetter[]{HtmlViewElement.Functions.attribute((String)ATTRIBUTE_DATA_TARGET, (Object)this.getTarget())});
        }
        elements.add((ViewElement)this.hidden);
        return elements;
    }

    private String getTarget() {
        if (StringUtils.isNotBlank((CharSequence)this.getHtmlId())) {
            String escapedHtmlId = RegExUtils.replaceAll((String)this.getHtmlId(), (String)"(:|\\.|\\[|\\]|,|=|@|#)", (String)"\\\\$1");
            return "#" + escapedHtmlId;
        }
        return "";
    }

    @Override
    public DateTimeFormElement setPrepend(ViewElement prepend) {
        super.setPrepend(prepend);
        return this;
    }

    @Override
    public DateTimeFormElement setAppend(ViewElement append) {
        super.setAppend(append);
        return this;
    }

    @Override
    public DateTimeFormElement setControl(ViewElement control) {
        super.setControl(control);
        return this;
    }

    @Override
    public DateTimeFormElement setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
        return this;
    }

    @Override
    public DateTimeFormElement setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        return this;
    }

    @Override
    public DateTimeFormElement setReadonly(boolean readonly) {
        super.setReadonly(readonly);
        return this;
    }

    @Override
    public DateTimeFormElement setRequired(boolean required) {
        super.setRequired(required);
        return this;
    }

    @Override
    public DateTimeFormElement addCssClass(String ... cssClass) {
        super.addCssClass(cssClass);
        return this;
    }

    @Override
    public DateTimeFormElement removeCssClass(String ... cssClass) {
        super.removeCssClass(cssClass);
        return this;
    }

    @Override
    public DateTimeFormElement setAttributes(Map<String, Object> attributes) {
        super.setAttributes((Map)attributes);
        return this;
    }

    @Override
    public DateTimeFormElement setAttribute(String attributeName, Object attributeValue) {
        super.setAttribute(attributeName, attributeValue);
        return this;
    }

    @Override
    public DateTimeFormElement addAttributes(Map<String, Object> attributes) {
        super.addAttributes((Map)attributes);
        return this;
    }

    @Override
    public DateTimeFormElement removeAttribute(String attributeName) {
        super.removeAttribute(attributeName);
        return this;
    }

    @Override
    public DateTimeFormElement setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public DateTimeFormElement setCustomTemplate(String customTemplate) {
        super.setCustomTemplate(customTemplate);
        return this;
    }

    @Override
    protected DateTimeFormElement setElementType(String elementType) {
        super.setElementType(elementType);
        return this;
    }

    @Override
    public DateTimeFormElement addChild(ViewElement element) {
        super.addChild(element);
        return this;
    }

    @Override
    public DateTimeFormElement addChildren(Collection<? extends ViewElement> elements) {
        super.addChildren((Collection)elements);
        return this;
    }

    @Override
    public DateTimeFormElement addFirstChild(ViewElement element) {
        super.addFirstChild(element);
        return this;
    }

    @Override
    public DateTimeFormElement clearChildren() {
        super.clearChildren();
        return this;
    }

    @Override
    public DateTimeFormElement apply(Consumer<ContainerViewElement> consumer) {
        super.apply((Consumer)consumer);
        return this;
    }

    @Override
    public <U extends ViewElement> DateTimeFormElement applyUnsafe(Consumer<U> consumer) {
        super.applyUnsafe((Consumer)consumer);
        return this;
    }

    @Override
    protected DateTimeFormElement setTagName(String tagName) {
        super.setTagName(tagName);
        return this;
    }

    @Override
    public DateTimeFormElement set(ViewElement.WitherSetter ... setters) {
        super.set(setters);
        return this;
    }

    @Override
    public DateTimeFormElement remove(ViewElement.WitherRemover ... functions) {
        super.remove(functions);
        return this;
    }
}

