/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.DateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.time.FastDateFormat;
import org.springframework.util.Assert;

public class DateTimeFormElementConfiguration
extends HashMap<String, Object> {
    public static final String FMT_EXPORT_JAVA = "yyyy-MM-dd HH:mm";
    public static final String FMT_EXPORT_MOMENT_DATE = "YYYY-MM-DD";
    public static final String FMT_EXPORT_MOMENT_TIME = "HH:mm";
    public static final String FMT_EXPORT_MOMENT_DATETIME = "YYYY-MM-DD HH:mm";
    public static final String FMT_PATTERN_DATE = "L";
    public static final String FMT_PATTERN_DATE_FULL = "LL";
    public static final String FMT_PATTERN_TIME = "LT";
    public static final String FMT_PATTERN_DATETIME = "L LT";
    public static final String FMT_PATTERN_DATETIME_FULL = "LLL";
    public static final String FMT_EXTRA_PATTERN_DATE = "YYYY-MM-DD";
    public static final Locale DEFAULT_LOCALE = Locale.UK;
    public static final ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
    public static final FastDateFormat JAVA_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm");
    public static final DateTimeFormatter JAVA_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    @JsonIgnore
    private Format format;
    @JsonIgnore
    private Locale locale;
    @JsonIgnore
    private ZoneId zoneId;
    @JsonIgnore
    private boolean localizePatterns = true;
    @JsonIgnore
    private Map<String, Boolean> buttons = new HashMap<String, Boolean>();

    public DateTimeFormElementConfiguration() {
        this.setFormat(Format.DATETIME);
        this.setLocale(DEFAULT_LOCALE);
        this.setZoneId(DEFAULT_ZONE_ID);
        this.put("buttons", this.buttons);
    }

    public DateTimeFormElementConfiguration(Format format) {
        this();
        this.setFormat(format);
    }

    public DateTimeFormElementConfiguration(ZoneId zoneId) {
        this();
        this.setZoneId(zoneId);
    }

    public DateTimeFormElementConfiguration(Format format, ZoneId zoneId) {
        this();
        this.setFormat(format);
        this.setZoneId(zoneId);
    }

    public DateTimeFormElementConfiguration(DateTimeFormElementConfiguration existing) {
        this.format = existing.format;
        this.locale = existing.locale;
        this.localizePatterns = existing.localizePatterns;
        this.zoneId = existing.zoneId;
        this.putAll(existing);
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(@NonNull Format format) {
        if (format == null) {
            throw new IllegalArgumentException("format is marked non-null but is null");
        }
        this.format = format;
        switch (format) {
            case DATE: {
                this.setPattern(FMT_PATTERN_DATE);
                this.setExtraPatterns(FMT_EXPORT_MOMENT_DATETIME, "YYYY-MM-DD");
                this.setExportPattern("YYYY-MM-DD");
                break;
            }
            case DATE_FULL: {
                this.setPattern(FMT_PATTERN_DATE_FULL);
                this.setExtraPatterns(FMT_EXPORT_MOMENT_DATETIME, FMT_PATTERN_DATE, "YYYY-MM-DD");
                this.setExportPattern("YYYY-MM-DD");
                break;
            }
            case TIME: {
                this.setPattern(FMT_PATTERN_TIME);
                this.setExtraPatterns(FMT_EXPORT_MOMENT_DATETIME);
                this.setExportPattern(FMT_EXPORT_MOMENT_TIME);
                break;
            }
            case DATETIME_FULL: {
                this.setPattern(FMT_PATTERN_DATETIME_FULL);
                this.setExtraPatterns(FMT_EXPORT_MOMENT_DATETIME, FMT_PATTERN_DATE, FMT_PATTERN_DATETIME, "YYYY-MM-DD");
                this.setExportPattern(FMT_EXPORT_MOMENT_DATETIME);
                break;
            }
            default: {
                this.setPattern(FMT_PATTERN_DATETIME);
                this.setExtraPatterns(FMT_EXPORT_MOMENT_DATETIME, FMT_PATTERN_DATE, "YYYY-MM-DD");
                this.setExportPattern(FMT_EXPORT_MOMENT_DATETIME);
            }
        }
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public void setPattern(String pattern) {
        this.put("format", pattern);
    }

    public void setExtraPatterns(String ... patterns) {
        this.put("extraFormats", patterns);
    }

    public void setExportPattern(String pattern) {
        this.put("exportFormat", pattern);
    }

    public void setLocale(Locale locale) {
        Assert.notNull((Object)locale);
        this.locale = locale;
        this.put("locale", locale.toLanguageTag());
    }

    public void setStepping(int minutes) {
        this.put("stepping", minutes);
    }

    public void setMinDate(Date date) {
        this.setDateAttribute("minDate", date);
    }

    public void setMinDate(LocalDate date) {
        this.setDateAttribute("minDate", date);
    }

    public void setMinDate(LocalTime date) {
        this.setDateAttribute("minDate", date);
    }

    public void setMinDate(LocalDateTime date) {
        this.setDateAttribute("minDate", date);
    }

    public void setMaxDate(Date date) {
        this.setDateAttribute("maxDate", date);
    }

    public void setMaxDate(LocalDate date) {
        this.setDateAttribute("maxDate", date);
    }

    public void setMaxDate(LocalTime date) {
        this.setDateAttribute("maxDate", date);
    }

    public void setMaxDate(LocalDateTime date) {
        this.setDateAttribute("maxDate", date);
    }

    public void setUseCurrentDate(boolean useCurrent) {
        this.put("useCurrent", useCurrent);
    }

    public void setDefaultDate(Date date) {
        this.setDateAttribute("defaultDate", date);
    }

    public void setDefaultDate(LocalDate date) {
        this.setDateAttribute("defaultDate", date);
    }

    public void setDefaultDate(LocalTime date) {
        this.setDateAttribute("defaultDate", date);
    }

    public void setDefaultDate(LocalDateTime date) {
        this.setDateAttribute("defaultDate", date);
    }

    public void setViewDate(Date date) {
        this.setDateAttribute("viewDate", date);
    }

    public void setViewDate(LocalDate date) {
        this.setDateAttribute("viewDate", date);
    }

    public void setViewDate(LocalTime date) {
        this.setDateAttribute("viewDate", date);
    }

    public void setViewDate(LocalDateTime date) {
        this.setDateAttribute("viewDate", date);
    }

    public void setDisabledDates(Date ... dates) {
        this.setDateAttribute("disabledDates", dates);
    }

    public void setDisabledDates(LocalDate ... dates) {
        this.setDateAttribute("disabledDates", dates);
    }

    public void setDisabledDates(LocalDateTime ... dates) {
        this.setDateAttribute("disabledDates", dates);
    }

    public void setEnabledDates(Date ... dates) {
        this.setDateAttribute("enabledDates", dates);
    }

    public void setEnabledDates(LocalDate ... dates) {
        this.setDateAttribute("enabledDates", dates);
    }

    public void setEnabledDates(LocalDateTime ... dates) {
        this.setDateAttribute("enabledDates", dates);
    }

    public void setSideBySide(boolean sideBySide) {
        this.put("sideBySide", sideBySide);
    }

    public void setDaysOfWeekDisabled(int ... daysOfWeek) {
        this.put("daysOfWeekDisabled", daysOfWeek);
    }

    public void setShowCalendarWeeks(boolean showCalendarWeeks) {
        this.put("calendarWeeks", showCalendarWeeks);
    }

    public void setShowTodayButton(boolean showTodayButton) {
        this.buttons.put("showToday", showTodayButton);
    }

    public void setShowClearButton(boolean showClearButton) {
        this.buttons.put("showClear", showClearButton);
    }

    public void setShowCloseButton(boolean showCloseButton) {
        this.buttons.put("showClose", showCloseButton);
    }

    public void setKeepOpen(boolean keepOpen) {
        this.put("keepOpen", keepOpen);
    }

    public void setShowInline(boolean showInline) {
        this.put("inline", showInline);
    }

    public void setKeepInvalid(boolean keepInvalid) {
        this.put("keepInvalid", keepInvalid);
    }

    public void setDateAttribute(String attributeName, Date ... dates) {
        LocalDateTime[] localDateTimes = (LocalDateTime[])Arrays.stream(dates).map(this::dateToLocalDateTime).toArray(LocalDateTime[]::new);
        this.setDateAttribute(attributeName, localDateTimes);
    }

    public LocalDateTime dateToLocalDateTime(Date date) {
        return date == null ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), this.getZoneId());
    }

    public Date localDateTimeToDate(LocalDateTime date) {
        return date == null ? null : Date.from(date.atZone(this.getZoneId()).toInstant());
    }

    public void setDateAttribute(String attributeName, LocalDate ... dates) {
        LocalDateTime[] localDateTimes = (LocalDateTime[])Arrays.stream(dates).map(DateTimeFormElementConfiguration::localDateToLocalDateTime).toArray(LocalDateTime[]::new);
        this.setDateAttribute(attributeName, localDateTimes);
    }

    public static LocalDateTime localDateToLocalDateTime(LocalDate date) {
        return date == null ? null : date.atStartOfDay();
    }

    public void setDateAttribute(String attributeName, LocalTime ... dates) {
        LocalDateTime[] localDateTimes = (LocalDateTime[])Arrays.stream(dates).map(DateTimeFormElementConfiguration::localTimeToLocalDateTime).toArray(LocalDateTime[]::new);
        this.setDateAttribute(attributeName, localDateTimes);
    }

    public static LocalDateTime localTimeToLocalDateTime(LocalTime time) {
        return time == null ? null : time.atDate(LocalDate.now());
    }

    public void setDateAttribute(String attributeName, LocalDateTime ... dates) {
        if (dates == null || dates.length == 1 && dates[0] == null) {
            this.remove(attributeName);
        } else if (dates.length == 1) {
            this.put(attributeName, JAVA_DATE_TIME_FORMATTER.format(dates[0]));
        } else {
            ArrayList<String> formatted = new ArrayList<String>(dates.length);
            for (LocalDateTime date : dates) {
                formatted.add(JAVA_DATE_TIME_FORMATTER.format(date));
            }
            this.put(attributeName, formatted.toArray());
        }
    }

    public boolean isLocalizePatterns() {
        return this.localizePatterns;
    }

    public void setLocalizePatterns(boolean localizePatterns) {
        this.localizePatterns = localizePatterns;
    }

    public DateTimeFormElementConfiguration localize(Locale locale) {
        DateTimeFormElementConfiguration clone = new DateTimeFormElementConfiguration(this);
        if (this.localizePatterns) {
            clone.setLocale(locale);
        }
        return clone;
    }

    public DateFormat createDateFormat() {
        DateFormat dateFormat = null;
        switch (this.format) {
            case DATE: {
                dateFormat = DateFormat.getDateInstance(2, this.locale);
                break;
            }
            case DATE_FULL: {
                dateFormat = DateFormat.getDateInstance(0, this.locale);
                break;
            }
            case TIME: {
                dateFormat = DateFormat.getTimeInstance(3, this.locale);
                break;
            }
            case DATETIME: {
                dateFormat = DateFormat.getDateTimeInstance(2, 3, this.locale);
                break;
            }
            case DATETIME_FULL: {
                dateFormat = DateFormat.getDateTimeInstance(1, 2, this.locale);
            }
        }
        return dateFormat;
    }

    public DateTimeFormatter createDateTimeFormatter() {
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
        switch (this.format) {
            case DATE: {
                dateTimeFormatterBuilder.append(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM));
                break;
            }
            case DATE_FULL: {
                dateTimeFormatterBuilder.append(DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL));
                break;
            }
            case TIME: {
                dateTimeFormatterBuilder.append(DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT));
                break;
            }
            case DATETIME: {
                dateTimeFormatterBuilder.append(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.SHORT));
                break;
            }
            case DATETIME_FULL: {
                dateTimeFormatterBuilder.append(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG, FormatStyle.MEDIUM));
            }
        }
        return dateTimeFormatterBuilder.toFormatter(this.locale);
    }

    public static enum Format {
        DATE,
        DATE_FULL,
        TIME,
        DATETIME,
        DATETIME_FULL;

    }
}

