/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements;

import com.foreach.across.modules.bootstrapui.elements.Grid;

public class FormLayout {
    private Type type = Type.DEFAULT;
    private boolean showLabels = true;
    private Grid grid = null;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
    }

    public Grid getGrid() {
        return this.grid;
    }

    public void setGrid(Grid grid) {
        this.grid = grid;
    }

    public static FormLayout normal() {
        return new FormLayout();
    }

    public static FormLayout inline(boolean showLabels) {
        FormLayout layout = new FormLayout();
        layout.setType(Type.INLINE);
        layout.setShowLabels(showLabels);
        return layout;
    }

    public static FormLayout horizontal(int columnsForLabel) {
        int columnsForControl = 12 - columnsForLabel;
        if (columnsForControl <= 0) {
            throw new IllegalArgumentException("Unable to auto-create a grid with " + columnsForLabel + " label column width");
        }
        return FormLayout.horizontal(Grid.position(Grid.Device.MD.width(columnsForLabel)), Grid.position(Grid.Device.MD.width(columnsForControl)));
    }

    public static FormLayout horizontal(Grid.Position labelColumn, Grid.Position controlColumn) {
        return FormLayout.horizontal(Grid.create(labelColumn, controlColumn));
    }

    public static FormLayout horizontal(Grid grid) {
        FormLayout layout = new FormLayout();
        layout.setType(Type.HORIZONTAL);
        layout.setGrid(grid);
        return layout;
    }

    public static enum Type {
        DEFAULT,
        INLINE,
        HORIZONTAL;

    }
}

