/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements;

import com.foreach.across.modules.bootstrapui.elements.FormLayout;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.elements.AbstractNodeViewElement;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;

public class FormViewElement
extends AbstractNodeViewElement {
    public static final String ELEMENT_TYPE = "bootstrapForm";
    public static final String ENCTYPE_PLAIN = "text/plain";
    public static final String ENCTYPE_MULTIPART = "multipart/form-data";
    public static final String ENCTYPE_URLENCODED = "application/x-www-form-urlencoded";
    private FormLayout formLayout;
    private String commandAttribute;
    private Object commandObject;
    private Errors errors;

    public FormViewElement() {
        super("form");
        this.setElementType(ELEMENT_TYPE);
        this.setAttribute("role", "form");
        this.setMethod(HttpMethod.POST);
    }

    public FormLayout getFormLayout() {
        return this.formLayout;
    }

    public FormViewElement setFormLayout(FormLayout formLayout) {
        this.formLayout = formLayout;
        this.removeCssClass("form-horizontal", "form-inline");
        if (formLayout != null) {
            if (FormLayout.Type.HORIZONTAL.equals((Object)formLayout.getType())) {
                this.addCssClass("form-horizontal");
            } else if (FormLayout.Type.INLINE.equals((Object)formLayout.getType())) {
                this.addCssClass("form-inline");
            }
        }
        return this;
    }

    public String getCommandAttribute() {
        return this.commandAttribute;
    }

    public FormViewElement setCommandAttribute(String commandAttribute) {
        this.commandAttribute = commandAttribute;
        return this;
    }

    public HttpMethod getMethod() {
        return HttpMethod.valueOf((String)StringUtils.upperCase((String)((String)this.getAttribute("method"))));
    }

    public FormViewElement setMethod(HttpMethod httpMethod) {
        Assert.isTrue((httpMethod == HttpMethod.GET || httpMethod == HttpMethod.POST ? 1 : 0) != 0, (String)"Method POST or GET is required.");
        return this.setAttribute("method", StringUtils.lowerCase((String)httpMethod.toString()));
    }

    public String getAction() {
        return (String)this.getAttribute("action", String.class);
    }

    public FormViewElement setAction(String url) {
        return this.setAttribute("action", url);
    }

    public FormViewElement setName(String name) {
        super.setName(name);
        if (this.getFormName() == null) {
            this.setFormName(name);
        }
        return this;
    }

    public String getFormName() {
        return (String)this.getAttribute("name", String.class);
    }

    public FormViewElement setFormName(String name) {
        return this.setAttribute("name", name);
    }

    public String getEncType() {
        return (String)this.getAttribute("enctype", String.class);
    }

    public FormViewElement setEncType(String encType) {
        return this.setAttribute("enctype", encType);
    }

    public String getAcceptCharSet() {
        return (String)this.getAttribute("accept-charset", String.class);
    }

    public FormViewElement setAcceptCharSet(String charSet) {
        return this.setAttribute("accept-charset", charSet);
    }

    public boolean isAutoComplete() {
        return !this.hasAttribute("autocomplete") || StringUtils.equals((CharSequence)((String)this.getAttribute("autocomplete")), (CharSequence)"on");
    }

    public FormViewElement setAutoComplete(boolean autoComplete) {
        return this.setAttribute("autocomplete", autoComplete ? "on" : "off");
    }

    public boolean isNoValidate() {
        return this.hasAttribute("novalidate");
    }

    public FormViewElement setNoValidate(boolean noValidate) {
        if (noValidate) {
            this.setAttribute("novalidate", "novalidate");
        } else {
            this.removeAttribute("novalidate");
        }
        return this;
    }

    public FormViewElement addCssClass(String ... cssClass) {
        super.addCssClass(cssClass);
        return this;
    }

    public FormViewElement removeCssClass(String ... cssClass) {
        super.removeCssClass(cssClass);
        return this;
    }

    public FormViewElement setAttributes(Map<String, Object> attributes) {
        super.setAttributes(attributes);
        return this;
    }

    public FormViewElement setAttribute(String attributeName, Object attributeValue) {
        super.setAttribute(attributeName, attributeValue);
        return this;
    }

    public FormViewElement addAttributes(Map<String, Object> attributes) {
        super.addAttributes(attributes);
        return this;
    }

    public FormViewElement removeAttribute(String attributeName) {
        super.removeAttribute(attributeName);
        return this;
    }

    public FormViewElement setCustomTemplate(String customTemplate) {
        super.setCustomTemplate(customTemplate);
        return this;
    }

    protected FormViewElement setElementType(String elementType) {
        super.setElementType(elementType);
        return this;
    }

    public FormViewElement addChild(ViewElement element) {
        super.addChild(element);
        return this;
    }

    public FormViewElement addChildren(Collection<? extends ViewElement> elements) {
        super.addChildren(elements);
        return this;
    }

    public FormViewElement addFirstChild(ViewElement element) {
        super.addFirstChild(element);
        return this;
    }

    public FormViewElement clearChildren() {
        super.clearChildren();
        return this;
    }

    public FormViewElement apply(Consumer<ContainerViewElement> consumer) {
        super.apply(consumer);
        return this;
    }

    public <U extends ViewElement> FormViewElement applyUnsafe(Consumer<U> consumer) {
        super.applyUnsafe(consumer);
        return this;
    }

    protected FormViewElement setTagName(String tagName) {
        super.setTagName(tagName);
        return this;
    }

    public FormViewElement setHtmlId(String htmlId) {
        super.setHtmlId(htmlId);
        return this;
    }

    public FormViewElement set(ViewElement.WitherSetter ... setters) {
        super.set(setters);
        return this;
    }

    public FormViewElement remove(ViewElement.WitherRemover ... functions) {
        super.remove(functions);
        return this;
    }

    public Object getCommandObject() {
        return this.commandObject;
    }

    public FormViewElement setCommandObject(Object commandObject) {
        this.commandObject = commandObject;
        return this;
    }

    public Errors getErrors() {
        return this.errors;
    }

    public FormViewElement setErrors(Errors errors) {
        this.errors = errors;
        return this;
    }
}

