/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Grid
extends ArrayList<Position> {
    public Grid() {
        super(12);
    }

    @Override
    public String toString() {
        ArrayList<String> strings = new ArrayList<String>(this.size());
        for (Position position : this) {
            strings.add("[" + position.toString() + "]");
        }
        return "Grid{" + StringUtils.join(strings, (String)",") + "}";
    }

    public static Grid create(int ... widths) {
        Grid grid = new Grid();
        Arrays.stream(widths).forEach((int w) -> grid.add(Grid.position(Device.MD.width(w))));
        return grid;
    }

    public static Grid create(Position ... positions) {
        Grid grid = new Grid();
        Collections.addAll(grid, positions);
        return grid;
    }

    public static Position position(DeviceGridLayout ... layouts) {
        Position position = new Position();
        Collections.addAll(position, layouts);
        return position;
    }

    public static class Position
    extends ArrayList<DeviceGridLayout> {
        public Position() {
            super(4);
        }

        public Position asOffset() {
            Position position = new Position();
            for (DeviceGridLayout layout : this) {
                if (!(layout instanceof Column)) continue;
                position.add(((Column)layout).asOffset());
            }
            return position;
        }

        @Override
        public String toString() {
            ArrayList<String> strings = new ArrayList<String>(this.size());
            for (DeviceGridLayout action : this) {
                strings.add(action.toString());
            }
            return StringUtils.join(strings, (String)" ");
        }
    }

    public static class Column
    implements DeviceGridLayout {
        private final String token;
        private final int width;

        public Column(String token, int width) {
            this.token = token;
            this.width = width;
        }

        public DeviceGridLayout asWidth() {
            return new SingleCssClassDeviceGridLayout("col-" + this.token + "-" + this.width);
        }

        public DeviceGridLayout asOffset() {
            return new SingleCssClassDeviceGridLayout("col-" + this.token + "-offset-" + this.width);
        }

        public DeviceGridLayout asPull() {
            return new SingleCssClassDeviceGridLayout("col-" + this.token + "-pull-" + this.width);
        }

        public DeviceGridLayout asPush() {
            return new SingleCssClassDeviceGridLayout("col-" + this.token + "-push-" + this.width);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Column column = (Column)o;
            return Objects.equals(this.width, column.width) && Objects.equals(this.token, column.token);
        }

        public int hashCode() {
            return Objects.hash(this.token, this.width);
        }

        public String toString() {
            return this.asWidth().toString();
        }
    }

    public static class Visibility
    implements DeviceGridLayout {
        private final String token;

        public Visibility(String token) {
            this.token = token;
        }

        public DeviceGridLayout block() {
            return new SingleCssClassDeviceGridLayout("visible-" + this.token + "-block");
        }

        public DeviceGridLayout inline() {
            return new SingleCssClassDeviceGridLayout("visible-" + this.token + "-inline");
        }

        public DeviceGridLayout inlineBlock() {
            return new SingleCssClassDeviceGridLayout("visible-" + this.token + "-inline-block");
        }

        public String toString() {
            return this.block().toString();
        }
    }

    public static class Device {
        public static final Device SM = new Device("sm");
        @Deprecated
        public static final Device XS = new Device("xs");
        public static final Device MD = new Device("md");
        public static final Device LG = new Device("lg");
        public static final Device XL = new Device("xl");
        @Deprecated
        public static final Device EXTRA_SMALL = XS;
        public static final Device SMALL = SM;
        public static final Device MEDIUM = MD;
        public static final Device LARGE = LG;
        public static final Device EXTRA_LARGE = XL;
        private final String token;
        private DeviceGridLayout hidden;
        private Visibility visible;

        public Device(String token) {
            this.token = token;
            this.hidden = new SingleCssClassDeviceGridLayout("hidden-" + token);
            this.visible = new Visibility(token);
        }

        public Column width(int columns) {
            return new Column(this.token, columns);
        }

        public DeviceGridLayout hidden() {
            return this.hidden;
        }

        public Visibility visible() {
            return this.visible;
        }
    }

    public static class SingleCssClassDeviceGridLayout
    implements DeviceGridLayout {
        private final String generatedClass;

        public SingleCssClassDeviceGridLayout(String generatedClass) {
            this.generatedClass = generatedClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleCssClassDeviceGridLayout that = (SingleCssClassDeviceGridLayout)o;
            return Objects.equals(this.generatedClass, that.generatedClass);
        }

        public int hashCode() {
            return Objects.hash(this.generatedClass);
        }

        public String toString() {
            return this.generatedClass;
        }
    }

    public static interface DeviceGridLayout {
    }

    public static class Columns {
        public static final int ONE = 1;
        public static final int TWO = 2;
        public static final int THREE = 3;
        public static final int FOUR = 4;
        public static final int FIVE = 5;
        public static final int SIX = 6;
        public static final int SEVEN = 7;
        public static final int EIGHT = 8;
        public static final int NINE = 9;
        public static final int TEN = 10;
        public static final int ELEVEN = 11;
        public static final int TWELVE = 12;
    }

    public static class Width {
        public static final int QUARTER = 3;
        public static final int THIRD = 4;
        public static final int HALF = 6;
        public static final int TWO_THIRDS = 8;
        public static final int THREE_QUARTERS = 9;
        public static final int FULL = 12;
    }
}

