/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements;

import com.foreach.across.modules.bootstrapui.elements.ConfigurablePlaceholderText;
import com.foreach.across.modules.bootstrapui.elements.FormControlElement;
import com.foreach.across.modules.bootstrapui.elements.FormControlElementSupport;
import com.foreach.across.modules.bootstrapui.elements.HiddenFormElement;
import com.foreach.across.modules.bootstrapui.elements.NumericFormElementConfiguration;
import com.foreach.across.modules.bootstrapui.elements.TextboxFormElement;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class NumericFormElement
extends FormControlElementSupport
implements FormControlElement.Proxy,
ConfigurablePlaceholderText {
    public static final String ATTRIBUTE_DATA_NUMERIC = "data-bootstrapui-numeric";
    public static final String CSS_NUMERIC = "numeric";
    private Number value;
    private boolean htmlIdSpecified = false;
    private final TextboxFormElement textbox = new TextboxFormElement();
    private final HiddenFormElement hidden = new HiddenFormElement();

    public NumericFormElement() {
        super("input");
        this.setElementType("container");
        this.addCssClass(CSS_NUMERIC);
        this.addChild((ViewElement)this.textbox);
    }

    public TextboxFormElement getControl() {
        return this.textbox;
    }

    public NumericFormElementConfiguration getConfiguration() {
        return (NumericFormElementConfiguration)this.textbox.getAttribute(ATTRIBUTE_DATA_NUMERIC, NumericFormElementConfiguration.class);
    }

    public NumericFormElement setConfiguration(@NonNull NumericFormElementConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is marked non-null but is null");
        }
        this.textbox.setAttribute(ATTRIBUTE_DATA_NUMERIC, configuration);
        this.setAttribute("data-bootstrapui-adapter-type", CSS_NUMERIC);
        return this;
    }

    @Override
    public NumericFormElement setPlaceholder(String placeholder) {
        this.textbox.setPlaceholder(placeholder);
        return this;
    }

    @Override
    public String getPlaceholder() {
        return this.textbox.getPlaceholder();
    }

    @Override
    public boolean isReadonly() {
        return this.textbox.isReadonly();
    }

    @Override
    public NumericFormElement setReadonly(boolean readonly) {
        this.textbox.setReadonly(readonly);
        return this;
    }

    @Override
    public boolean isRequired() {
        return this.textbox.isRequired();
    }

    @Override
    public NumericFormElement setRequired(boolean required) {
        this.textbox.setRequired(required);
        return this;
    }

    @Override
    public String getControlName() {
        return this.hasConfiguration() ? this.hidden.getControlName() : this.textbox.getControlName();
    }

    @Override
    public NumericFormElement setControlName(String controlName) {
        this.hidden.setControlName(controlName);
        this.textbox.setControlName(controlName);
        return this;
    }

    @Override
    public boolean isDisabled() {
        return this.textbox.isDisabled();
    }

    @Override
    public NumericFormElement setDisabled(boolean disabled) {
        this.textbox.setDisabled(disabled);
        return this;
    }

    public String getTagName() {
        return this.textbox.getTagName();
    }

    public NumericFormElement addCssClass(String ... cssClass) {
        this.textbox.addCssClass(cssClass);
        return this;
    }

    public boolean hasCssClass(String cssClass) {
        return this.textbox.hasCssClass(cssClass);
    }

    public NumericFormElement removeCssClass(String ... cssClass) {
        this.textbox.removeCssClass(cssClass);
        return this;
    }

    @Override
    public NumericFormElement setHtmlId(String id) {
        this.htmlIdSpecified = StringUtils.isNotEmpty((CharSequence)id);
        this.textbox.setHtmlId(id);
        return this;
    }

    public String getHtmlId() {
        return this.textbox.getHtmlId();
    }

    public Map<String, Object> getAttributes() {
        return this.textbox.getAttributes();
    }

    public NumericFormElement setAttributes(Map<String, Object> attributes) {
        this.textbox.setAttributes((Map)attributes);
        return this;
    }

    public NumericFormElement setAttribute(String attributeName, Object attributeValue) {
        this.textbox.setAttribute(attributeName, attributeValue);
        return this;
    }

    public NumericFormElement addAttributes(Map<String, Object> attributes) {
        this.textbox.addAttributes((Map)attributes);
        return this;
    }

    public NumericFormElement removeAttribute(String attributeName) {
        this.textbox.removeAttribute(attributeName);
        return this;
    }

    public Object getAttribute(String attributeName) {
        return this.textbox.getAttribute(attributeName);
    }

    public <V, U extends V> U getAttribute(String attributeName, Class<V> expectedType) {
        return (U)this.textbox.getAttribute(attributeName, expectedType);
    }

    public boolean hasAttribute(String attributeName) {
        return this.textbox.hasAttribute(attributeName);
    }

    public Number getValue() {
        return this.value;
    }

    public NumericFormElement setValue(Number value) {
        this.value = value;
        this.textbox.setText(value != null ? Objects.toString(value) : null);
        return this;
    }

    public List<ViewElement> getChildren() {
        ArrayList<ViewElement> children = new ArrayList<ViewElement>(super.getChildren());
        String controlName = this.getControlName();
        if (this.hasConfiguration() && controlName != null) {
            if (!this.htmlIdSpecified) {
                this.textbox.setHtmlId(this.hidden.getControlName());
            }
            this.textbox.setControlName("_" + this.hidden.getControlName());
            this.hidden.setValue(this.textbox.getText());
            children.add((ViewElement)this.hidden);
        } else {
            if (!this.htmlIdSpecified) {
                this.textbox.setHtmlId(this.getControlName());
            }
            this.textbox.setControlName(this.getControlName());
        }
        return children;
    }

    private boolean hasConfiguration() {
        return this.getConfiguration() != null;
    }

    @Override
    public NumericFormElement setName(String name) {
        super.setName(name);
        return this;
    }

    public NumericFormElement setCustomTemplate(String customTemplate) {
        super.setCustomTemplate(customTemplate);
        return this;
    }

    protected NumericFormElement setElementType(String elementType) {
        super.setElementType(elementType);
        return this;
    }

    public NumericFormElement addChild(ViewElement element) {
        super.addChild(element);
        return this;
    }

    public NumericFormElement addChildren(Collection<? extends ViewElement> elements) {
        super.addChildren(elements);
        return this;
    }

    public NumericFormElement addFirstChild(ViewElement element) {
        super.addFirstChild(element);
        return this;
    }

    public NumericFormElement clearChildren() {
        super.clearChildren();
        return this;
    }

    public NumericFormElement apply(Consumer<ContainerViewElement> consumer) {
        super.apply(consumer);
        return this;
    }

    public <U extends ViewElement> NumericFormElement applyUnsafe(Consumer<U> consumer) {
        super.applyUnsafe(consumer);
        return this;
    }

    protected NumericFormElement setTagName(String tagName) {
        super.setTagName(tagName);
        return this;
    }

    public NumericFormElement set(ViewElement.WitherSetter ... setters) {
        super.set(setters);
        return this;
    }

    public NumericFormElement remove(ViewElement.WitherRemover ... functions) {
        super.remove(functions);
        return this;
    }
}

