/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.format.number.CurrencyStyleFormatter;

public class NumericFormElementConfiguration
extends HashMap<String, Object> {
    public static final String ROUND_HALF_UP_SYMMETRIC = "S";
    public static final String ROUND_HALF_UP_ASYMMETRIC = "A";
    public static final String ROUND_HALF_DOWN_SYMMETRIC = "s";
    public static final String ROUND_HALF_DOWN_ASYMMETRIC = "a";
    public static final String ROUND_HALF_EVEN = "B";
    public static final String ROUND_UP = "U";
    public static final String ROUND_DOWN = "D";
    public static final String ROUND_CEILING = "C";
    public static final String ROUND_FLOOR = "F";
    public static final String ROUND_SWISS = "CHF";
    public static final String NEGATIVE_PARENTHESES = "(,)";
    public static final String NEGATIVE_BRACKETS = "[,]";
    public static final String NEGATIVE_BRACES = "{,}";
    public static final String NEGATIVE_ANGLES = "<,>";
    public static final String EMPTY_EMPTY = "empty";
    public static final String EMPTY_ZERO = "zero";
    public static final String EMPTY_SIGN = "sign";
    @JsonIgnore
    private Format format = Format.NUMBER;
    @JsonIgnore
    private boolean localizeOutputFormat = true;
    @JsonIgnore
    private boolean localizeDecimalSymbols = true;
    @JsonIgnore
    private boolean forceWhitespaceAroundSign = false;
    @JsonIgnore
    private Currency currency;
    @JsonIgnore
    private Locale locale = LocaleContextHolder.getLocale();

    public NumericFormElementConfiguration() {
        this.setDecimalPositions(2);
        this.setMinValue(Long.MIN_VALUE);
    }

    public NumericFormElementConfiguration(Format format) {
        this();
        this.setFormat(format);
    }

    public NumericFormElementConfiguration(Currency currency) {
        this();
        this.setCurrency(currency);
    }

    public NumericFormElementConfiguration(Locale locale) {
        this();
        this.setCurrency(Currency.getInstance(locale), locale);
    }

    public NumericFormElementConfiguration(NumericFormElementConfiguration configuration) {
        this.format = configuration.format;
        this.currency = configuration.currency;
        this.localizeDecimalSymbols = configuration.localizeDecimalSymbols;
        this.localizeOutputFormat = configuration.localizeOutputFormat;
        this.forceWhitespaceAroundSign = configuration.forceWhitespaceAroundSign;
        this.putAll(configuration);
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
        if (format == Format.PERCENT) {
            this.setNegativeFormatter(null);
            this.setRoundingMode(RoundingMode.HALF_UP);
            this.setSignPositionRight(true);
            this.setSign(" %");
        } else if (format == Format.CURRENCY) {
            this.setNegativeFormatter(NEGATIVE_PARENTHESES);
            this.setRoundingMode(RoundingMode.HALF_EVEN);
            this.setSignPositionRight(false);
        } else {
            this.setRoundingMode(RoundingMode.HALF_UP);
            this.setNegativeFormatter(null);
            this.setSign(null);
        }
    }

    public void setCurrency(Currency currency) {
        this.setCurrency(currency, LocaleContextHolder.getLocale());
    }

    public void setCurrency(Currency currency, Locale locale) {
        this.currency = currency;
        if (currency != null) {
            this.setFormat(Format.CURRENCY);
            CurrencyStyleFormatter currencyFormatter = new CurrencyStyleFormatter();
            currencyFormatter.setCurrency(currency);
            currencyFormatter.setFractionDigits(0);
            String printed = currencyFormatter.print((Number)123, locale);
            this.setDecimalPositions(currency.getDefaultFractionDigits());
            this.setSignPositionRight(StringUtils.startsWith((CharSequence)printed, (CharSequence)"123"));
            this.setSign(StringUtils.replace((String)printed, (String)"123", (String)""));
        }
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setDecimalPositions(int positions) {
        this.put("decimalPlaces", (Object)positions);
    }

    public void setGroupingSeparator(Character separator) {
        this.put("digitGroupSeparator", separator == null ? "" : separator);
    }

    public void setGroupingSize(int size) {
        this.put("digitalGroupSpacing", (Object)size);
    }

    public void setDecimalSeparator(char separator) {
        this.put("decimalCharacter", (Object)Character.valueOf(separator));
    }

    public void setSign(String sign) {
        String actualSign = sign;
        if (sign != null && this.isForceWhitespaceAroundSign()) {
            actualSign = Objects.equals(Character.valueOf('s'), this.get("currencySymbolPlacement")) ? " " + StringUtils.trim((String)sign) : StringUtils.trim((String)sign) + " ";
        }
        this.put("currencySymbol", (Object)actualSign);
    }

    public void setSignPositionRight(boolean positionRight) {
        this.put("currencySymbolPlacement", (Object)Character.valueOf(positionRight ? (char)'s' : 'p'));
    }

    public void setMinValue(Number minValue) {
        this.put("minimumValue", (Object)minValue);
    }

    public void setMaxValue(Number maxValue) {
        this.put("maximumValue", (Object)maxValue);
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        this.setRoundingMode(this.convertJavaRoundingMode(roundingMode));
    }

    private String convertJavaRoundingMode(RoundingMode roundingMode) {
        switch (roundingMode) {
            case CEILING: {
                return ROUND_CEILING;
            }
            case FLOOR: {
                return ROUND_FLOOR;
            }
            case DOWN: {
                return ROUND_DOWN;
            }
            case HALF_DOWN: {
                return ROUND_HALF_DOWN_SYMMETRIC;
            }
            case HALF_UP: {
                return ROUND_HALF_UP_SYMMETRIC;
            }
            case HALF_EVEN: {
                return ROUND_HALF_EVEN;
            }
            case UP: {
                return ROUND_UP;
            }
        }
        return ROUND_HALF_UP_SYMMETRIC;
    }

    private RoundingMode toJavaRoundingMode(String roundingMode) {
        if (ROUND_CEILING.equals(roundingMode)) {
            return RoundingMode.CEILING;
        }
        if (ROUND_FLOOR.equals(roundingMode)) {
            return RoundingMode.FLOOR;
        }
        if (ROUND_DOWN.equals(roundingMode)) {
            return RoundingMode.DOWN;
        }
        if (ROUND_HALF_DOWN_SYMMETRIC.equals(roundingMode)) {
            return RoundingMode.HALF_DOWN;
        }
        if (ROUND_HALF_UP_SYMMETRIC.equals(roundingMode)) {
            return RoundingMode.HALF_UP;
        }
        if (ROUND_HALF_EVEN.equals(roundingMode)) {
            return RoundingMode.HALF_EVEN;
        }
        if (ROUND_UP.equals(roundingMode)) {
            return RoundingMode.UP;
        }
        return RoundingMode.HALF_UP;
    }

    public void setMultiplier(int multiplier) {
        this.put("multiplier", (Object)multiplier);
    }

    public int getMultiplier() {
        return this.getOrDefault("multiplier", 1);
    }

    public void setRoundingMode(String mode) {
        this.put("roundingMethod", (Object)mode);
    }

    public void setDecimalPadding(boolean padding) {
        this.put("allowDecimalPadding", (Object)padding);
    }

    public void setNegativeFormatter(String formatter) {
        this.put("negativeBracketsTypeOnBlur", (Object)formatter);
    }

    public void setEmptyBehaviour(String behaviour) {
        this.put("emptyInputBehavior", (Object)behaviour);
    }

    public boolean isLocalizeOutputFormat() {
        return this.localizeOutputFormat;
    }

    public void setLocalizeOutputFormat(boolean localizeOutputFormat) {
        this.localizeOutputFormat = localizeOutputFormat;
    }

    public boolean isLocalizeDecimalSymbols() {
        return this.localizeDecimalSymbols;
    }

    public void setLocalizeDecimalSymbols(boolean localizeDecimalSymbols) {
        this.localizeDecimalSymbols = localizeDecimalSymbols;
    }

    public boolean isForceWhitespaceAroundSign() {
        return this.forceWhitespaceAroundSign;
    }

    public void setForceWhitespaceAroundSign(boolean forceWhitespaceAroundSign) {
        this.forceWhitespaceAroundSign = forceWhitespaceAroundSign;
    }

    public NumericFormElementConfiguration localize(Locale locale) {
        NumericFormElementConfiguration clone = new NumericFormElementConfiguration(this);
        clone.locale = locale;
        if (this.isLocalizeDecimalSymbols()) {
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
            clone.setDecimalSeparator(this.format == Format.CURRENCY ? symbols.getMonetaryDecimalSeparator() : symbols.getDecimalSeparator());
            if (!"".equals(clone.get("digitGroupSeparator"))) {
                clone.setGroupingSeparator(Character.valueOf(symbols.getGroupingSeparator()));
            }
        }
        if (this.isLocalizeOutputFormat()) {
            if (this.format == Format.CURRENCY) {
                Currency currency = this.currency;
                if (currency == null) {
                    currency = Currency.getInstance(locale);
                    clone.setCurrency(currency);
                }
                NumberFormat numberFormat = NumberFormat.getCurrencyInstance(locale);
                numberFormat.setMaximumFractionDigits(0);
                numberFormat.setCurrency(currency);
                String printed = numberFormat.format(123L);
                clone.sign(StringUtils.replace((String)printed, (String)"123", (String)""), StringUtils.startsWith((CharSequence)printed, (CharSequence)"123"));
            } else if (this.format == Format.PERCENT) {
                NumberFormat numberFormat = NumberFormat.getPercentInstance(locale);
                numberFormat.setMaximumFractionDigits(0);
                String printed = numberFormat.format(new BigDecimal("0.11"));
                clone.sign(StringUtils.replace((String)printed, (String)"11", (String)""), StringUtils.startsWith((CharSequence)printed, (CharSequence)"11"));
            }
        }
        return clone;
    }

    private void sign(String sign, boolean positionRight) {
        this.setSignPositionRight(positionRight);
        this.setSign(sign);
    }

    @Override
    public Object put(String key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        return super.put(key, value);
    }

    public NumberFormat createNumberFormat() {
        String negativeFormatter;
        DecimalFormat format = new DecimalFormat();
        format.setGroupingSize(this.getOrDefault("digitalGroupSpacing", 3));
        format.setGroupingUsed(!"".equals(this.get("digitGroupSeparator")));
        format.setMaximumFractionDigits((Integer)this.get("decimalPlaces"));
        format.setMinimumFractionDigits(format.getMaximumFractionDigits());
        format.setRoundingMode(this.toJavaRoundingMode((String)this.get("roundingMethod")));
        format.setMultiplier(this.getMultiplier());
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(this.locale);
        symbols.setGroupingSeparator(format.isGroupingUsed() ? this.getOrDefault("digitGroupSeparator", Character.valueOf(',')).charValue() : (char)',');
        symbols.setDecimalSeparator(this.getOrDefault("decimalCharacter", Character.valueOf('.')).charValue());
        String sign = (String)this.get("currencySymbol");
        if (sign != null) {
            boolean signSuffix;
            boolean bl = signSuffix = 's' == this.getOrDefault("currencySymbolPlacement", Character.valueOf('p')).charValue();
            if (signSuffix) {
                format.setPositiveSuffix(sign);
                format.setNegativeSuffix(sign);
            } else {
                format.setPositivePrefix(sign);
                format.setPositivePrefix(sign);
            }
        }
        if ((negativeFormatter = (String)this.get("negativeBracketsTypeOnBlur")) != null) {
            symbols.setMinusSign('+');
            format.setNegativePrefix(negativeFormatter.split(",")[0] + format.getPositivePrefix());
            format.setNegativeSuffix(format.getPositiveSuffix() + negativeFormatter.split(",")[1]);
        }
        format.setDecimalFormatSymbols(symbols);
        return format;
    }

    public static NumericFormElementConfiguration percent(int decimalPositions, boolean forceWhitespaceAroundSign) {
        NumericFormElementConfiguration configuration = new NumericFormElementConfiguration(Format.PERCENT);
        configuration.setDecimalPositions(decimalPositions);
        configuration.setForceWhitespaceAroundSign(forceWhitespaceAroundSign);
        return configuration;
    }

    public static NumericFormElementConfiguration currency(Currency currency, int decimalPositions, boolean forceWhitespaceAroundSign) {
        NumericFormElementConfiguration configuration = new NumericFormElementConfiguration();
        configuration.setForceWhitespaceAroundSign(forceWhitespaceAroundSign);
        configuration.setCurrency(currency);
        configuration.setDecimalPositions(decimalPositions);
        return configuration;
    }

    public static enum Format {
        NUMBER,
        PERCENT,
        CURRENCY;

    }
}

