/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements;

import com.foreach.across.modules.bootstrapui.styles.BootstrapStyleRule;
import com.foreach.across.modules.bootstrapui.styles.BootstrapStyles;
import lombok.NonNull;

public final class Size {
    public static final Size DEFAULT = new Size("", true, null);
    public static final Size LARGE = new Size("lg", true, BootstrapStyles.css.button.large);
    public static final Size SMALL = new Size("sm", true, BootstrapStyles.css.button.small);
    private final boolean isDefault;
    private final String name;
    private final BootstrapStyleRule bootstrapStyleRule;

    private Size(@NonNull String name, boolean isDefault, BootstrapStyleRule bootstrapStyleRule) {
        if (name == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        this.name = name;
        this.isDefault = isDefault;
        this.bootstrapStyleRule = bootstrapStyleRule;
    }

    public String getName() {
        return this.name;
    }

    public String forPrefix(String prefix) {
        return this.isDefault ? prefix + "-" + this.name : this.name;
    }

    public boolean isDefaultSize() {
        return this.isDefault;
    }

    BootstrapStyleRule toBootstrapStyleRule() {
        return this.bootstrapStyleRule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Size size = (Size)o;
        if (this.isDefault != size.isDefault) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(size.name) : size.name != null);
    }

    public int hashCode() {
        int result = this.isDefault ? 1 : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    static Size fromBootstrapStyleRule(@NonNull BootstrapStyleRule styleRule) {
        if (styleRule == null) {
            throw new IllegalArgumentException("styleRule is marked non-null but is null");
        }
        if (styleRule.equals(Size.LARGE.bootstrapStyleRule)) {
            return LARGE;
        }
        if (styleRule.equals(Size.SMALL.bootstrapStyleRule)) {
            return SMALL;
        }
        return null;
    }
}

