/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements;

import com.foreach.across.modules.bootstrapui.styles.BootstrapStyleRule;
import com.foreach.across.modules.bootstrapui.styles.BootstrapStyles;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;

public class Style
implements Serializable {
    private static final long serialVersionUID = 1186095031223055070L;
    public static final Style DEFAULT = new Style("default", true);
    public static final Style ACTIVE = new Style("active", true);
    public static final Style LIGHT = new Style("light", true);
    public static final Style DARK = new Style("dark", true);
    public static final Style PRIMARY = new Style("primary", true);
    public static final Style SECONDARY = new Style("secondary", true);
    public static final Style SUCCESS = new Style("success", true);
    public static final Style INFO = new Style("info", true);
    public static final Style WARNING = new Style("warning", true);
    public static final Style DANGER = new Style("danger", true);
    private final boolean isDefault;
    private final String name;

    public Style(String name) {
        this(name, false);
    }

    private Style(@NonNull String name, boolean isDefault) {
        if (name == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        this.name = name;
        this.isDefault = isDefault;
    }

    public String getName() {
        return this.name;
    }

    public String forPrefix(String prefix) {
        return this.isDefault && !StringUtils.isBlank((CharSequence)prefix) ? prefix + "-" + this.name : this.name;
    }

    public boolean isDefaultStyle() {
        return this.isDefault;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Style style = (Style)o;
        if (this.isDefault != style.isDefault) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(style.name) : style.name != null);
    }

    public int hashCode() {
        int result = this.isDefault ? 1 : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    @Deprecated
    public static class TableCell {
        @Deprecated
        public static final Style ACTIVE = ACTIVE;
        @Deprecated
        public static final Style SUCCESS = SUCCESS;
        @Deprecated
        public static final Style INFO = INFO;
        @Deprecated
        public static final Style WARNING = WARNING;
        @Deprecated
        public static final Style DANGER = DANGER;
        private static final Map<Style, BootstrapStyleRule> styleToStyleRuleMapping = new HashMap<Style, BootstrapStyleRule>(10);
        private static final Map<BootstrapStyleRule, Style> styleRuleToStyleMapping = new HashMap<BootstrapStyleRule, Style>(20);

        @Nullable
        public static Style fromBootstrapStyleRule(BootstrapStyleRule styleRule) {
            return styleRuleToStyleMapping.get(styleRule);
        }

        @Nullable
        public static BootstrapStyleRule toBootstrapStyleRule(Style style) {
            return styleToStyleRuleMapping.get(style);
        }

        static {
            styleToStyleRuleMapping.put(ACTIVE, BootstrapStyles.css.table.active);
            styleToStyleRuleMapping.put(SUCCESS, BootstrapStyles.css.table.success);
            styleToStyleRuleMapping.put(INFO, BootstrapStyles.css.table.info);
            styleToStyleRuleMapping.put(WARNING, BootstrapStyles.css.table.warning);
            styleToStyleRuleMapping.put(DANGER, BootstrapStyles.css.table.danger);
            styleRuleToStyleMapping.put(BootstrapStyles.css.table.active, ACTIVE);
            styleRuleToStyleMapping.put(BootstrapStyles.css.table.success, SUCCESS);
            styleRuleToStyleMapping.put(BootstrapStyles.css.table.info, INFO);
            styleRuleToStyleMapping.put(BootstrapStyles.css.table.warning, WARNING);
            styleRuleToStyleMapping.put(BootstrapStyles.css.table.danger, DANGER);
        }
    }

    @Deprecated
    public static class Table {
        @Deprecated
        public static final Style STRIPED = new Style("striped", true);
        @Deprecated
        public static final Style BORDERED = new Style("bordered", true);
        @Deprecated
        public static final Style HOVER = new Style("hover", true);
        @Deprecated
        public static final Style CONDENSED = new Style("sm", true);
        private static final Map<Style, BootstrapStyleRule> styleToStyleRuleMapping = new HashMap<Style, BootstrapStyleRule>(10);
        private static final Map<BootstrapStyleRule, Style> styleRuleToStyleMapping = new HashMap<BootstrapStyleRule, Style>(20);

        @Nullable
        public static Style fromBootstrapStyleRule(BootstrapStyleRule styleRule) {
            return styleRuleToStyleMapping.get(styleRule);
        }

        @Nullable
        public static BootstrapStyleRule toBootstrapStyleRule(Style style) {
            return styleToStyleRuleMapping.get(style);
        }

        static {
            styleToStyleRuleMapping.put(STRIPED, BootstrapStyles.css.table.striped);
            styleToStyleRuleMapping.put(BORDERED, BootstrapStyles.css.table.bordered);
            styleToStyleRuleMapping.put(HOVER, BootstrapStyles.css.table.hover);
            styleToStyleRuleMapping.put(CONDENSED, BootstrapStyles.css.table.small);
            styleRuleToStyleMapping.put(BootstrapStyles.css.table.striped, STRIPED);
            styleRuleToStyleMapping.put(BootstrapStyles.css.table.bordered, BORDERED);
            styleRuleToStyleMapping.put(BootstrapStyles.css.table.hover, HOVER);
            styleRuleToStyleMapping.put(BootstrapStyles.css.table.small, CONDENSED);
        }
    }

    public static class Button {
        public static final Style DEFAULT = DEFAULT;
        public static final Style LIGHT = LIGHT;
        public static final Style DARK = DARK;
        public static final Style PRIMARY = PRIMARY;
        public static final Style SECONDARY = SECONDARY;
        public static final Style SUCCESS = SUCCESS;
        public static final Style INFO = INFO;
        public static final Style WARNING = WARNING;
        public static final Style DANGER = DANGER;
        public static final Style LINK = new Style("link", true);
        private static final Map<Style, BootstrapStyleRule> styleToStyleRuleMapping = new HashMap<Style, BootstrapStyleRule>(10);
        private static final Map<BootstrapStyleRule, Style> styleRuleToStyleMapping = new HashMap<BootstrapStyleRule, Style>(20);

        @Nullable
        public static Style fromBootstrapStyleRule(BootstrapStyleRule styleRule) {
            return styleRuleToStyleMapping.get(styleRule);
        }

        @Nullable
        public static BootstrapStyleRule toBootstrapStyleRule(Style style) {
            return styleToStyleRuleMapping.get(style);
        }

        static {
            styleToStyleRuleMapping.put(DEFAULT, BootstrapStyles.css.button);
            styleToStyleRuleMapping.put(LIGHT, BootstrapStyles.css.button.light);
            styleToStyleRuleMapping.put(DARK, BootstrapStyles.css.button.dark);
            styleToStyleRuleMapping.put(PRIMARY, BootstrapStyles.css.button.primary);
            styleToStyleRuleMapping.put(SECONDARY, BootstrapStyles.css.button.secondary);
            styleToStyleRuleMapping.put(SUCCESS, BootstrapStyles.css.button.success);
            styleToStyleRuleMapping.put(INFO, BootstrapStyles.css.button.info);
            styleToStyleRuleMapping.put(WARNING, BootstrapStyles.css.button.warning);
            styleToStyleRuleMapping.put(DANGER, BootstrapStyles.css.button.danger);
            styleToStyleRuleMapping.put(LINK, BootstrapStyles.css.button.link);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button, DEFAULT);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button.light, LIGHT);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button.outline.light, LIGHT);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button.dark, DARK);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button.outline.dark, DARK);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button.primary, PRIMARY);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button.outline.primary, PRIMARY);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button.secondary, SECONDARY);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button.outline.secondary, SECONDARY);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button.success, SUCCESS);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button.outline.success, SUCCESS);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button.info, INFO);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button.outline.info, INFO);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button.warning, WARNING);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button.outline.warning, WARNING);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button.danger, DANGER);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button.outline.danger, DANGER);
            styleRuleToStyleMapping.put(BootstrapStyles.css.button.link, LINK);
        }
    }
}

