/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements;

import com.foreach.across.modules.bootstrapui.elements.Style;
import com.foreach.across.modules.bootstrapui.styles.BootstrapStyleRule;
import com.foreach.across.modules.bootstrapui.styles.BootstrapStyles;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.elements.AbstractNodeViewElement;
import com.foreach.across.modules.web.ui.elements.AbstractTextNodeViewElement;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.NonNull;

public class TableViewElement
extends AbstractNodeViewElement {
    public static final String ELEMENT_TYPE = "bootstrapTable";
    private final Set<Style> styles = new LinkedHashSet<Style>();
    private Caption caption;
    private ColumnGroup columnGroup;
    private Header header;
    private Footer footer;
    private Body body;
    private boolean responsive;

    public TableViewElement() {
        super("table");
        this.setElementType(ELEMENT_TYPE);
        this.set(BootstrapStyles.css.table);
    }

    @Deprecated
    public TableViewElement setStyles(@NonNull Collection<Style> styles) {
        if (styles == null) {
            throw new IllegalArgumentException("styles is marked non-null but is null");
        }
        styles.stream().map(Style.Table::toBootstrapStyleRule).filter(Objects::nonNull).forEach(xva$0 -> super.set(new ViewElement.WitherSetter[]{xva$0}));
        this.styles.addAll(styles);
        return this;
    }

    @Deprecated
    public TableViewElement addStyle(Style style) {
        BootstrapStyleRule bootstrapStyleRule = Style.Table.toBootstrapStyleRule(style);
        this.styles.add(style);
        if (bootstrapStyleRule != null) {
            super.set(new ViewElement.WitherSetter[]{bootstrapStyleRule});
        }
        return this;
    }

    @Deprecated
    public TableViewElement removeStyle(Style style) {
        this.styles.remove(style);
        BootstrapStyleRule bootstrapStyleRule = Style.Table.toBootstrapStyleRule(style);
        if (bootstrapStyleRule != null) {
            super.remove(new ViewElement.WitherRemover[]{bootstrapStyleRule});
        }
        return this;
    }

    @Deprecated
    public TableViewElement clearStyles() {
        this.styles.stream().map(Style.Table::toBootstrapStyleRule).filter(Objects::nonNull).forEach(xva$0 -> super.remove(new ViewElement.WitherRemover[]{xva$0}));
        this.styles.clear();
        return this;
    }

    public TableViewElement set(ViewElement.WitherSetter ... setters) {
        Stream.of(setters).forEach(s -> {
            Style style;
            if (s instanceof BootstrapStyleRule && (style = Style.Table.fromBootstrapStyleRule((BootstrapStyleRule)s)) != null) {
                this.styles.add(style);
            }
        });
        super.set(setters);
        return this;
    }

    public TableViewElement remove(ViewElement.WitherRemover ... functions) {
        Stream.of(functions).forEach(f -> {
            Style style;
            if (f instanceof BootstrapStyleRule && (style = Style.Table.fromBootstrapStyleRule((BootstrapStyleRule)f)) != null) {
                this.styles.remove(style);
            }
        });
        super.remove(functions);
        return this;
    }

    public TableViewElement addCssClass(String ... cssClass) {
        super.addCssClass(cssClass);
        return this;
    }

    public TableViewElement removeCssClass(String ... cssClass) {
        super.removeCssClass(cssClass);
        return this;
    }

    public TableViewElement setAttributes(Map<String, Object> attributes) {
        super.setAttributes(attributes);
        return this;
    }

    public TableViewElement setAttribute(String attributeName, Object attributeValue) {
        super.setAttribute(attributeName, attributeValue);
        return this;
    }

    public TableViewElement addAttributes(Map<String, Object> attributes) {
        super.addAttributes(attributes);
        return this;
    }

    public TableViewElement removeAttribute(String attributeName) {
        super.removeAttribute(attributeName);
        return this;
    }

    public TableViewElement setName(String name) {
        super.setName(name);
        return this;
    }

    public TableViewElement setCustomTemplate(String customTemplate) {
        super.setCustomTemplate(customTemplate);
        return this;
    }

    protected TableViewElement setElementType(String elementType) {
        super.setElementType(elementType);
        return this;
    }

    public TableViewElement addChild(ViewElement element) {
        super.addChild(element);
        return this;
    }

    public TableViewElement addChildren(Collection<? extends ViewElement> elements) {
        super.addChildren(elements);
        return this;
    }

    public TableViewElement addFirstChild(ViewElement element) {
        super.addFirstChild(element);
        return this;
    }

    public TableViewElement clearChildren() {
        super.clearChildren();
        return this;
    }

    public TableViewElement apply(Consumer<ContainerViewElement> consumer) {
        super.apply(consumer);
        return this;
    }

    public <U extends ViewElement> TableViewElement applyUnsafe(Consumer<U> consumer) {
        super.applyUnsafe(consumer);
        return this;
    }

    protected TableViewElement setTagName(String tagName) {
        super.setTagName(tagName);
        return this;
    }

    public TableViewElement setHtmlId(String htmlId) {
        super.setHtmlId(htmlId);
        return this;
    }

    public Set<Style> getStyles() {
        return this.styles;
    }

    public Caption getCaption() {
        return this.caption;
    }

    public ColumnGroup getColumnGroup() {
        return this.columnGroup;
    }

    public Header getHeader() {
        return this.header;
    }

    public Footer getFooter() {
        return this.footer;
    }

    public Body getBody() {
        return this.body;
    }

    public boolean isResponsive() {
        return this.responsive;
    }

    public TableViewElement setCaption(Caption caption) {
        this.caption = caption;
        return this;
    }

    public TableViewElement setColumnGroup(ColumnGroup columnGroup) {
        this.columnGroup = columnGroup;
        return this;
    }

    public TableViewElement setHeader(Header header) {
        this.header = header;
        return this;
    }

    public TableViewElement setFooter(Footer footer) {
        this.footer = footer;
        return this;
    }

    public TableViewElement setBody(Body body) {
        this.body = body;
        return this;
    }

    public TableViewElement setResponsive(boolean responsive) {
        this.responsive = responsive;
        return this;
    }

    public static class Cell
    extends AbstractTextNodeViewElement {
        private boolean heading;
        private Style style;
        private Integer columnSpan;

        public Cell() {
            super("td");
            this.setElementType("container.cell");
        }

        public Cell setStyle(Style newStyle) {
            BootstrapStyleRule bootstrapStyleRule;
            if (this.style != null && (bootstrapStyleRule = Style.TableCell.toBootstrapStyleRule(this.style)) != null) {
                super.remove(new ViewElement.WitherRemover[]{bootstrapStyleRule});
            }
            this.style = newStyle;
            bootstrapStyleRule = Style.TableCell.toBootstrapStyleRule(newStyle);
            if (bootstrapStyleRule != null) {
                super.set(new ViewElement.WitherSetter[]{bootstrapStyleRule});
            }
            return this;
        }

        public Cell set(ViewElement.WitherSetter ... setters) {
            Stream.of(setters).forEach(setter -> {
                Style newStyle;
                if (setter instanceof BootstrapStyleRule && (newStyle = Style.TableCell.fromBootstrapStyleRule((BootstrapStyleRule)setter)) != null) {
                    if (this.style != null) {
                        this.setStyle(null);
                    }
                    this.style = newStyle;
                }
            });
            super.set(setters);
            return this;
        }

        public Cell remove(ViewElement.WitherRemover ... functions) {
            super.remove(functions);
            return this;
        }

        public boolean isHeading() {
            return this.heading;
        }

        public Style getStyle() {
            return this.style;
        }

        public Integer getColumnSpan() {
            return this.columnSpan;
        }

        public Cell setHeading(boolean heading) {
            this.heading = heading;
            return this;
        }

        public Cell setColumnSpan(Integer columnSpan) {
            this.columnSpan = columnSpan;
            return this;
        }
    }

    public static class Row
    extends AbstractNodeViewElement {
        private Style style;

        public Row() {
            super("tr");
            this.setElementType("container.row");
        }

        public Style getStyle() {
            return this.style;
        }

        public Row setStyle(Style newStyle) {
            BootstrapStyleRule bootstrapStyleRule;
            if (this.style != null && (bootstrapStyleRule = Style.TableCell.toBootstrapStyleRule(this.style)) != null) {
                super.remove(new ViewElement.WitherRemover[]{bootstrapStyleRule});
            }
            this.style = newStyle;
            bootstrapStyleRule = Style.TableCell.toBootstrapStyleRule(newStyle);
            if (bootstrapStyleRule != null) {
                super.set(new ViewElement.WitherSetter[]{bootstrapStyleRule});
            }
            return this;
        }

        public Row set(ViewElement.WitherSetter ... setters) {
            Stream.of(setters).forEach(setter -> {
                Style newStyle;
                if (setter instanceof BootstrapStyleRule && (newStyle = Style.TableCell.fromBootstrapStyleRule((BootstrapStyleRule)setter)) != null) {
                    if (this.style != null) {
                        this.setStyle(null);
                    }
                    this.style = newStyle;
                }
            });
            super.set(setters);
            return this;
        }

        public Row remove(ViewElement.WitherRemover ... functions) {
            super.remove(functions);
            return this;
        }
    }

    public static class Body
    extends AbstractNodeViewElement {
        public Body() {
            super("tbody");
        }

        public Body set(ViewElement.WitherSetter ... setters) {
            super.set(setters);
            return this;
        }

        public Body remove(ViewElement.WitherRemover ... functions) {
            super.remove(functions);
            return this;
        }
    }

    public static class Footer
    extends AbstractNodeViewElement {
        public Footer() {
            super("tfoot");
        }

        public Footer set(ViewElement.WitherSetter ... setters) {
            super.set(setters);
            return this;
        }

        public Footer remove(ViewElement.WitherRemover ... functions) {
            super.remove(functions);
            return this;
        }
    }

    public static class Header
    extends AbstractNodeViewElement {
        public Header() {
            super("thead");
        }

        public Header set(ViewElement.WitherSetter ... setters) {
            super.set(setters);
            return this;
        }

        public Header remove(ViewElement.WitherRemover ... functions) {
            super.remove(functions);
            return this;
        }
    }

    public static class ColumnGroup
    extends AbstractNodeViewElement {
        public ColumnGroup() {
            super("colgroup");
        }

        public ColumnGroup set(ViewElement.WitherSetter ... setters) {
            super.set(setters);
            return this;
        }

        public ColumnGroup remove(ViewElement.WitherRemover ... functions) {
            super.remove(functions);
            return this;
        }

        public static class Column
        extends AbstractNodeViewElement {
            public Column() {
                super("col");
            }

            public Column setSpan(Integer span) {
                if (span == null) {
                    this.removeAttribute("span");
                } else {
                    this.setAttribute("span", span);
                }
                return this;
            }
        }
    }

    public static class Caption
    extends AbstractTextNodeViewElement {
        public Caption() {
            super("caption");
        }

        public Caption set(ViewElement.WitherSetter ... setters) {
            super.set(setters);
            return this;
        }

        public Caption remove(ViewElement.WitherRemover ... functions) {
            super.remove(functions);
            return this;
        }
    }
}

