/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.autosuggest;

import com.foreach.across.modules.bootstrapui.elements.HiddenFormElement;
import com.foreach.across.modules.bootstrapui.elements.TextboxFormElement;
import com.foreach.across.modules.bootstrapui.elements.autosuggest.AutoSuggestFormElement;
import com.foreach.across.modules.bootstrapui.elements.autosuggest.AutoSuggestFormElementConfiguration;
import com.foreach.across.modules.bootstrapui.elements.builder.FormControlElementBuilderSupport;
import com.foreach.across.modules.bootstrapui.elements.builder.ScriptViewElementBuilder;
import com.foreach.across.modules.bootstrapui.elements.builder.TextboxFormElementBuilder;
import com.foreach.across.modules.bootstrapui.ui.factories.BootstrapViewElements;
import com.foreach.across.modules.web.resource.WebResourceRegistry;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilder;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.NonNull;
import org.springframework.http.MediaType;

public class AutoSuggestFormElementBuilder
extends FormControlElementBuilderSupport<AutoSuggestFormElement, AutoSuggestFormElementBuilder> {
    public static final String CSS_TYPEAHEAD_MODULE = "axbum-typeahead";
    public static final String CSS_TYPEAHEAD = "js-typeahead";
    public static final String CSS_TYPEAHEAD_VALUE = "js-typeahead-value";
    private AutoSuggestFormElementConfiguration configuration = new AutoSuggestFormElementConfiguration();
    private Map<String, ViewElementBuilder> templatesByKey = new HashMap<String, ViewElementBuilder>();
    private TextboxFormElementBuilder textboxBuilder;
    private Function<String, String> linkBuilder;

    public AutoSuggestFormElementBuilder configuration(@NonNull AutoSuggestFormElementConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is marked non-null but is null");
        }
        this.configuration = configuration;
        return this;
    }

    public AutoSuggestFormElementBuilder notFoundTemplate(ViewElementBuilder template) {
        return this.notFoundTemplate("default", template);
    }

    public AutoSuggestFormElementBuilder notFoundTemplate(String datasetId, ViewElementBuilder template) {
        this.templatesByKey.put(String.format("notFound-%s", datasetId), template);
        return this;
    }

    public AutoSuggestFormElementBuilder suggestionTemplate(ViewElementBuilder template) {
        return this.suggestionTemplate("default", template);
    }

    public AutoSuggestFormElementBuilder suggestionTemplate(String datasetId, ViewElementBuilder template) {
        this.templatesByKey.put(String.format("suggestion-%s", datasetId), template);
        return this;
    }

    public AutoSuggestFormElementBuilder pendingTemplate(ViewElementBuilder template) {
        return this.pendingTemplate("default", template);
    }

    public AutoSuggestFormElementBuilder pendingTemplate(String name, ViewElementBuilder template) {
        this.templatesByKey.put(String.format("pending-%s", name), template);
        return this;
    }

    public AutoSuggestFormElementBuilder headerTemplate(ViewElementBuilder template) {
        return this.headerTemplate("default", template);
    }

    public AutoSuggestFormElementBuilder headerTemplate(String name, ViewElementBuilder template) {
        this.templatesByKey.put(String.format("header-%s", name), template);
        return this;
    }

    public AutoSuggestFormElementBuilder footerTemplate(ViewElementBuilder template) {
        return this.footerTemplate("default", template);
    }

    public AutoSuggestFormElementBuilder footerTemplate(String name, ViewElementBuilder template) {
        this.templatesByKey.put(String.format("footer-%s", name), template);
        return this;
    }

    public AutoSuggestFormElementBuilder linkBuilder(Function<String, String> linkBuilder) {
        this.linkBuilder = linkBuilder;
        return this;
    }

    protected AutoSuggestFormElement createElement(ViewElementBuilderContext builderContext) {
        TextboxFormElement textbox = this.createTextbox(builderContext);
        HiddenFormElement value = new HiddenFormElement();
        value.addCssClass(CSS_TYPEAHEAD_VALUE);
        AutoSuggestFormElement container = new AutoSuggestFormElement(textbox, value);
        container.addCssClass(CSS_TYPEAHEAD_MODULE);
        container.setConfiguration(this.configuration.translate(url -> this.buildLink((String)url, builderContext)));
        container.addChild((ViewElement)textbox);
        container.addChild((ViewElement)value);
        this.templatesByKey.entrySet().stream().map(entry -> this.createTemplateElement((String)entry.getKey(), (ViewElementBuilder)entry.getValue()).build(builderContext)).forEach(container::addChild);
        return this.apply(container, builderContext);
    }

    private ViewElementBuilder createTemplateElement(String key, ViewElementBuilder template) {
        return ((ScriptViewElementBuilder)BootstrapViewElements.bootstrap.builders.script().data("template", key)).type(MediaType.TEXT_HTML).add(new ViewElementBuilder[]{template});
    }

    protected String buildLink(String link, ViewElementBuilderContext builderContext) {
        if (this.linkBuilder != null) {
            return this.linkBuilder.apply(link);
        }
        return builderContext.buildLink(link);
    }

    protected void registerWebResources(WebResourceRegistry webResourceRegistry) {
        webResourceRegistry.addPackage(new String[]{"bootstrapui-formelements"});
    }

    private TextboxFormElement createTextbox(ViewElementBuilderContext context) {
        TextboxFormElement textbox = this.textboxBuilder != null ? (TextboxFormElement)this.textboxBuilder.build(context) : (TextboxFormElement)BootstrapViewElements.bootstrap.builders.textbox().type(TextboxFormElement.Type.SEARCH).attribute("autocomplete", "off").build(context);
        textbox.addCssClass(CSS_TYPEAHEAD);
        return textbox;
    }

    public AutoSuggestFormElementBuilder textboxBuilder(TextboxFormElementBuilder textboxBuilder) {
        this.textboxBuilder = textboxBuilder;
        return this;
    }
}

