/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.autosuggest;

import com.foreach.across.modules.bootstrapui.utils.ElementConfigurationMap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class AutoSuggestFormElementConfiguration
extends ElementConfigurationMap<AutoSuggestFormElementConfiguration> {
    public static final String ATTR_DATASETS = "_datasets";
    public static final String DEFAULT_DATASET = "default";
    public static final String DEFAULT_ENDPOINT = "/autosuggest?query={{query}}&field={{controlName}}";
    private static final String ATTR_ENDPOINT = "endpoint";

    public AutoSuggestFormElementConfiguration() {
        this.highlight(true).showHint(true).minLength(1).setAttribute(ATTR_DATASETS, new ArrayList());
    }

    public void setEndpoint(@NonNull String endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint is marked non-null but is null");
        }
        this.put(ATTR_ENDPOINT, endpoint);
    }

    public String getEndpoint() {
        return (String)this.get(ATTR_ENDPOINT);
    }

    public AutoSuggestFormElementConfiguration showHint(boolean showHint) {
        return (AutoSuggestFormElementConfiguration)this.setAttribute("hint", showHint);
    }

    public AutoSuggestFormElementConfiguration highlight(boolean highlight) {
        return (AutoSuggestFormElementConfiguration)this.setAttribute("highlight", highlight);
    }

    public AutoSuggestFormElementConfiguration minLength(int minLength) {
        return (AutoSuggestFormElementConfiguration)this.setAttribute("minLength", minLength);
    }

    public AutoSuggestFormElementConfiguration withDataSet(String dataSetName, Consumer<DataSet> consumer) {
        DataSet dataSet = this.getDataSet(dataSetName);
        if (dataSet == null) {
            dataSet = AutoSuggestFormElementConfiguration.createDataSet().name(dataSetName);
            this.addDataSet(dataSet);
        }
        consumer.accept(dataSet);
        return this;
    }

    public AutoSuggestFormElementConfiguration removeDataSet(String dataSetName) {
        DataSet ds = this.getDataSet(dataSetName);
        if (ds != null) {
            this.getDataSets().remove(ds);
        }
        return this;
    }

    public AutoSuggestFormElementConfiguration addDataSet(@NonNull DataSet dataSet) {
        if (dataSet == null) {
            throw new IllegalArgumentException("dataSet is marked non-null but is null");
        }
        this.removeDataSet(dataSet.getName());
        this.getDataSets().add(dataSet);
        return this;
    }

    private DataSet getDataSet(String dataSetName) {
        List<DataSet> dataSets = this.getDataSets();
        for (DataSet ds : dataSets) {
            if (!StringUtils.equals((CharSequence)ds.getName(), (CharSequence)dataSetName)) continue;
            return ds;
        }
        return null;
    }

    private List<DataSet> getDataSets() {
        return (List)this.get(ATTR_DATASETS);
    }

    public AutoSuggestFormElementConfiguration translate(Function<String, String> linkBuilder) {
        AutoSuggestFormElementConfiguration clone = new AutoSuggestFormElementConfiguration();
        clone.putAll(this);
        List<DataSet> dataSets = clone.getDataSets();
        ArrayList translated = new ArrayList(dataSets.size());
        dataSets.stream().map(ds -> ds.translate(linkBuilder)).forEach(translated::add);
        clone.put(ATTR_DATASETS, translated);
        return clone;
    }

    public static AutoSuggestFormElementConfiguration withDataSet(Consumer<DataSet> consumer) {
        return new AutoSuggestFormElementConfiguration().withDataSet(DEFAULT_DATASET, consumer);
    }

    public static DataSet createDataSet() {
        return new DataSet();
    }

    public static class DataSet
    extends ElementConfigurationMap<DataSet> {
        private DataSet() {
            this.name(UUID.randomUUID().toString());
            this.setAttribute("bloodhound", new ElementConfigurationMap());
        }

        String getName() {
            return (String)this.get("name");
        }

        public DataSet name(String name) {
            return this.setAttribute("name", name);
        }

        public DataSet remoteUrl(String remoteUrl) {
            return this.remote(options -> options.setAttribute("url", remoteUrl));
        }

        public DataSet prefetchUrl(String prefetchUrl) {
            return this.prefetch(options -> options.setAttribute("url", prefetchUrl));
        }

        public DataSet bloodhound(Consumer<ElementConfigurationMap> consumer) {
            consumer.accept(this.getBloodhound());
            return this;
        }

        public DataSet remote(Consumer<ElementConfigurationMap> consumer) {
            ElementConfigurationMap options = (ElementConfigurationMap)this.getBloodhound().computeIfAbsent("remote", key -> new ElementConfigurationMap());
            consumer.accept(options);
            return this;
        }

        public DataSet prefetch(Consumer<ElementConfigurationMap> consumer) {
            ElementConfigurationMap options = (ElementConfigurationMap)this.getBloodhound().computeIfAbsent("prefetch", key -> new ElementConfigurationMap());
            consumer.accept(options);
            return this;
        }

        private ElementConfigurationMap<?> getBloodhound() {
            return (ElementConfigurationMap)this.get("bloodhound");
        }

        @Override
        public DataSet setAttribute(String key, Object value) {
            this.put(key, value);
            return this;
        }

        public DataSet translate(Function<String, String> linkBuilder) {
            DataSet ds = new DataSet();
            ds.putAll(this);
            ElementConfigurationMap bloodhound = new ElementConfigurationMap();
            bloodhound.putAll(ds.getBloodhound());
            ds.put("bloodhound", bloodhound);
            this.translateOptions(bloodhound, "remote", linkBuilder);
            this.translateOptions(bloodhound, "prefetch", linkBuilder);
            return ds;
        }

        private void translateOptions(ElementConfigurationMap bloodhound, String optionsKey, Function<String, String> linkBuilder) {
            if (bloodhound.containsKey(optionsKey)) {
                ElementConfigurationMap options = new ElementConfigurationMap();
                options.putAll((ElementConfigurationMap)bloodhound.get(optionsKey));
                bloodhound.put(optionsKey, options);
                if (options.containsKey("url")) {
                    options.put("url", linkBuilder.apply((String)options.get("url")));
                }
            }
        }
    }
}

