/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.builder;

import com.foreach.across.modules.bootstrapui.elements.ButtonViewElement;
import com.foreach.across.modules.bootstrapui.elements.Size;
import com.foreach.across.modules.bootstrapui.elements.Style;
import com.foreach.across.modules.bootstrapui.elements.builder.AbstractLinkSupportingNodeViewElementBuilder;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilder;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.ViewElementBuilderSupport;

public class ButtonViewElementBuilder
extends AbstractLinkSupportingNodeViewElementBuilder<ButtonViewElement, ButtonViewElementBuilder> {
    private String text;
    private String title;
    private String url;
    private ButtonViewElement.Type type;
    private ButtonViewElement.State state;
    private Style style;
    private Size size;
    private ViewElementBuilderSupport.ElementOrBuilder icon;
    private boolean iconOnly = false;
    private boolean iconRight = false;

    public ButtonViewElementBuilder iconOnly(ViewElement icon) {
        return this.icon(icon).iconOnly();
    }

    public ButtonViewElementBuilder iconOnly(ViewElementBuilder icon) {
        return this.icon(icon).iconOnly();
    }

    public ButtonViewElementBuilder icon(ViewElement icon) {
        this.icon = ViewElementBuilderSupport.ElementOrBuilder.wrap((ViewElement)icon);
        return this;
    }

    public ButtonViewElementBuilder icon(ViewElementBuilder icon) {
        this.icon = ViewElementBuilderSupport.ElementOrBuilder.wrap((ViewElementBuilder)icon);
        return this;
    }

    public ButtonViewElementBuilder iconOnly() {
        return this.iconOnly(true);
    }

    public ButtonViewElementBuilder iconOnly(boolean iconOnly) {
        this.iconOnly = iconOnly;
        return this;
    }

    public ButtonViewElementBuilder iconRight() {
        this.iconRight = true;
        return this;
    }

    public ButtonViewElementBuilder iconLeft() {
        this.iconRight = false;
        return this;
    }

    public ButtonViewElementBuilder text(String text) {
        this.text = text;
        return this;
    }

    public ButtonViewElementBuilder title(String title) {
        this.title = title;
        return this;
    }

    public ButtonViewElementBuilder url(String url) {
        this.url = url;
        return this;
    }

    public ButtonViewElementBuilder submit() {
        return this.type(ButtonViewElement.Type.BUTTON_SUBMIT);
    }

    public ButtonViewElementBuilder link(String url) {
        return this.link().url(url);
    }

    public ButtonViewElementBuilder link() {
        return this.type(ButtonViewElement.Type.LINK).style(Style.Button.LINK);
    }

    public ButtonViewElementBuilder type(ButtonViewElement.Type type) {
        this.type = type;
        return this;
    }

    public ButtonViewElementBuilder disable() {
        return this.state(ButtonViewElement.State.DISABLED);
    }

    public ButtonViewElementBuilder state(ButtonViewElement.State state) {
        this.state = state;
        return this;
    }

    public ButtonViewElementBuilder style(Style style) {
        this.style = style;
        return this;
    }

    public ButtonViewElementBuilder size(Size size) {
        this.size = size;
        return this;
    }

    protected ButtonViewElement createElement(ViewElementBuilderContext builderContext) {
        ButtonViewElement button = new ButtonViewElement();
        if (this.url != null) {
            button.setUrl(this.buildLink(this.url, builderContext));
        }
        if (this.type != null) {
            button.setType(this.type);
        }
        if (this.state != null) {
            button.setState(this.state);
        }
        if (this.style != null) {
            button.setStyle(this.style);
        }
        if (this.size != null) {
            button.setSize(this.size);
        }
        if (this.title != null) {
            button.setTitle(builderContext.resolveText(this.title));
        }
        String resolvedText = builderContext.resolveText(this.text);
        if (this.iconOnly && this.icon != null) {
            if (this.text != null) {
                if (this.title == null) {
                    button.setTitle(resolvedText);
                } else {
                    button.setAttribute("aria-label", resolvedText);
                }
            }
        } else if (this.text != null) {
            button.setText(resolvedText);
        }
        if (this.icon != null) {
            if (this.iconRight) {
                button.addChild(this.icon.get(builderContext));
            } else {
                button.setIcon(this.icon.get(builderContext));
            }
        }
        return (ButtonViewElement)this.apply(button, builderContext);
    }
}

