/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.builder;

import com.foreach.across.modules.bootstrapui.elements.DateTimeFormElement;
import com.foreach.across.modules.bootstrapui.elements.DateTimeFormElementConfiguration;
import com.foreach.across.modules.bootstrapui.elements.builder.InputGroupFormElementBuilderSupport;
import com.foreach.across.modules.bootstrapui.styles.BootstrapStyles;
import com.foreach.across.modules.web.resource.WebResourceRegistry;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.HtmlViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElements;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import org.springframework.context.i18n.LocaleContextHolder;

public class DateTimeFormElementBuilder
extends InputGroupFormElementBuilderSupport<DateTimeFormElement, DateTimeFormElementBuilder> {
    private Date value;
    private LocalDateTime valueAsLocalDateTime;
    private DateTimeFormElementConfiguration configuration;

    public DateTimeFormElementConfiguration getConfiguration() {
        return this.configuration;
    }

    public DateTimeFormElementBuilder value(Date value) {
        if (value != null) {
            this.value = new Date(value.getTime());
        }
        return this;
    }

    public DateTimeFormElementBuilder value(LocalDate value) {
        this.value(DateTimeFormElementConfiguration.localDateToLocalDateTime(value));
        return this;
    }

    public DateTimeFormElementBuilder value(LocalTime value) {
        this.value(DateTimeFormElementConfiguration.localTimeToLocalDateTime(value));
        return this;
    }

    public DateTimeFormElementBuilder value(LocalDateTime value) {
        this.valueAsLocalDateTime = value;
        return this;
    }

    public DateTimeFormElementBuilder datetime() {
        return this.format(DateTimeFormElementConfiguration.Format.DATETIME);
    }

    public DateTimeFormElementBuilder date() {
        return this.format(DateTimeFormElementConfiguration.Format.DATE);
    }

    public DateTimeFormElementBuilder time() {
        return this.format(DateTimeFormElementConfiguration.Format.TIME);
    }

    public DateTimeFormElementBuilder format(DateTimeFormElementConfiguration.Format format) {
        if (this.configuration == null) {
            this.configuration = new DateTimeFormElementConfiguration(format);
        } else {
            this.configuration.setFormat(format);
        }
        if (format == DateTimeFormElementConfiguration.Format.TIME) {
            this.append((ViewElement)HtmlViewElements.html.div(new ViewElement.WitherSetter[]{BootstrapStyles.css.inputGroup.text, HtmlViewElement.Functions.children((ViewElement[])new ViewElement[]{HtmlViewElements.html.i(new ViewElement.WitherSetter[]{BootstrapStyles.css.fa.solid("clock")})})}));
        } else {
            this.append((ViewElement)HtmlViewElements.html.div(new ViewElement.WitherSetter[]{BootstrapStyles.css.inputGroup.text, HtmlViewElement.Functions.children((ViewElement[])new ViewElement[]{HtmlViewElements.html.i(new ViewElement.WitherSetter[]{BootstrapStyles.css.fa.solid("calendar")})})}));
        }
        return this;
    }

    public DateTimeFormElementBuilder configuration(DateTimeFormElementConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    protected DateTimeFormElement createElement(ViewElementBuilderContext builderContext) {
        DateTimeFormElement datetime = this.apply(new DateTimeFormElement(), builderContext);
        if (this.configuration != null) {
            datetime.setConfiguration(this.configuration.localize(LocaleContextHolder.getLocale()));
        }
        if (this.value != null) {
            datetime.setValue(this.value);
        }
        if (this.valueAsLocalDateTime != null) {
            datetime.setLocalDateTime(this.valueAsLocalDateTime);
        }
        return datetime;
    }

    protected void registerWebResources(WebResourceRegistry webResourceRegistry) {
        webResourceRegistry.addPackage(new String[]{"bootstrapui-formelements"});
    }
}

