/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.builder;

import com.foreach.across.modules.bootstrapui.elements.FormControlElement;
import com.foreach.across.modules.bootstrapui.elements.FormGroupElement;
import com.foreach.across.modules.bootstrapui.elements.FormLayout;
import com.foreach.across.modules.bootstrapui.elements.LabelFormElement;
import com.foreach.across.modules.bootstrapui.styles.AcrossBootstrapStyles;
import com.foreach.across.modules.bootstrapui.styles.BootstrapStyles;
import com.foreach.across.modules.bootstrapui.ui.factories.BootstrapViewElements;
import com.foreach.across.modules.bootstrapui.utils.BootstrapElementUtils;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilder;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.ViewElementBuilderSupport;
import com.foreach.across.modules.web.ui.elements.HtmlViewElements;
import com.foreach.across.modules.web.ui.elements.builder.AbstractNodeViewElementBuilder;

public class FormGroupElementBuilder
extends AbstractNodeViewElementBuilder<FormGroupElement, FormGroupElementBuilder> {
    private ViewElementBuilderSupport.ElementOrBuilder label;
    private ViewElementBuilderSupport.ElementOrBuilder control;
    private ViewElementBuilderSupport.ElementOrBuilder helpBlock;
    private ViewElementBuilderSupport.ElementOrBuilder descriptionBlock;
    private ViewElementBuilderSupport.ElementOrBuilder tooltip;
    private FormLayout formLayout;
    private Boolean required;
    private Boolean detectFieldErrors;
    private String[] fieldErrorsToShow;

    public Boolean isRequired() {
        return this.required;
    }

    public ViewElementBuilderSupport.ElementOrBuilder getLabel() {
        return this.label;
    }

    public ViewElementBuilderSupport.ElementOrBuilder getHelpBlock() {
        return this.helpBlock;
    }

    public <V> V getLabel(Class<V> targetClass) {
        if (targetClass.isInstance(this.label.getSource())) {
            return (V)this.label.getSource();
        }
        return null;
    }

    public ViewElementBuilderSupport.ElementOrBuilder getControl() {
        return this.control;
    }

    public <V> V getControl(Class<V> targetClass) {
        if (targetClass.isInstance(this.control.getSource())) {
            return (V)this.control.getSource();
        }
        return null;
    }

    public FormLayout getFormLayout() {
        return this.formLayout;
    }

    public FormGroupElementBuilder label(ViewElement label) {
        this.label = ViewElementBuilderSupport.ElementOrBuilder.wrap((ViewElement)label);
        return this;
    }

    public FormGroupElementBuilder label(String text) {
        this.label((ViewElementBuilder)BootstrapViewElements.bootstrap.builders.label(text));
        return this;
    }

    public FormGroupElementBuilder label(ViewElementBuilder labelBuilder) {
        this.label = ViewElementBuilderSupport.ElementOrBuilder.wrap((ViewElementBuilder)labelBuilder);
        return this;
    }

    public FormGroupElementBuilder control(ViewElement control) {
        this.control = ViewElementBuilderSupport.ElementOrBuilder.wrap((ViewElement)control);
        return this;
    }

    public FormGroupElementBuilder control(ViewElementBuilder controlBuilder) {
        this.control = ViewElementBuilderSupport.ElementOrBuilder.wrap((ViewElementBuilder)controlBuilder);
        return this;
    }

    public FormGroupElementBuilder helpBlock(String text) {
        this.helpBlock((ViewElement)HtmlViewElements.html.small(new ViewElement.WitherSetter[]{BootstrapStyles.css.form.text, AcrossBootstrapStyles.css.text.muted}).addChild((ViewElement)HtmlViewElements.html.text(text)));
        return this;
    }

    public FormGroupElementBuilder helpBlock(ViewElement helpBlock) {
        this.helpBlock = ViewElementBuilderSupport.ElementOrBuilder.wrap((ViewElement)helpBlock);
        return this;
    }

    public FormGroupElementBuilder helpBlock(ViewElementBuilder helpBlock) {
        this.helpBlock = ViewElementBuilderSupport.ElementOrBuilder.wrap((ViewElementBuilder)helpBlock);
        return this;
    }

    public FormGroupElementBuilder descriptionBlock(String text) {
        this.descriptionBlock((ViewElement)HtmlViewElements.html.p(new ViewElement.WitherSetter[]{BootstrapStyles.css.form.text, AcrossBootstrapStyles.css.text.muted}).addChild((ViewElement)HtmlViewElements.html.text(text)));
        return this;
    }

    public FormGroupElementBuilder descriptionBlock(ViewElement descriptionBlock) {
        this.descriptionBlock = ViewElementBuilderSupport.ElementOrBuilder.wrap((ViewElement)descriptionBlock);
        return this;
    }

    public FormGroupElementBuilder descriptionBlock(ViewElementBuilder descriptionBlock) {
        this.descriptionBlock = ViewElementBuilderSupport.ElementOrBuilder.wrap((ViewElementBuilder)descriptionBlock);
        return this;
    }

    public FormGroupElementBuilder tooltip(String text) {
        this.tooltip((ViewElementBuilder)BootstrapViewElements.bootstrap.builders.tooltip().text(text));
        return this;
    }

    public FormGroupElementBuilder tooltip(ViewElement tooltip) {
        this.tooltip = ViewElementBuilderSupport.ElementOrBuilder.wrap((ViewElement)tooltip);
        return this;
    }

    public FormGroupElementBuilder tooltip(ViewElementBuilder tooltip) {
        this.tooltip = ViewElementBuilderSupport.ElementOrBuilder.wrap((ViewElementBuilder)tooltip);
        return this;
    }

    public FormGroupElementBuilder formLayout(FormLayout formLayout) {
        this.formLayout = formLayout;
        return this;
    }

    public FormGroupElementBuilder required() {
        return this.required(true);
    }

    public FormGroupElementBuilder required(boolean required) {
        this.required = required;
        return this;
    }

    public FormGroupElementBuilder detectFieldErrors(boolean detectFieldErrors) {
        this.detectFieldErrors = detectFieldErrors;
        return this;
    }

    public FormGroupElementBuilder fieldErrorsToShow(String ... fieldNames) {
        this.fieldErrorsToShow = fieldNames;
        return this;
    }

    protected FormGroupElement createElement(ViewElementBuilderContext builderContext) {
        FormControlElement formControlElement;
        LabelFormElement label;
        FormGroupElement group = new FormGroupElement();
        if (this.required != null) {
            group.setRequired(this.required);
        }
        if (this.label != null) {
            group.setLabel(this.label.get(builderContext));
        }
        if (this.control != null) {
            group.setControl(this.control.get(builderContext));
        }
        if (this.fieldErrorsToShow != null) {
            group.setFieldErrorsToShow(this.fieldErrorsToShow);
        }
        if (this.detectFieldErrors != null) {
            group.setDetectFieldErrors(this.detectFieldErrors);
        }
        if (this.helpBlock != null) {
            group.setHelpBlock(this.helpBlock.get(builderContext));
        }
        if (this.descriptionBlock != null) {
            group.setDescriptionBlock(this.descriptionBlock.get(builderContext));
        }
        if (this.tooltip != null) {
            group.setTooltip(this.tooltip.get(builderContext));
        }
        if (group.getLabel() instanceof LabelFormElement && !(label = group.getLabel(LabelFormElement.class)).hasTarget() && (formControlElement = BootstrapElementUtils.getFormControl(group.getControl())) != null) {
            label.setTarget((ViewElement)formControlElement);
        }
        if (this.formLayout != null) {
            group.setFormLayout(this.formLayout);
        }
        return (FormGroupElement)this.apply(group, builderContext);
    }
}

