/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.builder;

import com.foreach.across.modules.bootstrapui.elements.NumericFormElement;
import com.foreach.across.modules.bootstrapui.elements.NumericFormElementConfiguration;
import com.foreach.across.modules.bootstrapui.elements.builder.FormControlElementBuilderSupport;
import com.foreach.across.modules.web.resource.WebResourceRegistry;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import java.util.Currency;
import java.util.Locale;
import org.springframework.context.i18n.LocaleContextHolder;

public class NumericFormElementBuilder
extends FormControlElementBuilderSupport<NumericFormElement, NumericFormElementBuilder> {
    private Number value;
    private NumericFormElementConfiguration configuration;

    public NumericFormElementConfiguration getConfiguration() {
        return this.configuration;
    }

    public NumericFormElementBuilder value(Number value) {
        this.value = value;
        return this;
    }

    public NumericFormElementBuilder percent() {
        NumericFormElementConfiguration configuration = new NumericFormElementConfiguration();
        configuration.setFormat(NumericFormElementConfiguration.Format.PERCENT);
        return this.configuration(configuration);
    }

    public NumericFormElementBuilder currency() {
        NumericFormElementConfiguration configuration = new NumericFormElementConfiguration();
        configuration.setFormat(NumericFormElementConfiguration.Format.CURRENCY);
        return this.configuration(configuration);
    }

    public NumericFormElementBuilder decimal(int fractionDigits) {
        NumericFormElementConfiguration configuration = new NumericFormElementConfiguration();
        configuration.setDecimalPositions(fractionDigits);
        return this.configuration(configuration);
    }

    public NumericFormElementBuilder simple() {
        return this.configuration(null);
    }

    public NumericFormElementBuilder integer() {
        NumericFormElementConfiguration configuration = new NumericFormElementConfiguration();
        configuration.setDecimalPositions(0);
        return this.configuration(configuration);
    }

    public NumericFormElementBuilder currency(Currency currency) {
        return this.configuration(new NumericFormElementConfiguration(currency));
    }

    public NumericFormElementBuilder currency(Locale locale) {
        return this.configuration(new NumericFormElementConfiguration(locale));
    }

    public NumericFormElementBuilder currency(Currency currency, Locale locale) {
        NumericFormElementConfiguration configuration = new NumericFormElementConfiguration();
        configuration.setCurrency(currency, locale);
        return this.configuration(configuration);
    }

    public NumericFormElementBuilder configuration(NumericFormElementConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    protected NumericFormElement createElement(ViewElementBuilderContext builderContext) {
        NumericFormElement numeric = this.apply(new NumericFormElement(), builderContext);
        if (this.configuration != null) {
            numeric.setConfiguration(this.configuration.localize(LocaleContextHolder.getLocale()));
        }
        if (this.value != null) {
            numeric.setValue(this.value);
        }
        return numeric;
    }

    protected void registerWebResources(WebResourceRegistry webResourceRegistry) {
        webResourceRegistry.addPackage(new String[]{"bootstrapui-formelements"});
    }
}

