/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.builder;

import com.foreach.across.modules.bootstrapui.elements.CheckboxFormElement;
import com.foreach.across.modules.bootstrapui.elements.FormControlElementSupport;
import com.foreach.across.modules.bootstrapui.elements.RadioFormElement;
import com.foreach.across.modules.bootstrapui.elements.SelectFormElement;
import com.foreach.across.modules.bootstrapui.elements.ToggleFormElement;
import com.foreach.across.modules.bootstrapui.elements.builder.FormControlElementBuilderSupport;
import com.foreach.across.modules.bootstrapui.elements.builder.OptionsFormElementBuilder;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilder;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.ViewElementPostProcessor;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class OptionFormElementBuilder<T extends FormControlElementSupport>
extends FormControlElementBuilderSupport<T, OptionFormElementBuilder<T>>
implements Comparable<OptionFormElementBuilder> {
    private OptionsFormElementBuilder.Type type = OptionsFormElementBuilder.Type.SELECT;
    private boolean selected;
    private boolean wrapped = true;
    private String text;
    private String label;
    private Object value;
    private Object rawValue;

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public String getText() {
        return this.text;
    }

    public String getLabel() {
        return this.label;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getRawValue() {
        return this.rawValue;
    }

    public OptionsFormElementBuilder.Type getType() {
        return this.type;
    }

    public OptionFormElementBuilder<T> checkbox() {
        return this.type(OptionsFormElementBuilder.Type.CHECKBOX);
    }

    public OptionFormElementBuilder<T> radio() {
        return this.type(OptionsFormElementBuilder.Type.RADIO);
    }

    public OptionFormElementBuilder<T> toggle() {
        return this.type(OptionsFormElementBuilder.Type.TOGGLE);
    }

    public OptionFormElementBuilder<T> type(OptionsFormElementBuilder.Type type) {
        this.type = type;
        return this;
    }

    public OptionFormElementBuilder<T> selected() {
        return this.selected(true);
    }

    public OptionFormElementBuilder<T> unwrapped() {
        return this.wrapped(false);
    }

    public OptionFormElementBuilder<T> wrapped(boolean wrapped) {
        this.wrapped = wrapped;
        return this;
    }

    public OptionFormElementBuilder<T> selected(boolean selected) {
        this.selected = selected;
        return this;
    }

    public OptionFormElementBuilder<T> text(String text) {
        this.text = text;
        return this;
    }

    public OptionFormElementBuilder<T> label(String label) {
        this.label = label;
        return this;
    }

    public OptionFormElementBuilder<T> rawValue(Object value) {
        this.rawValue = value;
        return this;
    }

    public OptionFormElementBuilder<T> value(Object value) {
        this.value = value;
        return this;
    }

    @Override
    public OptionFormElementBuilder<T> controlName(String controlName) {
        return (OptionFormElementBuilder)super.controlName(controlName);
    }

    @Override
    public OptionFormElementBuilder<T> disabled() {
        return (OptionFormElementBuilder)super.disabled();
    }

    @Override
    public OptionFormElementBuilder<T> disabled(boolean disabled) {
        return (OptionFormElementBuilder)super.disabled(disabled);
    }

    @Override
    public OptionFormElementBuilder<T> required() {
        return (OptionFormElementBuilder)super.required();
    }

    @Override
    public OptionFormElementBuilder<T> required(boolean required) {
        return (OptionFormElementBuilder)super.required(required);
    }

    @Override
    public OptionFormElementBuilder<T> readonly() {
        return (OptionFormElementBuilder)super.readonly();
    }

    @Override
    public OptionFormElementBuilder<T> readonly(boolean readonly) {
        return (OptionFormElementBuilder)super.readonly(readonly);
    }

    public OptionFormElementBuilder<T> htmlId(String htmlId) {
        return (OptionFormElementBuilder)super.htmlId(htmlId);
    }

    public OptionFormElementBuilder<T> attribute(String name, Object value) {
        return (OptionFormElementBuilder)super.attribute(name, value);
    }

    public OptionFormElementBuilder<T> attributes(Map<String, Object> attributes) {
        return (OptionFormElementBuilder)super.attributes(attributes);
    }

    public OptionFormElementBuilder<T> removeAttribute(String name) {
        return (OptionFormElementBuilder)super.removeAttribute(name);
    }

    public OptionFormElementBuilder<T> clearAttributes() {
        return (OptionFormElementBuilder)super.clearAttributes();
    }

    public OptionFormElementBuilder<T> add(ViewElement ... viewElements) {
        return (OptionFormElementBuilder)super.add(viewElements);
    }

    public OptionFormElementBuilder<T> add(ViewElementBuilder ... viewElements) {
        return (OptionFormElementBuilder)super.add(viewElements);
    }

    public OptionFormElementBuilder<T> addAll(Iterable<?> viewElements) {
        return (OptionFormElementBuilder)super.addAll(viewElements);
    }

    public OptionFormElementBuilder<T> sort(String ... elementNames) {
        return (OptionFormElementBuilder)super.sort(elementNames);
    }

    public OptionFormElementBuilder<T> name(String name) {
        return (OptionFormElementBuilder)super.name(name);
    }

    public OptionFormElementBuilder<T> customTemplate(String template) {
        return (OptionFormElementBuilder)super.customTemplate(template);
    }

    public OptionFormElementBuilder<T> postProcessor(ViewElementPostProcessor<T> postProcessor) {
        return (OptionFormElementBuilder)super.postProcessor(postProcessor);
    }

    public OptionFormElementBuilder<T> with(ViewElement.WitherSetter ... setters) {
        return (OptionFormElementBuilder)super.with(setters);
    }

    @Override
    public int compareTo(OptionFormElementBuilder o) {
        int comparison = ObjectUtils.compare((Comparable)((Object)this.getLabel()), (Comparable)((Object)o.getLabel()));
        if (comparison == 0) {
            comparison = ObjectUtils.compare((Comparable)((Object)this.getText()), (Comparable)((Object)o.getText()));
        }
        return comparison;
    }

    protected T createElement(ViewElementBuilderContext builderContext) {
        OptionsFormElementBuilder options = (OptionsFormElementBuilder)((Object)builderContext.getAttribute(OptionsFormElementBuilder.class));
        OptionsFormElementBuilder.Type typeToUse = options != null ? options.getType() : this.type;
        FormControlElementSupport control = this.apply(this.createControl(typeToUse, builderContext), builderContext);
        if (options != null) {
            if (this.getControlName() == null) {
                control.setControlName(options.getControlName());
            }
            if (this.getRequired() == null) {
                control.setRequired(options.isRequired());
            }
            if (this.getDisabled() == null) {
                control.setDisabled(options.isDisabled());
            }
            if (this.getRequired() == null) {
                control.setReadonly(options.isReadonly());
            }
        }
        return (T)control;
    }

    private FormControlElementSupport createControl(OptionsFormElementBuilder.Type type, ViewElementBuilderContext builderContext) {
        switch (type) {
            case CHECKBOX: {
                CheckboxFormElement checkbox = new CheckboxFormElement();
                checkbox.setText(builderContext.resolveText(this.label != null ? this.label : this.text));
                checkbox.setValue(this.value);
                checkbox.setChecked(this.selected);
                checkbox.setWrapped(this.wrapped);
                return checkbox;
            }
            case RADIO: {
                RadioFormElement radio = new RadioFormElement();
                radio.setText(builderContext.resolveText(this.label != null ? this.label : this.text));
                radio.setValue(this.value);
                radio.setChecked(this.selected);
                radio.setWrapped(this.wrapped);
                return radio;
            }
            case TOGGLE: {
                ToggleFormElement toggle = new ToggleFormElement();
                toggle.setText(builderContext.resolveText(this.label != null ? this.label : this.text));
                toggle.setValue(this.value);
                toggle.setChecked(this.selected);
                toggle.setWrapped(this.wrapped);
                return toggle;
            }
        }
        SelectFormElement.Option option = new SelectFormElement.Option();
        option.setLabel(builderContext.resolveText(this.label));
        option.setText(builderContext.resolveText(this.text));
        option.setValue(this.value);
        option.setSelected(this.selected);
        return option;
    }
}

