/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.builder;

import com.foreach.across.modules.bootstrapui.elements.SelectFormElement;
import com.foreach.across.modules.bootstrapui.elements.SelectFormElementConfiguration;
import com.foreach.across.modules.web.resource.WebResourceRegistry;
import com.foreach.across.modules.web.support.LocalizedTextResolver;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.AbstractNodeViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElement;
import com.foreach.across.modules.web.ui.elements.NodeViewElement;
import com.foreach.across.modules.web.ui.elements.builder.AbstractNodeViewElementBuilder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;

public class OptionsFormElementBuilder
extends AbstractNodeViewElementBuilder<AbstractNodeViewElement, OptionsFormElementBuilder> {
    private boolean disabled;
    private boolean readonly;
    private boolean required;
    private String controlName;
    private boolean multiple = false;
    private Type type = Type.SELECT;
    private SelectFormElementConfiguration selectConfiguration;

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getControlName() {
        return this.controlName;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public Type getType() {
        return this.type;
    }

    public OptionsFormElementBuilder multiple() {
        return this.multiple(true);
    }

    public OptionsFormElementBuilder single() {
        return this.multiple(false);
    }

    public OptionsFormElementBuilder multiple(boolean multiple) {
        this.multiple = multiple;
        return this;
    }

    public OptionsFormElementBuilder checkbox() {
        this.type = Type.CHECKBOX;
        return this;
    }

    public OptionsFormElementBuilder radio() {
        this.type = Type.RADIO;
        return this;
    }

    public OptionsFormElementBuilder toggle() {
        this.type = Type.TOGGLE;
        return this;
    }

    public OptionsFormElementBuilder select() {
        this.type = Type.SELECT;
        return this;
    }

    public OptionsFormElementBuilder select(SelectFormElementConfiguration configuration) {
        this.selectConfiguration = configuration;
        return this.select();
    }

    public OptionsFormElementBuilder controlName(String controlName) {
        this.controlName = controlName;
        return this;
    }

    public OptionsFormElementBuilder disabled() {
        return this.disabled(true);
    }

    public OptionsFormElementBuilder disabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public OptionsFormElementBuilder required() {
        return this.required(true);
    }

    public OptionsFormElementBuilder required(boolean required) {
        this.required = required;
        return this;
    }

    public OptionsFormElementBuilder readonly() {
        return this.readonly(true);
    }

    public OptionsFormElementBuilder readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractNodeViewElement createElement(ViewElementBuilderContext builderContext) {
        if (builderContext.hasAttribute(OptionsFormElementBuilder.class)) {
            throw new IllegalStateException("Nesting multiple OptionsFormElementBuilder instances is not supported.");
        }
        builderContext.setAttribute(OptionsFormElementBuilder.class, (Object)this);
        try {
            AbstractNodeViewElement control;
            if (this.type == Type.CHECKBOX || this.type == Type.RADIO || this.type == Type.TOGGLE) {
                control = this.createBoxDiv();
                control.set(new ViewElement.WitherSetter[]{HtmlViewElement.Functions.css((String[])new String[]{StringUtils.lowerCase((String)this.type.toString()) + "-list"})});
                control.setAttribute("data-bootstrapui-adapter-type", (Object)"container");
                if (this.controlName != null) {
                    control.setHtmlId("options-" + this.controlName);
                }
            } else {
                control = this.createSelect(builderContext);
            }
            AbstractNodeViewElement abstractNodeViewElement = this.apply(control, builderContext);
            return abstractNodeViewElement;
        }
        finally {
            builderContext.removeAttribute(OptionsFormElementBuilder.class);
        }
    }

    protected void registerWebResources(WebResourceRegistry webResourceRegistry) {
        webResourceRegistry.addPackage(new String[]{"bootstrapui-formelements"});
    }

    private AbstractNodeViewElement createSelect(ViewElementBuilderContext builderContext) {
        SelectFormElement select = new SelectFormElement();
        if (this.selectConfiguration != null) {
            select.setConfiguration(this.selectConfiguration.localize(LocaleContextHolder.getLocale(), (LocalizedTextResolver)builderContext));
        }
        select.setMultiple(this.multiple);
        if (this.controlName != null) {
            select.setControlName(this.controlName);
        }
        select.setDisabled(this.disabled);
        select.setReadonly(this.readonly);
        select.setRequired(this.required);
        return select;
    }

    private AbstractNodeViewElement createBoxDiv() {
        return new NodeViewElement("div");
    }

    public static enum Type {
        SELECT,
        CHECKBOX,
        RADIO,
        TOGGLE;

    }
}

