/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.builder;

import com.foreach.across.modules.bootstrapui.elements.Style;
import com.foreach.across.modules.bootstrapui.elements.TableViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.AbstractNodeViewElement;
import com.foreach.across.modules.web.ui.elements.builder.AbstractNodeViewElementBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TableViewElementBuilder
extends AbstractNodeViewElementBuilder<TableViewElement, TableViewElementBuilder> {
    private Boolean responsive;
    private Set<Style> styles = new HashSet<Style>();
    private Header header;
    private Body body;
    private Footer footer;
    private Caption caption;

    public TableViewElementBuilder style(Style ... styles) {
        Collections.addAll(this.styles, styles);
        return this;
    }

    public TableViewElementBuilder clearStyles() {
        this.styles.clear();
        return this;
    }

    public TableViewElementBuilder responsive() {
        return this.responsive(true);
    }

    public TableViewElementBuilder responsive(boolean responsive) {
        this.responsive = responsive;
        return this;
    }

    public Header header() {
        if (this.header == null) {
            this.header = TableViewElementBuilder.createHeader();
        }
        return this.header;
    }

    public TableViewElementBuilder header(Header header) {
        this.header = header;
        return this;
    }

    public Body body() {
        if (this.body == null) {
            this.body = TableViewElementBuilder.createBody();
        }
        return this.body;
    }

    public TableViewElementBuilder body(Body body) {
        this.body = body;
        return this;
    }

    public Footer footer() {
        if (this.footer == null) {
            this.footer = TableViewElementBuilder.createFooter();
        }
        return this.footer;
    }

    public TableViewElementBuilder footer(Footer footer) {
        this.footer = footer;
        return this;
    }

    public Caption caption() {
        if (this.caption == null) {
            this.caption = TableViewElementBuilder.createCaption();
        }
        return this.caption;
    }

    public TableViewElementBuilder caption(String captionText) {
        return this.caption(TableViewElementBuilder.createCaption().text(captionText));
    }

    public TableViewElementBuilder caption(Caption caption) {
        this.caption = caption;
        return this;
    }

    public Row row() {
        return new Row();
    }

    public Cell cell() {
        return new Cell();
    }

    public Cell heading() {
        return new Cell().heading(true);
    }

    protected TableViewElement createElement(ViewElementBuilderContext builderContext) {
        TableViewElement table = (TableViewElement)this.apply(new TableViewElement(), builderContext);
        table.setStyles(this.styles);
        if (this.responsive != null) {
            table.setResponsive(this.responsive);
        }
        if (this.caption != null) {
            table.setCaption((TableViewElement.Caption)this.caption.build(builderContext));
        }
        if (this.header != null) {
            table.setHeader((TableViewElement.Header)this.header.build(builderContext));
        }
        if (this.body != null) {
            table.setBody((TableViewElement.Body)this.body.build(builderContext));
        }
        if (this.footer != null) {
            table.setFooter((TableViewElement.Footer)this.footer.build(builderContext));
        }
        return table;
    }

    public static Header createHeader() {
        return new Header();
    }

    public static Body createBody() {
        return new Body();
    }

    public static Footer createFooter() {
        return new Footer();
    }

    public static Caption createCaption() {
        return new Caption();
    }

    public static class Cell
    extends AbstractNodeViewElementBuilder<TableViewElement.Cell, Cell> {
        private boolean heading;
        private Integer columnSpan;
        private String text;

        public Cell heading(boolean heading) {
            this.heading = heading;
            return this;
        }

        public Cell text(String text) {
            this.text = text;
            return this;
        }

        public Cell columnSpan(Integer columnSpan) {
            this.columnSpan = columnSpan;
            return this;
        }

        protected TableViewElement.Cell createElement(ViewElementBuilderContext builderContext) {
            TableViewElement.Cell cell = (TableViewElement.Cell)this.apply((AbstractNodeViewElement)new TableViewElement.Cell(), builderContext);
            cell.setHeading(this.heading);
            if (this.columnSpan != null) {
                cell.setColumnSpan(this.columnSpan);
            }
            if (this.text != null) {
                cell.setText(this.text);
            }
            return cell;
        }
    }

    public static class Row
    extends AbstractNodeViewElementBuilder<TableViewElement.Row, Row> {
        protected TableViewElement.Row createElement(ViewElementBuilderContext builderContext) {
            return (TableViewElement.Row)this.apply(new TableViewElement.Row(), builderContext);
        }
    }

    public static class Footer
    extends AbstractNodeViewElementBuilder<TableViewElement.Footer, Footer> {
        protected TableViewElement.Footer createElement(ViewElementBuilderContext builderContext) {
            return (TableViewElement.Footer)this.apply(new TableViewElement.Footer(), builderContext);
        }
    }

    public static class Header
    extends AbstractNodeViewElementBuilder<TableViewElement.Header, Header> {
        protected TableViewElement.Header createElement(ViewElementBuilderContext builderContext) {
            return (TableViewElement.Header)this.apply(new TableViewElement.Header(), builderContext);
        }
    }

    public static class Body
    extends AbstractNodeViewElementBuilder<TableViewElement.Body, Body> {
        protected TableViewElement.Body createElement(ViewElementBuilderContext builderContext) {
            return (TableViewElement.Body)this.apply(new TableViewElement.Body(), builderContext);
        }
    }

    public static class Caption
    extends AbstractNodeViewElementBuilder<TableViewElement.Caption, Caption> {
        private String text;

        public Caption text(String text) {
            this.text = text;
            return this;
        }

        protected TableViewElement.Caption createElement(ViewElementBuilderContext builderContext) {
            TableViewElement.Caption caption = (TableViewElement.Caption)this.apply((AbstractNodeViewElement)new TableViewElement.Caption(), builderContext);
            if (this.text != null) {
                caption.setText(this.text);
            }
            return caption;
        }
    }
}

