/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.builder;

import com.foreach.across.modules.bootstrapui.elements.TextareaFormElement;
import com.foreach.across.modules.bootstrapui.elements.TextboxFormElement;
import com.foreach.across.modules.bootstrapui.elements.builder.FormControlElementBuilderSupport;
import com.foreach.across.modules.web.resource.WebResourceRegistry;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilder;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.ViewElementPostProcessor;
import java.util.Map;

public class TextboxFormElementBuilder
extends FormControlElementBuilderSupport<TextboxFormElement, TextboxFormElementBuilder> {
    private Boolean autoSize;
    private Boolean disableLineBreaks;
    private boolean multiLine = false;
    private TextboxFormElement.Type type;
    private String placeholder;
    private String text;
    private Integer rows;
    private Integer maxLength;

    public TextboxFormElementBuilder multiLine() {
        return this.multiLine(true);
    }

    public TextboxFormElementBuilder multiLine(boolean multiLine) {
        this.multiLine = multiLine;
        return this;
    }

    public TextboxFormElementBuilder multiLine(int rows) {
        return this.rows(rows);
    }

    public TextboxFormElementBuilder autoSize() {
        return this.autoSize(true);
    }

    public TextboxFormElementBuilder autoSize(boolean autoSize) {
        this.autoSize = autoSize;
        return this;
    }

    public TextboxFormElementBuilder disableLineBreaks() {
        return this.disableLineBreaks(true);
    }

    public TextboxFormElementBuilder disableLineBreaks(boolean disableLineBreaks) {
        this.disableLineBreaks = disableLineBreaks;
        return this;
    }

    public TextboxFormElementBuilder maxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public TextboxFormElementBuilder password() {
        return this.type(TextboxFormElement.Type.PASSWORD);
    }

    public TextboxFormElementBuilder type(TextboxFormElement.Type type) {
        this.type = type;
        return this;
    }

    public TextboxFormElementBuilder placeholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    public TextboxFormElementBuilder text(String text) {
        this.text = text;
        return this;
    }

    public TextboxFormElementBuilder rows(int rows) {
        this.multiLine = true;
        this.rows = rows;
        return this;
    }

    @Override
    public TextboxFormElementBuilder controlName(String controlName) {
        return (TextboxFormElementBuilder)((Object)super.controlName(controlName));
    }

    @Override
    public TextboxFormElementBuilder disabled() {
        return (TextboxFormElementBuilder)((Object)super.disabled());
    }

    @Override
    public TextboxFormElementBuilder disabled(boolean disabled) {
        return (TextboxFormElementBuilder)((Object)super.disabled(disabled));
    }

    @Override
    public TextboxFormElementBuilder readonly() {
        return (TextboxFormElementBuilder)((Object)super.readonly());
    }

    @Override
    public TextboxFormElementBuilder readonly(boolean readonly) {
        return (TextboxFormElementBuilder)((Object)super.readonly(readonly));
    }

    @Override
    public TextboxFormElementBuilder required() {
        return (TextboxFormElementBuilder)((Object)super.required());
    }

    @Override
    public TextboxFormElementBuilder required(boolean required) {
        return (TextboxFormElementBuilder)((Object)super.required(required));
    }

    public TextboxFormElementBuilder htmlId(String htmlId) {
        return (TextboxFormElementBuilder)super.htmlId(htmlId);
    }

    public TextboxFormElementBuilder attribute(String name, Object value) {
        return (TextboxFormElementBuilder)super.attribute(name, value);
    }

    public TextboxFormElementBuilder attributes(Map<String, Object> attributes) {
        return (TextboxFormElementBuilder)super.attributes(attributes);
    }

    public TextboxFormElementBuilder removeAttribute(String name) {
        return (TextboxFormElementBuilder)super.removeAttribute(name);
    }

    public TextboxFormElementBuilder clearAttributes() {
        return (TextboxFormElementBuilder)super.clearAttributes();
    }

    public TextboxFormElementBuilder add(ViewElement ... viewElements) {
        return (TextboxFormElementBuilder)super.add(viewElements);
    }

    public TextboxFormElementBuilder add(ViewElementBuilder ... viewElements) {
        return (TextboxFormElementBuilder)super.add(viewElements);
    }

    public TextboxFormElementBuilder addAll(Iterable<?> viewElements) {
        return (TextboxFormElementBuilder)super.addAll(viewElements);
    }

    public TextboxFormElementBuilder sort(String ... elementNames) {
        return (TextboxFormElementBuilder)super.sort(elementNames);
    }

    public TextboxFormElementBuilder name(String name) {
        return (TextboxFormElementBuilder)super.name(name);
    }

    public TextboxFormElementBuilder customTemplate(String template) {
        return (TextboxFormElementBuilder)super.customTemplate(template);
    }

    public TextboxFormElementBuilder postProcessor(ViewElementPostProcessor<TextboxFormElement> postProcessor) {
        return (TextboxFormElementBuilder)super.postProcessor(postProcessor);
    }

    protected TextboxFormElement createElement(ViewElementBuilderContext builderContext) {
        TextboxFormElement textbox;
        if (this.multiLine) {
            TextareaFormElement textarea = new TextareaFormElement();
            if (this.rows != null) {
                textarea.setRows(this.rows);
            }
            if (this.autoSize != null) {
                textarea.setAutoSize(this.autoSize);
            }
            textbox = textarea;
        } else if ((TextboxFormElement.Type.TEXT.equals(this.type) || this.type == null) && Boolean.TRUE.equals(this.autoSize)) {
            TextareaFormElement textarea = new TextareaFormElement();
            textarea.setRows(1);
            textarea.setAutoSize(true);
            textarea.setDisableLineBreaks(this.disableLineBreaks == null);
            textbox = textarea;
        } else {
            textbox = new TextboxFormElement();
        }
        if (this.disableLineBreaks != null) {
            textbox.setDisableLineBreaks(this.disableLineBreaks);
        }
        if (this.text != null) {
            textbox.setText(this.text);
        }
        if (this.type != null) {
            textbox.setType(this.type);
        }
        if (this.placeholder != null) {
            textbox.setPlaceholder(builderContext.resolveText(this.placeholder));
        }
        if (this.maxLength != null) {
            textbox.setMaxLength(this.maxLength);
        }
        return this.apply(textbox, builderContext);
    }

    protected void registerWebResources(WebResourceRegistry webResourceRegistry) {
        webResourceRegistry.addPackage(new String[]{"bootstrapui-formelements"});
    }
}

