/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.icons;

import com.foreach.across.modules.bootstrapui.elements.icons.MutableIconSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class IconSetRegistry {
    private static final Map<String, MutableIconSet> iconSets = new HashMap<String, MutableIconSet>();

    public static MutableIconSet getIconSet(@NonNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        MutableIconSet foundMutableIconSet = iconSets.get(name);
        if (foundMutableIconSet == null) {
            throw new IllegalArgumentException(String.format("IconSet with name %s does not exist", name));
        }
        return foundMutableIconSet;
    }

    public static Map<String, MutableIconSet> getAllIconSets() {
        return Collections.unmodifiableMap(iconSets);
    }

    public static void addIconSet(@NonNull String name, @NonNull MutableIconSet MutableIconSet2) {
        if (name == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        if (MutableIconSet2 == null) {
            throw new IllegalArgumentException("MutableIconSet is marked non-null but is null");
        }
        iconSets.put(name, MutableIconSet2);
    }

    public static void removeIconSet(@NonNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        iconSets.remove(name);
    }

    public static void removeAllIconSets() {
        iconSets.clear();
    }
}

