/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.icons;

import com.foreach.across.modules.bootstrapui.elements.icons.MutableIconSet;
import com.foreach.across.modules.web.ui.elements.HtmlViewElement;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.NonNull;

public class SimpleIconSet
implements MutableIconSet {
    private Function<String, HtmlViewElement> defaultIconResolver;
    private final Map<String, Function<String, HtmlViewElement>> registeredIconResolvers = new HashMap<String, Function<String, HtmlViewElement>>();

    @Override
    public HtmlViewElement icon(String name) {
        Function<String, HtmlViewElement> registeredIconResolver = this.registeredIconResolvers.get(name);
        if (registeredIconResolver != null) {
            return registeredIconResolver.apply(name);
        }
        if (this.defaultIconResolver == null) {
            throw new IllegalArgumentException(String.format("No icon with the name %s could be found", name));
        }
        return this.defaultIconResolver.apply(name);
    }

    @Override
    public Map<String, HtmlViewElement> getAllRegisteredIcons() {
        HashMap<String, HtmlViewElement> allIconsInTheIconSet = new HashMap<String, HtmlViewElement>();
        this.registeredIconResolvers.forEach((iconName, functionToGenerateIcon) -> {
            HtmlViewElement cfr_ignored_0 = (HtmlViewElement)allIconsInTheIconSet.put((String)iconName, (HtmlViewElement)functionToGenerateIcon.apply(iconName));
        });
        return allIconsInTheIconSet;
    }

    @Override
    public void add(@NonNull String name, Function<String, HtmlViewElement> iconResolver) {
        if (name == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        this.registeredIconResolvers.put(name, iconResolver);
    }

    @Override
    public void remove(@NonNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        this.registeredIconResolvers.remove(name);
    }

    @Override
    public void removeAll() {
        this.registeredIconResolvers.clear();
    }

    public void setDefaultIconResolver(Function<String, HtmlViewElement> defaultIconResolver) {
        this.defaultIconResolver = defaultIconResolver;
    }
}

