/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.thymeleaf;

import com.foreach.across.modules.bootstrapui.elements.ButtonViewElement;
import com.foreach.across.modules.web.thymeleaf.ThymeleafModelBuilder;
import com.foreach.across.modules.web.ui.elements.HtmlViewElement;
import com.foreach.across.modules.web.ui.elements.thymeleaf.AbstractHtmlViewElementModelWriter;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;

public class ButtonViewElementModelWriter
extends AbstractHtmlViewElementModelWriter<ButtonViewElement> {
    protected void writeOpenElement(ButtonViewElement button, ThymeleafModelBuilder writer) {
        super.writeOpenElement((HtmlViewElement)button, writer);
        this.changeButtonTypeElement(button, writer);
        this.addButtonTypeAttributes(button, writer);
        writer.addAttribute("title", new Object[]{button.getTitle()});
        this.addButtonStateAttributes(button, writer);
        this.addButtonUrl(button, writer);
        String text = button.getText();
        if (button.getType() != ButtonViewElement.Type.LINK) {
            writer.addAttribute("name", new Object[]{button.getControlName()});
        }
        this.addButtonValue(button, writer);
        if (button.getIcon() != null) {
            writer.addViewElement(button.getIcon());
        }
        if (!EnumSet.of(ButtonViewElement.Type.INPUT, ButtonViewElement.Type.INPUT_RESET, ButtonViewElement.Type.INPUT_SUBMIT).contains((Object)button.getType())) {
            writer.addHtml(text);
        }
    }

    private void addButtonValue(ButtonViewElement button, ThymeleafModelBuilder writer) {
        switch (button.getType()) {
            case INPUT: 
            case INPUT_RESET: 
            case INPUT_SUBMIT: {
                writer.addAttribute("value", new Object[]{StringUtils.defaultString((String)button.getValue(), (String)button.getText())});
                break;
            }
            case LINK: {
                writer.addAttribute("data-value", new Object[]{button.getValue()});
                break;
            }
            default: {
                writer.addAttribute("value", new Object[]{button.getValue()});
            }
        }
    }

    private void addButtonUrl(ButtonViewElement button, ThymeleafModelBuilder writer) {
        if (button.getType() == ButtonViewElement.Type.LINK) {
            writer.addAttribute("href", new Object[]{button.getUrl()});
        } else if (!StringUtils.equals((CharSequence)"#", (CharSequence)button.getUrl())) {
            writer.addAttribute("data-url", new Object[]{button.getUrl()});
        }
    }

    private void addButtonStateAttributes(ButtonViewElement button, ThymeleafModelBuilder writer) {
        if (button.getState() == ButtonViewElement.State.ACTIVE) {
            writer.addAttributeValue("class", new Object[]{"active"});
        } else if (button.getState() == ButtonViewElement.State.DISABLED) {
            if (button.getType() == ButtonViewElement.Type.LINK) {
                writer.addAttributeValue("class", new Object[]{"disabled"});
                writer.addAttribute("aria-disabled", new Object[]{true});
                writer.addAttribute("tabindex", new Object[]{"-1"});
            } else {
                writer.addBooleanAttribute("disabled", true);
            }
        }
    }

    private void changeButtonTypeElement(ButtonViewElement button, ThymeleafModelBuilder writer) {
        switch (button.getType()) {
            case INPUT: 
            case INPUT_RESET: 
            case INPUT_SUBMIT: {
                writer.changeOpenElement("input");
                break;
            }
            case LINK: {
                writer.changeOpenElement("a");
            }
        }
    }

    private void addButtonTypeAttributes(ButtonViewElement button, ThymeleafModelBuilder writer) {
        switch (button.getType()) {
            case INPUT_RESET: 
            case BUTTON_RESET: {
                writer.addAttribute("type", new Object[]{"reset"});
                break;
            }
            case INPUT_SUBMIT: 
            case BUTTON_SUBMIT: {
                writer.addAttribute("type", new Object[]{"submit"});
                break;
            }
            case INPUT: 
            case BUTTON: {
                writer.addAttribute("type", new Object[]{"button"});
                break;
            }
            case LINK: {
                writer.addAttribute("role", new Object[]{"button"});
            }
        }
    }
}

