/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.thymeleaf;

import com.foreach.across.modules.bootstrapui.elements.CheckboxFormElement;
import com.foreach.across.modules.bootstrapui.elements.thymeleaf.FormControlElementModelWriter;
import com.foreach.across.modules.web.thymeleaf.ThymeleafModelBuilder;
import com.foreach.across.modules.web.ui.ViewElement;
import org.apache.commons.lang3.StringUtils;

public class CheckboxFormElementModelWriter
extends FormControlElementModelWriter<CheckboxFormElement> {
    @Override
    protected void writeOpenElement(CheckboxFormElement control, ThymeleafModelBuilder model) {
        this.writeOpenElement("checkbox", control, model);
    }

    protected void writeOpenElement(String type, CheckboxFormElement control, ThymeleafModelBuilder model) {
        String text = control.getText();
        boolean showLabel = StringUtils.isNotEmpty((CharSequence)text) || control.hasChildren();
        boolean asCustomControl = this.useCustomControlCss(control, showLabel);
        if (control.isWrapped()) {
            model.addOpenElement("div");
            control.getAttributes().forEach((x$0, xva$1) -> model.addAttribute(x$0, new Object[]{xva$1}));
            if (asCustomControl) {
                model.addAttributeValue("class", new Object[]{"custom-control", this.customControlCss()});
            } else {
                model.addAttributeValue("class", new Object[]{"form-check"});
            }
        }
        this.writeCheckbox(type, control, model, showLabel, asCustomControl);
        if (showLabel || asCustomControl) {
            this.writeLabel(control, model, asCustomControl);
        }
    }

    protected boolean useCustomControlCss(CheckboxFormElement control, boolean hasLabel) {
        return control.isRenderAsCustomControl() && control.isWrapped();
    }

    protected String customControlCss() {
        return "custom-checkbox";
    }

    private void writeLabel(CheckboxFormElement control, ThymeleafModelBuilder model, boolean asCustomControl) {
        model.addOpenElement("label");
        if (control.isWrapped()) {
            model.addAttribute("class", new Object[]{asCustomControl ? "custom-control-label" : "form-check-label"});
        }
        model.addAttribute("for", new Object[]{model.retrieveHtmlId((ViewElement)control)});
        model.addHtml(control.getText());
        model.addCloseElement();
    }

    private void writeCheckbox(String type, CheckboxFormElement control, ThymeleafModelBuilder model, boolean showLabel, boolean asCustomControl) {
        model.addOpenElement(control.getTagName());
        model.addAttribute("id", new Object[]{model.retrieveHtmlId((ViewElement)control)});
        model.addAttribute("name", new Object[]{control.getControlName()});
        model.addBooleanAttribute("disabled", control.isDisabled());
        model.addBooleanAttribute("readonly", control.isReadonly());
        model.addBooleanAttribute("required", control.isRequired());
        if (!control.isWrapped() && !showLabel) {
            control.getAttributes().forEach((x$0, xva$1) -> model.addAttribute(x$0, new Object[]{xva$1}));
        }
        model.addAttribute("type", new Object[]{type});
        model.addAttribute("value", new Object[]{control.getValue()});
        model.addBooleanAttribute("checked", control.isChecked());
        if (control.isWrapped()) {
            model.addAttributeValue("class", new Object[]{asCustomControl ? "custom-control-input" : "form-check-input"});
            if (!showLabel) {
                model.addAttributeValue("class", new Object[]{"position-static"});
            }
        } else {
            control.getAttributes().forEach((x$0, xva$1) -> model.addAttribute(x$0, new Object[]{xva$1}));
        }
        model.addCloseElement();
    }

    protected void writeCloseElement(CheckboxFormElement control, ThymeleafModelBuilder model) {
        if (control.getControlName() != null) {
            this.writeHiddenValueHolder(control, model);
        }
        if (control.isWrapped()) {
            model.addCloseElement();
        }
    }

    private void writeHiddenValueHolder(CheckboxFormElement control, ThymeleafModelBuilder model) {
        model.addOpenElement("input");
        model.addAttribute("type", new Object[]{"hidden"});
        model.addAttribute("name", new Object[]{"_" + control.getControlName()});
        model.addAttribute("value", new Object[]{"on"});
        if (control.isDisabled() || control.hasAttribute("disabled")) {
            model.addBooleanAttribute("disabled", true);
        }
        model.addCloseElement();
    }
}

