/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.thymeleaf;

import com.foreach.across.modules.bootstrapui.elements.CheckboxFormElement;
import com.foreach.across.modules.bootstrapui.elements.FormControlElement;
import com.foreach.across.modules.bootstrapui.elements.FormGroupElement;
import com.foreach.across.modules.bootstrapui.elements.FormLayout;
import com.foreach.across.modules.bootstrapui.elements.FormViewElement;
import com.foreach.across.modules.bootstrapui.elements.Grid;
import com.foreach.across.modules.bootstrapui.elements.LabelFormElement;
import com.foreach.across.modules.bootstrapui.elements.TextboxFormElement;
import com.foreach.across.modules.bootstrapui.elements.thymeleaf.TextboxFormElementModelWriter;
import com.foreach.across.modules.bootstrapui.utils.BootstrapElementUtils;
import com.foreach.across.modules.web.thymeleaf.ThymeleafModelBuilder;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElement;
import com.foreach.across.modules.web.ui.elements.thymeleaf.AbstractHtmlViewElementModelWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.model.ICloseElementTag;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.spring5.context.IThymeleafBindStatus;
import org.thymeleaf.spring5.util.FieldUtils;

public class FormGroupElementModelWriter
extends AbstractHtmlViewElementModelWriter<FormGroupElement> {
    private static final Logger LOG = LoggerFactory.getLogger(FormGroupElementModelWriter.class);
    private final Collection<String> CONTROL_ELEMENTS = Arrays.asList("input", "textarea", "select");

    public void writeModel(FormGroupElement group, ThymeleafModelBuilder model) {
        IModel tooltipModel;
        ViewElement helpBlock;
        IModel controlModel;
        boolean isWrappedBoxGroup;
        super.writeOpenElement((HtmlViewElement)group, model);
        model.addAttributeValue("class", new Object[]{"form-group"});
        if (group.isRequired()) {
            model.addAttributeValue("class", new Object[]{"required"});
        }
        boolean boxGroup = false;
        if (this.isCheckboxGroup(group)) {
            boxGroup = true;
        }
        FormLayout layout = this.determineFormLayout(group, model);
        Consumer<ThymeleafModelBuilder> errorBuilder = null;
        ViewElement control = group.getControl();
        FormControlElement formControl = BootstrapElementUtils.getFormControl((ViewElement)group);
        boolean bl = isWrappedBoxGroup = boxGroup && ((CheckboxFormElement)control).isWrapped();
        if (formControl != null) {
            errorBuilder = this.createFieldErrorsBuilder(group.isDetectFieldErrors() ? formControl : null, group.getFieldErrorsToShow(), model.getTemplateContext());
        }
        IModel iModel = controlModel = control != null ? model.createViewElementModel(group.getControl()) : null;
        if (controlModel != null && errorBuilder != null) {
            this.setIsInvalidOnControl(model.getModelFactory(), controlModel);
            if (isWrappedBoxGroup) {
                this.attachFeedbackToControl(model, controlModel, errorBuilder);
            }
        }
        IModel helpBlockModel = (helpBlock = group.getHelpBlock()) != null ? model.createViewElementModel(helpBlock) : null;
        ViewElement descriptionBlock = group.getDescriptionBlock();
        IModel descriptionBlockModel = descriptionBlock != null ? model.createViewElementModel(descriptionBlock) : null;
        ViewElement label = group.getLabel();
        IModel labelModel = label != null ? model.createViewElementModel(label) : null;
        ViewElement tooltip = group.getTooltip();
        IModel iModel2 = tooltipModel = tooltip != null ? model.createViewElementModel(tooltip) : null;
        if (labelModel != null && group.isRequired()) {
            this.addRequiredIndicatorToLabel(model.getModelFactory(), labelModel);
        }
        if (tooltipModel != null) {
            if (labelModel != null) {
                this.addTooltipToLabel(tooltipModel, labelModel);
            } else if (boxGroup && controlModel != null) {
                this.addTooltipToLabel(tooltipModel, controlModel);
            }
        }
        if (formControl != null && controlModel != null) {
            String helpId;
            String controlId = model.retrieveHtmlId((ViewElement)formControl);
            if (controlId != null && !formControl.hasAttribute("aria-describedby") && !(helpId = this.retrieveDescribedByIds(model.getModelFactory(), controlId, descriptionBlockModel, helpBlockModel, tooltipModel)).isEmpty()) {
                this.setDescribedByAttributeOnControl(model.getModelFactory(), controlModel, helpId);
            }
            if (layout.getType() == FormLayout.Type.INLINE && !layout.isShowLabels()) {
                String labelText;
                String string = labelText = label instanceof LabelFormElement ? ((LabelFormElement)label).getText() : null;
                if (labelText != null) {
                    this.setPlaceholderAttributeOnControl(model.getModelFactory(), controlModel, labelText);
                }
            }
        }
        if (layout.getType() == FormLayout.Type.INLINE) {
            if (descriptionBlockModel != null) {
                this.makeBlockScreenReaderOnly(model.getModelFactory(), descriptionBlockModel);
            }
            if (helpBlockModel != null) {
                this.makeBlockScreenReaderOnly(model.getModelFactory(), helpBlockModel);
            }
        }
        if (errorBuilder != null) {
            model.addAttributeValue("class", new Object[]{"is-invalid"});
        }
        if (labelModel != null) {
            this.addFormLayoutToLabel(model.getModelFactory(), labelModel, layout);
            model.addModel(labelModel);
        }
        if (layout.getType() == FormLayout.Type.HORIZONTAL) {
            model.addOpenElement("div");
            model.addAttributeValue("class", new Object[]{((Grid.Position)layout.getGrid().get(1)).toString()});
            if (labelModel == null) {
                model.addAttributeValue("class", new Object[]{((Grid.Position)layout.getGrid().get(0)).asOffset().toString()});
            }
        }
        if (descriptionBlockModel != null) {
            model.addModel(descriptionBlockModel);
        }
        if (controlModel != null) {
            model.addModel(controlModel);
        }
        if (helpBlockModel != null) {
            model.addModel(helpBlockModel);
        }
        this.writeChildren((HtmlViewElement)group, model);
        if (errorBuilder != null && !boxGroup) {
            errorBuilder.accept(model);
        }
        if (layout.getType() == FormLayout.Type.HORIZONTAL) {
            model.addCloseElement();
        }
        this.writeCloseElement((HtmlViewElement)group, model);
    }

    private void attachFeedbackToControl(ThymeleafModelBuilder model, IModel controlModel, Consumer<ThymeleafModelBuilder> errorBuilder) {
        ThymeleafModelBuilder childModelBuilder = model.createChildModelBuilder();
        errorBuilder.accept(childModelBuilder);
        controlModel.insertModel(controlModel.size() - 1, childModelBuilder.retrieveModel());
    }

    private FormLayout determineFormLayout(FormGroupElement group, ThymeleafModelBuilder model) {
        FormLayout layout = group.getFormLayout();
        if (layout == null) {
            FormViewElement form = (FormViewElement)((Object)model.getTemplateContext().getVariable("_currentBootstrapForm"));
            if (form != null) {
                layout = form.getFormLayout();
            }
            if (layout == null) {
                layout = FormLayout.normal();
            }
        }
        if (layout.getType() == FormLayout.Type.HORIZONTAL && layout.getGrid().size() != 2) {
            throw new IllegalStateException("Horizontal form requires a grid layout of 2 positions.");
        }
        return layout;
    }

    private void makeBlockScreenReaderOnly(IModelFactory modelFactory, IModel helpBlockModel) {
        for (int i = 0; i < helpBlockModel.size(); ++i) {
            ITemplateEvent event = helpBlockModel.get(i);
            if (!(event instanceof IOpenElementTag)) continue;
            IOpenElementTag elementTag = (IOpenElementTag)event;
            String currentClass = StringUtils.defaultString((String)elementTag.getAttributeValue("class"));
            String newClass = StringUtils.strip((String)(currentClass + " sr-only"));
            helpBlockModel.replace(i, (ITemplateEvent)modelFactory.setAttribute((IProcessableElementTag)elementTag, "class", newClass));
            return;
        }
    }

    private void addFormLayoutToLabel(IModelFactory modelFactory, IModel labelModel, FormLayout layout) {
        for (int i = 0; i < labelModel.size(); ++i) {
            ITemplateEvent event = labelModel.get(i);
            if (!(event instanceof IOpenElementTag)) continue;
            IOpenElementTag elementTag = (IOpenElementTag)event;
            if (layout.getType() == FormLayout.Type.HORIZONTAL) {
                String currentClass = StringUtils.defaultString((String)elementTag.getAttributeValue("class"));
                String newClass = StringUtils.strip((String)(currentClass + " " + ((Grid.Position)layout.getGrid().get(0)).toString()));
                labelModel.replace(i, (ITemplateEvent)modelFactory.setAttribute((IProcessableElementTag)elementTag, "class", newClass));
            } else if (layout.getType() == FormLayout.Type.INLINE && !layout.isShowLabels()) {
                String currentClass = StringUtils.defaultString((String)elementTag.getAttributeValue("class"));
                String newClass = StringUtils.strip((String)(currentClass + " sr-only"));
                labelModel.replace(i, (ITemplateEvent)modelFactory.setAttribute((IProcessableElementTag)elementTag, "class", newClass));
            }
            return;
        }
    }

    private void addRequiredIndicatorToLabel(IModelFactory modelFactory, IModel labelModel) {
        for (int i = 0; i < labelModel.size(); ++i) {
            ICloseElementTag closeElementTag;
            ITemplateEvent event = labelModel.get(i);
            if (!(event instanceof ICloseElementTag) || !"label".equalsIgnoreCase((closeElementTag = (ICloseElementTag)event).getElementCompleteName())) continue;
            labelModel.insert(i, (ITemplateEvent)modelFactory.createOpenElementTag("sup", "class", "required"));
            labelModel.insert(i + 1, (ITemplateEvent)modelFactory.createText((CharSequence)"*"));
            labelModel.insert(i + 2, (ITemplateEvent)modelFactory.createCloseElementTag("sup"));
            return;
        }
    }

    private void addTooltipToLabel(IModel tooltipModel, IModel labelModel) {
        for (int i = 0; i < labelModel.size(); ++i) {
            ICloseElementTag closeElementTag;
            ITemplateEvent event = labelModel.get(i);
            if (!(event instanceof ICloseElementTag) || !"label".equalsIgnoreCase((closeElementTag = (ICloseElementTag)event).getElementCompleteName())) continue;
            labelModel.insertModel(i, tooltipModel);
            return;
        }
    }

    private void setDescribedByAttributeOnControl(IModelFactory modelFactory, IModel controlModel, String helpId) {
        for (int i = 0; i < controlModel.size(); ++i) {
            IOpenElementTag elementTag;
            ITemplateEvent event = controlModel.get(i);
            if (!(event instanceof IOpenElementTag) || !this.CONTROL_ELEMENTS.contains(StringUtils.lowerCase((String)(elementTag = (IOpenElementTag)event).getElementCompleteName()))) continue;
            controlModel.replace(i, (ITemplateEvent)modelFactory.setAttribute((IProcessableElementTag)elementTag, "aria-describedby", helpId));
            return;
        }
    }

    private void setPlaceholderAttributeOnControl(IModelFactory modelFactory, IModel controlModel, String placeholder) {
        for (int i = 0; i < controlModel.size(); ++i) {
            IOpenElementTag elementTag;
            ITemplateEvent event = controlModel.get(i);
            if (!(event instanceof IOpenElementTag) || !this.CONTROL_ELEMENTS.contains(StringUtils.lowerCase((String)(elementTag = (IOpenElementTag)event).getElementCompleteName()))) continue;
            if (!"select".equals(StringUtils.lowerCase((String)elementTag.getElementCompleteName())) && !elementTag.hasAttribute("placeholder")) {
                controlModel.replace(i, (ITemplateEvent)modelFactory.setAttribute((IProcessableElementTag)elementTag, "placeholder", placeholder));
            }
            return;
        }
    }

    private void setIsInvalidOnControl(IModelFactory modelFactory, IModel controlModel) {
        for (int i = 0; i < controlModel.size(); ++i) {
            IOpenElementTag elementTag;
            ITemplateEvent event = controlModel.get(i);
            if (!(event instanceof IOpenElementTag) || !this.CONTROL_ELEMENTS.contains(StringUtils.lowerCase((String)(elementTag = (IOpenElementTag)event).getElementCompleteName()))) continue;
            String currentClass = StringUtils.defaultString((String)elementTag.getAttributeValue("class"));
            String newClass = StringUtils.strip((String)(currentClass + " is-invalid"));
            controlModel.replace(i, (ITemplateEvent)modelFactory.setAttribute((IProcessableElementTag)elementTag, "class", newClass));
        }
    }

    private String retrieveDescribedByIds(IModelFactory modelFactory, String controlId, IModel descriptionModel, IModel helpModel, IModel tooltipModel) {
        StringBuilder concatenated = new StringBuilder();
        if (descriptionModel != null) {
            concatenated.append(this.setOrRetrieveBlockId(modelFactory, descriptionModel, controlId, "description"));
        }
        if (helpModel != null) {
            concatenated.append(this.setOrRetrieveBlockId(modelFactory, helpModel, controlId, "help"));
        }
        if (tooltipModel != null) {
            concatenated.append(this.setOrRetrieveBlockId(modelFactory, tooltipModel, controlId, "tooltip"));
        }
        return concatenated.toString().trim();
    }

    private String setOrRetrieveBlockId(IModelFactory modelFactory, IModel helpBlockModel, String controlId, String blockType) {
        for (int i = 0; i < helpBlockModel.size(); ++i) {
            ITemplateEvent event = helpBlockModel.get(i);
            if (!(event instanceof IOpenElementTag)) continue;
            IOpenElementTag elementTag = (IOpenElementTag)event;
            if (elementTag.hasAttribute("id")) {
                return elementTag.getAttributeValue("id") + " ";
            }
            String helpId = controlId + "." + blockType;
            helpBlockModel.replace(i, (ITemplateEvent)modelFactory.setAttribute((IProcessableElementTag)elementTag, "id", helpId));
            return helpId + " ";
        }
        return "";
    }

    private Consumer<ThymeleafModelBuilder> createFieldErrorsBuilder(FormControlElement formControl, String[] fieldErrors, ITemplateContext templateContext) {
        if ((formControl != null || fieldErrors.length > 0) && templateContext.containsVariable("springBoundObjectExpression")) {
            LinkedHashSet<String> errorMessages = new LinkedHashSet<String>(fieldErrors.length + 1);
            if (formControl != null) {
                String controlName = formControl.getControlName();
                String propertyName2 = StringUtils.startsWith((CharSequence)controlName, (CharSequence)"_") ? StringUtils.substring((String)controlName, (int)1) : controlName;
                IThymeleafBindStatus bindStatus = FieldUtils.getBindStatus((IExpressionContext)templateContext, (boolean)true, (String)("*{" + propertyName2 + "}"));
                if (bindStatus != null && bindStatus.isError()) {
                    Object inputValue;
                    errorMessages.addAll(Arrays.asList(bindStatus.getErrorMessages()));
                    if (formControl instanceof TextboxFormElement && (inputValue = bindStatus.getValue()) != null) {
                        formControl.setAttribute(TextboxFormElementModelWriter.TRANSIENT_ERROR_VALUE_ATTRIBUTE, inputValue.toString());
                    }
                }
            }
            Stream.of(fieldErrors).map(propertyName -> FieldUtils.getBindStatus((IExpressionContext)templateContext, (boolean)true, (String)("*{" + propertyName + "}"))).filter(Objects::nonNull).filter(IThymeleafBindStatus::isError).flatMap(bs -> Stream.of(bs.getErrorMessages())).forEach(errorMessages::add);
            if (!errorMessages.isEmpty()) {
                return model -> {
                    model.addOpenElement("div");
                    model.addAttributeValue("class", new Object[]{"invalid-feedback"});
                    model.addHtml(StringUtils.join((Iterable)errorMessages, (String)" "));
                    model.addCloseElement();
                };
            }
        }
        return null;
    }

    private boolean isCheckboxGroup(FormGroupElement group) {
        return group.getControl() instanceof CheckboxFormElement;
    }
}

