/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.thymeleaf;

import com.foreach.across.modules.bootstrapui.elements.FormViewElement;
import com.foreach.across.modules.web.thymeleaf.ThymeleafModelBuilder;
import com.foreach.across.modules.web.ui.elements.HtmlViewElement;
import com.foreach.across.modules.web.ui.elements.thymeleaf.AbstractHtmlViewElementModelWriter;
import java.util.Map;
import java.util.UUID;
import org.springframework.http.HttpMethod;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.support.RequestContext;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.spring5.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.standard.expression.VariableExpression;
import org.thymeleaf.util.StringUtils;

public class FormViewElementModelWriter
extends AbstractHtmlViewElementModelWriter<FormViewElement> {
    public static final String VAR_CURRENT_BOOTSTRAP_FORM = "_currentBootstrapForm";
    private static final String VAR_BOUND_ERRORS = "_temporaryErrorsAttribute";

    protected void writeOpenElement(FormViewElement form, ThymeleafModelBuilder model) {
        super.writeOpenElement((HtmlViewElement)form, model);
        ITemplateContext templateContext = model.getTemplateContext();
        if (templateContext instanceof IEngineContext) {
            IEngineContext engineContext = (IEngineContext)templateContext;
            engineContext.setVariable(VAR_CURRENT_BOOTSTRAP_FORM, (Object)form);
            this.registerBoundObject(form, engineContext);
        }
    }

    private void registerBoundObject(FormViewElement form, IEngineContext engineContext) {
        String commandAttribute = form.getCommandAttribute();
        RequestContext requestContext = (RequestContext)engineContext.getVariable("springRequestContext");
        if (form.getErrors() != null) {
            Map requestContextModel = requestContext.getModel();
            String beanName = UUID.randomUUID().toString();
            String bindingResultName = BindingResult.MODEL_KEY_PREFIX + beanName;
            if (requestContextModel != null) {
                requestContextModel.put(bindingResultName, form.getErrors());
            } else {
                engineContext.setVariable(bindingResultName, (Object)form.getErrors());
            }
            commandAttribute = beanName;
            engineContext.setVariable(VAR_BOUND_ERRORS, (Object)bindingResultName);
        }
        if (commandAttribute == null && form.getCommandObject() != null) {
            commandAttribute = this.resolveCommandAttributeName(form.getCommandObject(), engineContext);
        }
        if (commandAttribute != null) {
            IEngineConfiguration configuration = engineContext.getConfiguration();
            IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser((IEngineConfiguration)configuration);
            VariableExpression varExpression = (VariableExpression)expressionParser.parseExpression((IExpressionContext)engineContext, this.commandAttributeName(commandAttribute));
            engineContext.setVariable("springBoundObjectExpression", (Object)varExpression);
        }
    }

    private String commandAttributeName(String attributeName) {
        return StringUtils.startsWith((Object)attributeName, (String)"${") != false ? attributeName : "${" + attributeName + "}";
    }

    private String resolveCommandAttributeName(Object commandObject, IEngineContext engineContext) {
        for (String variableName : engineContext.getVariableNames()) {
            if (engineContext.getVariable(variableName) != commandObject || engineContext.getVariable(BindingResult.MODEL_KEY_PREFIX + variableName) == null) continue;
            return variableName;
        }
        return null;
    }

    protected void writeCloseElement(FormViewElement viewElement, ThymeleafModelBuilder writer) {
        Map extraHiddenFields = RequestDataValueProcessorUtils.getExtraHiddenFields((ITemplateContext)writer.getTemplateContext());
        if (extraHiddenFields != null && extraHiddenFields.size() > 0) {
            extraHiddenFields.forEach((fieldName, fieldValue) -> {
                if (this.shouldWriteExtraField((String)fieldName, viewElement.getMethod())) {
                    writer.addOpenElement("input");
                    writer.addAttribute("type", new Object[]{"hidden"});
                    writer.addAttribute("name", new Object[]{fieldName});
                    writer.addAttribute("value", new Object[]{fieldValue});
                    writer.addCloseElement();
                }
            });
        }
        super.writeCloseElement((HtmlViewElement)viewElement, writer);
        ITemplateContext templateContext = writer.getTemplateContext();
        if (templateContext instanceof IEngineContext) {
            this.removeBoundObject((IEngineContext)templateContext);
        }
    }

    private void removeBoundObject(IEngineContext templateContext) {
        String attr = (String)templateContext.getVariable(VAR_BOUND_ERRORS);
        if (attr != null) {
            Map requestContextModel;
            templateContext.removeVariable(attr);
            RequestContext requestContext = (RequestContext)templateContext.getVariable("springRequestContext");
            if (requestContext != null && (requestContextModel = requestContext.getModel()) != null) {
                requestContextModel.remove(attr);
            }
        }
    }

    private boolean shouldWriteExtraField(String fieldName, HttpMethod httpMethod) {
        return httpMethod != HttpMethod.GET || !"_csrf".equals(fieldName);
    }
}

