/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.thymeleaf;

import com.foreach.across.modules.bootstrapui.elements.ScriptViewElement;
import com.foreach.across.modules.web.thymeleaf.ThymeleafModelBuilder;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElement;
import com.foreach.across.modules.web.ui.elements.thymeleaf.AbstractHtmlViewElementModelWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.NamedThreadLocal;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.ITemplateEvent;

public class ScriptViewElementModelWriter
extends AbstractHtmlViewElementModelWriter<ScriptViewElement> {
    private static final ThreadLocal<List<DeferredScript>> writingOrder = new NamedThreadLocal("nestedScriptViewElements");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeModel(ScriptViewElement viewElement, ThymeleafModelBuilder model) {
        boolean threadLocalCreated = this.registerNestedScripts();
        List<DeferredScript> scripts = writingOrder.get();
        try {
            if (threadLocalCreated) {
                super.writeModel((HtmlViewElement)viewElement, model);
            } else {
                String id = UUID.randomUUID().toString();
                scripts.add(new DeferredScript(id, viewElement));
                String refTagName = viewElement.getRefTagName();
                if (!StringUtils.isEmpty((CharSequence)refTagName)) {
                    model.addOpenElement(viewElement.getRefTagName());
                    model.addAttribute("style", new Object[]{"display: none; visibility: hidden;"});
                    model.addAttribute("id", new Object[]{model.retrieveHtmlId((ViewElement)viewElement)});
                    viewElement.getAttributes().forEach((x$0, xva$1) -> model.addAttribute(x$0, new Object[]{xva$1}));
                    model.addAttribute("data-bum-ref-id", new Object[]{id});
                    model.removeAttribute("type");
                    model.removeAttribute("src");
                    model.removeAttribute("charset");
                    model.removeAttribute("defer");
                    model.removeAttribute("async");
                    model.addCloseElement();
                }
            }
        }
        finally {
            if (threadLocalCreated) {
                writingOrder.set(null);
            }
        }
        if (threadLocalCreated) {
            scripts.forEach(deferredScript -> {
                IModel nestedScriptModel = model.createViewElementModel((ViewElement)((DeferredScript)deferredScript).script);
                ITemplateEvent event = nestedScriptModel.get(0);
                if (event instanceof IOpenElementTag) {
                    IOpenElementTag elementTag = (IOpenElementTag)event;
                    nestedScriptModel.replace(0, (ITemplateEvent)model.getModelFactory().setAttribute((IProcessableElementTag)elementTag, "id", ((DeferredScript)deferredScript).id));
                }
                model.addModel(nestedScriptModel);
            });
        }
    }

    private boolean registerNestedScripts() {
        if (writingOrder.get() == null) {
            writingOrder.set(new ArrayList());
            return true;
        }
        return false;
    }

    private static class DeferredScript {
        private final String id;
        private final ScriptViewElement script;

        public DeferredScript(String id, ScriptViewElement script) {
            this.id = id;
            this.script = script;
        }
    }
}

