/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.thymeleaf;

import com.foreach.across.modules.bootstrapui.elements.SelectFormElement;
import com.foreach.across.modules.bootstrapui.elements.thymeleaf.FormControlElementModelWriter;
import com.foreach.across.modules.web.thymeleaf.ThymeleafModelBuilder;
import com.foreach.across.modules.web.ui.elements.HtmlViewElement;
import com.foreach.across.modules.web.ui.elements.thymeleaf.AbstractHtmlViewElementModelWriter;

public class SelectFormElementModelWriter
extends FormControlElementModelWriter<SelectFormElement> {
    @Override
    protected void writeOpenElement(SelectFormElement control, ThymeleafModelBuilder model) {
        super.writeOpenElement(control, model);
        model.addAttributeValue("class", new Object[]{"form-control"});
        model.addBooleanAttribute("multiple", control.isMultiple());
    }

    protected void writeCloseElement(SelectFormElement control, ThymeleafModelBuilder model) {
        super.writeCloseElement((HtmlViewElement)control, model);
        if (control.getControlName() != null && control.isMultiple()) {
            model.addOpenElement("input");
            model.addAttribute("type", new Object[]{"hidden"});
            model.addAttribute("name", new Object[]{"_" + control.getControlName()});
            model.addAttribute("value", new Object[]{""});
            if (control.isDisabled() || control.hasAttribute("disabled")) {
                model.addBooleanAttribute("disabled", true);
            }
            model.addCloseElement();
        }
    }

    public static class OptionGroupBuilder
    extends AbstractHtmlViewElementModelWriter<SelectFormElement.OptionGroup> {
        protected void writeOpenElement(SelectFormElement.OptionGroup optionGroup, ThymeleafModelBuilder writer) {
            super.writeOpenElement((HtmlViewElement)optionGroup, writer);
            writer.addBooleanAttribute("disabled", optionGroup.isDisabled());
            writer.addAttribute("label", new Object[]{optionGroup.getLabel()});
        }
    }

    public static class OptionBuilder
    extends AbstractHtmlViewElementModelWriter<SelectFormElement.Option> {
        protected void writeOpenElement(SelectFormElement.Option option, ThymeleafModelBuilder writer) {
            super.writeOpenElement((HtmlViewElement)option, writer);
            writer.addBooleanAttribute("disabled", option.isDisabled());
            writer.addBooleanAttribute("selected", option.isSelected());
            writer.addAttribute("value", new Object[]{option.getValue()});
            String text = option.getText();
            if (text != null) {
                writer.addAttribute("label", new Object[]{option.getLabel()});
            } else {
                text = option.getLabel();
            }
            writer.addText(text);
        }
    }
}

