/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.elements.tooltip;

import com.foreach.across.modules.bootstrapui.attributes.BootstrapAttributes;
import com.foreach.across.modules.bootstrapui.elements.builder.AbstractHtmlSupportingNodeViewElementBuilder;
import com.foreach.across.modules.bootstrapui.elements.tooltip.TooltipViewElement;
import com.foreach.across.modules.bootstrapui.styles.BootstrapStyles;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.AbstractNodeViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElements;
import lombok.NonNull;

public class TooltipViewElementBuilder
extends AbstractHtmlSupportingNodeViewElementBuilder<TooltipViewElement, TooltipViewElementBuilder> {
    private String text;
    private ViewElement icon;
    @NonNull
    private String tagName;

    public TooltipViewElementBuilder() {
        this.icon = HtmlViewElements.html.i(new ViewElement.WitherSetter[]{BootstrapStyles.css.fa.solid("question-circle"), BootstrapAttributes.attribute.aria.hidden});
        this.escapeHtml(false);
    }

    protected TooltipViewElement createElement(ViewElementBuilderContext builderContext) {
        TooltipViewElement tooltip = new TooltipViewElement();
        tooltip.setEscapeHtml(this.isEscapeHtml());
        tooltip.setIcon(this.icon);
        if (this.tagName != null) {
            tooltip.setTagName(this.tagName);
        }
        if (this.text != null) {
            tooltip.setText(builderContext.resolveText(this.text));
        }
        return (TooltipViewElement)this.apply((AbstractNodeViewElement)tooltip, builderContext);
    }

    public TooltipViewElementBuilder text(String text) {
        this.text = text;
        return this;
    }

    public TooltipViewElementBuilder icon(ViewElement icon) {
        this.icon = icon;
        return this;
    }

    public TooltipViewElementBuilder tagName(@NonNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException("tagName is marked non-null but is null");
        }
        this.tagName = tagName;
        return this;
    }
}

