/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.styles;

import com.foreach.across.modules.bootstrapui.styles.AppendingBootstrapStyleRule;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElement;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.NonNull;

@FunctionalInterface
public interface BootstrapStyleRule
extends ViewElement.WitherSetter<HtmlViewElement>,
ViewElement.WitherRemover<HtmlViewElement>,
Predicate<HtmlViewElement> {
    public static BootstrapStyleRule empty() {
        return BootstrapStyleRule.of(new String[0]);
    }

    public static BootstrapStyleRule of(String ... css) {
        return () -> css;
    }

    public static BootstrapStyleRule appendOnSet(BootstrapStyleRule original, String ... css) {
        return new AppendingBootstrapStyleRule(original, css);
    }

    public static BootstrapStyleRule combine(BootstrapStyleRule ... rules) {
        return () -> (String[])Stream.of(rules).map(BootstrapStyleRule::toCssClasses).flatMap(Stream::of).toArray(String[]::new);
    }

    public String[] toCssClasses();

    default public void removeFrom(HtmlViewElement target) {
        target.removeCssClass(this.toCssClasses());
    }

    default public void applyTo(HtmlViewElement target) {
        target.addCssClass(this.toCssClasses());
    }

    default public BootstrapStyleRule suffix(@NonNull String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("suffix is marked non-null but is null");
        }
        String[] cssClasses = (String[])Stream.of(this.toCssClasses()).map(s -> s + "-" + suffix).toArray(String[]::new);
        return () -> cssClasses;
    }

    default public BootstrapStyleRule prefix(@NonNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix is marked non-null but is null");
        }
        String[] cssClasses = (String[])Stream.of(this.toCssClasses()).map(s -> prefix + "-" + s).toArray(String[]::new);
        return () -> cssClasses;
    }

    @Override
    default public boolean test(HtmlViewElement target) {
        for (String cssClassName : this.toCssClasses()) {
            if (target.hasCssClass(cssClassName)) continue;
            return false;
        }
        return true;
    }
}

