/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.styles.utilities;

import com.foreach.across.modules.bootstrapui.styles.BootstrapStyleRule;
import com.foreach.across.modules.bootstrapui.styles.utilities.BreakpointStyleRule;
import com.foreach.across.modules.web.ui.elements.HtmlViewElement;
import org.apache.commons.lang3.ArrayUtils;

public class SimpleBreakpointStyleRule
implements BreakpointStyleRule {
    private final String prefix;
    private final String suffix;
    private final String[] additionalCss;

    public SimpleBreakpointStyleRule(String prefix, String suffix, String ... additionalCss) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.additionalCss = additionalCss;
    }

    @Override
    public BootstrapStyleRule on(String breakpoint) {
        return BootstrapStyleRule.appendOnSet(BootstrapStyleRule.of(this.additionalCss), this.prefix + "-" + breakpoint + (this.suffix != null ? "-" + this.suffix : ""));
    }

    @Override
    public String[] toCssClasses() {
        return (String[])ArrayUtils.add((Object[])this.additionalCss, (Object)(this.prefix + (this.suffix != null ? "-" + this.suffix : "")));
    }

    @Override
    public void removeFrom(HtmlViewElement target) {
        target.removeCssClass(new String[]{this.prefix + (this.suffix != null ? "-" + this.suffix : "")});
    }
}

