/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.styles.utilities;

import com.foreach.across.modules.bootstrapui.styles.utilities.BreakpointStyleRule;
import com.foreach.across.modules.bootstrapui.styles.utilities.SimpleBreakpointStyleRule;

public class SpacingStyleRule {
    public final BreakpointStyleRule none;
    public final BreakpointStyleRule s1;
    public final BreakpointStyleRule s2;
    public final BreakpointStyleRule s3;
    public final BreakpointStyleRule s4;
    public final BreakpointStyleRule s5;
    public final BreakpointStyleRule extraSmall;
    public final BreakpointStyleRule small;
    public final BreakpointStyleRule medium;
    public final BreakpointStyleRule large;
    public final BreakpointStyleRule extraLarge;
    private final String prefix;

    SpacingStyleRule(String prefix) {
        this(prefix, "");
    }

    private SpacingStyleRule(String prefix, String direction) {
        this.prefix = prefix;
        this.none = new SimpleBreakpointStyleRule(prefix, direction + "0", new String[0]);
        this.extraSmall = this.s1 = new SimpleBreakpointStyleRule(prefix, direction + "1", new String[0]);
        this.small = this.s2 = new SimpleBreakpointStyleRule(prefix, direction + "2", new String[0]);
        this.medium = this.s3 = new SimpleBreakpointStyleRule(prefix, direction + "3", new String[0]);
        this.large = this.s4 = new SimpleBreakpointStyleRule(prefix, direction + "4", new String[0]);
        this.extraLarge = this.s5 = new SimpleBreakpointStyleRule(prefix, direction + "5", new String[0]);
    }

    public BreakpointStyleRule size(int size) {
        return new SimpleBreakpointStyleRule(this.prefix, "" + size, new String[0]);
    }

    public static class WithNegative
    extends SpacingStyleRule {
        public final BreakpointStyleRule auto;
        public final SpacingStyleRule negative;

        WithNegative(String prefix) {
            super(prefix);
            this.negative = new SpacingStyleRule(prefix, "n");
            this.auto = new SimpleBreakpointStyleRule(prefix, "auto", new String[0]);
        }
    }
}

