/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.utils;

import com.foreach.across.modules.bootstrapui.elements.FormControlElement;
import com.foreach.across.modules.bootstrapui.elements.FormGroupElement;
import com.foreach.across.modules.bootstrapui.utils.ControlNamePrefixAdjuster;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import lombok.NonNull;

public abstract class BootstrapElementUtils {
    protected BootstrapElementUtils() {
    }

    public static FormControlElement getFormControl(ViewElement viewElement) {
        return BootstrapElementUtils.getFormControl(viewElement, FormControlElement.class);
    }

    public static <V extends FormControlElement> V getFormControl(ViewElement viewElement, Class<V> expectedType) {
        ViewElement candidate;
        FormControlElement control = null;
        if (viewElement instanceof FormGroupElement) {
            candidate = ((FormGroupElement)viewElement).getControl();
            if (candidate != null) {
                control = (FormControlElement)BootstrapElementUtils.getFormControl(candidate, expectedType);
            }
        } else if (viewElement instanceof FormControlElement.Proxy) {
            candidate = ((FormControlElement.Proxy)viewElement).getControl();
            if (candidate != null) {
                control = BootstrapElementUtils.getFormControl(candidate, expectedType);
            }
        } else if (expectedType.isInstance(viewElement)) {
            control = (FormControlElement)expectedType.cast(viewElement);
        }
        if (control == null && viewElement instanceof ContainerViewElement) {
            for (ViewElement child : ((ContainerViewElement)viewElement).getChildren()) {
                control = BootstrapElementUtils.getFormControl(child, expectedType);
                if (control == null) continue;
                return (V)control;
            }
        }
        return (V)control;
    }

    public static void prefixControlNames(@NonNull String prefix, @NonNull ContainerViewElement container) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix is marked non-null but is null");
        }
        if (container == null) {
            throw new IllegalArgumentException("container is marked non-null but is null");
        }
        BootstrapElementUtils.prefixControlNames(prefix).accept((ViewElement)container);
    }

    public static void replaceControlNamesPrefix(@NonNull String prefixToReplace, @NonNull String newPrefix, @NonNull ContainerViewElement container) {
        if (prefixToReplace == null) {
            throw new IllegalArgumentException("prefixToReplace is marked non-null but is null");
        }
        if (newPrefix == null) {
            throw new IllegalArgumentException("newPrefix is marked non-null but is null");
        }
        if (container == null) {
            throw new IllegalArgumentException("container is marked non-null but is null");
        }
        BootstrapElementUtils.replaceControlNamesPrefix(prefixToReplace, newPrefix).accept((ViewElement)container);
    }

    public static <T extends ViewElement> ControlNamePrefixAdjuster<T> prefixControlNames(@NonNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix is marked non-null but is null");
        }
        return new ControlNamePrefixAdjuster().prefixToAdd(prefix);
    }

    public static <T extends ViewElement> ControlNamePrefixAdjuster<T> replaceControlNamesPrefix(@NonNull String prefixToReplace, @NonNull String newPrefix) {
        if (prefixToReplace == null) {
            throw new IllegalArgumentException("prefixToReplace is marked non-null but is null");
        }
        if (newPrefix == null) {
            throw new IllegalArgumentException("newPrefix is marked non-null but is null");
        }
        return new ControlNamePrefixAdjuster().prefixToReplace(prefixToReplace).prefixToAdd(newPrefix);
    }
}

