/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.bootstrapui.utils;

import com.foreach.across.modules.bootstrapui.elements.FormControlElement;
import com.foreach.across.modules.bootstrapui.elements.FormInputElement;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.ViewElementPostProcessor;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import java.util.IdentityHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class ControlNamePrefixAdjuster<T extends ViewElement>
implements Consumer<T>,
ViewElementPostProcessor<T> {
    private String prefixToReplace;
    @NonNull
    private String prefixToAdd;
    private boolean insertDotSeparator = true;
    private boolean recurse = true;
    private boolean ignoreUnderscore = true;
    private Predicate<FormInputElement> elementPredicate;
    private Predicate<String> controlNamePredicate;

    public void postProcess(ViewElementBuilderContext builderContext, ViewElement element) {
        this.accept(element);
    }

    @Override
    public void accept(ViewElement element) {
        if (this.prefixToAdd == null || element == null) {
            return;
        }
        if (element instanceof FormInputElement) {
            this.replaceControlNamePrefix((FormInputElement)element);
        }
        if (this.recurse && element instanceof ContainerViewElement) {
            IdentityHashMap processed = new IdentityHashMap();
            ((ContainerViewElement)element).findAll(FormInputElement.class, i -> !FormControlElement.Proxy.class.isInstance(i)).forEach(control -> {
                if (!processed.containsKey(control)) {
                    this.replaceControlNamePrefix((FormInputElement)control);
                    processed.put(control, null);
                }
            });
        }
    }

    private void replaceControlNamePrefix(FormInputElement control) {
        if (this.elementPredicate != null && !this.elementPredicate.test(control)) {
            return;
        }
        String currentControlName = control.getControlName();
        if (currentControlName != null && !currentControlName.isEmpty()) {
            if (this.controlNamePredicate != null && !this.controlNamePredicate.test(this.removeUnderscore(currentControlName))) {
                return;
            }
            boolean underscored = this.shouldSkipUnderscore(currentControlName);
            if (underscored) {
                currentControlName = currentControlName.substring(1);
            }
            String newControlName = null;
            if (StringUtils.isEmpty((CharSequence)this.prefixToReplace)) {
                newControlName = this.addPrefix(currentControlName);
            } else if (currentControlName.startsWith(this.prefixToReplace)) {
                newControlName = this.addPrefix(StringUtils.removeStart((String)currentControlName, (String)this.prefixToReplace));
            }
            if (newControlName != null && !newControlName.equals(currentControlName)) {
                if (underscored) {
                    control.setControlName('_' + newControlName);
                } else {
                    control.setControlName(newControlName);
                }
            }
        }
    }

    private String removeUnderscore(String controlName) {
        return this.ignoreUnderscore && controlName.charAt(0) == '_' ? controlName.substring(1) : controlName;
    }

    private boolean shouldSkipUnderscore(String controlName) {
        return this.ignoreUnderscore && controlName.charAt(0) == '_' && (StringUtils.isEmpty((CharSequence)this.prefixToReplace) || this.prefixToReplace.charAt(0) != '_');
    }

    private String addPrefix(String controlName) {
        if (StringUtils.isEmpty((CharSequence)this.prefixToAdd)) {
            return controlName;
        }
        if (this.insertDotSeparator && this.prefixToAdd.charAt(this.prefixToAdd.length() - 1) != '.' && controlName.charAt(0) != '[' && controlName.charAt(0) != '(' && controlName.charAt(0) != '{' && controlName.charAt(0) != '.') {
            return this.prefixToAdd + "." + controlName;
        }
        return this.prefixToAdd + controlName;
    }

    public ControlNamePrefixAdjuster<T> prefixToReplace(String prefixToReplace) {
        this.prefixToReplace = prefixToReplace;
        return this;
    }

    public ControlNamePrefixAdjuster<T> prefixToAdd(@NonNull String prefixToAdd) {
        if (prefixToAdd == null) {
            throw new IllegalArgumentException("prefixToAdd is marked non-null but is null");
        }
        this.prefixToAdd = prefixToAdd;
        return this;
    }

    public ControlNamePrefixAdjuster<T> insertDotSeparator(boolean insertDotSeparator) {
        this.insertDotSeparator = insertDotSeparator;
        return this;
    }

    public ControlNamePrefixAdjuster<T> recurse(boolean recurse) {
        this.recurse = recurse;
        return this;
    }

    public ControlNamePrefixAdjuster<T> ignoreUnderscore(boolean ignoreUnderscore) {
        this.ignoreUnderscore = ignoreUnderscore;
        return this;
    }

    public ControlNamePrefixAdjuster<T> elementPredicate(Predicate<FormInputElement> elementPredicate) {
        this.elementPredicate = elementPredicate;
        return this;
    }

    public ControlNamePrefixAdjuster<T> controlNamePredicate(Predicate<String> controlNamePredicate) {
        this.controlNamePredicate = controlNamePredicate;
        return this;
    }
}

