/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.properties.config;

import com.foreach.across.core.AcrossModule;
import com.foreach.across.core.annotations.Module;
import com.foreach.across.core.context.info.AcrossModuleInfo;
import com.foreach.across.modules.properties.config.EntityPropertiesDescriptor;
import com.foreach.across.modules.properties.registries.EntityPropertiesRegistry;
import com.foreach.across.modules.properties.repositories.PropertyTrackingRepository;
import com.foreach.across.modules.properties.services.EntityPropertiesServiceBase;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.convert.ConversionService;

public abstract class AbstractEntityPropertiesConfiguration
implements EntityPropertiesDescriptor {
    private final boolean allowTableConfiguration;
    @Autowired
    @Qualifier(value="acrossDataSource")
    private DataSource primaryDataSource;
    @Autowired
    @Module(value="PropertiesModule")
    private AcrossModuleInfo propertiesModule;
    @Autowired
    @Module(value="across.currentModule")
    protected AcrossModule currentModule;

    protected AbstractEntityPropertiesConfiguration() {
        this(true);
    }

    protected AbstractEntityPropertiesConfiguration(boolean allowTableConfiguration) {
        this.allowTableConfiguration = allowTableConfiguration;
    }

    @Override
    public DataSource dataSource() {
        return this.primaryDataSource;
    }

    @Override
    public ConversionService conversionService() {
        return (ConversionService)this.propertiesModule.getApplicationContext().getBean("propertiesConversionService");
    }

    @Override
    public String tableName() {
        return this.originalTableName();
    }

    @Override
    public PropertyTrackingRepository trackingRepository() {
        return (PropertyTrackingRepository)this.propertiesModule.getApplicationContext().getBean(PropertyTrackingRepository.class);
    }

    protected abstract String originalTableName();

    @Override
    public abstract EntityPropertiesServiceBase service();

    @Override
    public abstract EntityPropertiesRegistry registry();
}

