/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.properties.config;

import com.foreach.across.core.AcrossException;
import com.foreach.across.core.annotations.Module;
import com.foreach.across.core.context.info.AcrossModuleInfo;
import com.foreach.across.core.filters.BeanFilter;
import com.foreach.across.core.filters.ClassBeanFilter;
import com.foreach.across.modules.properties.PropertiesModuleSettings;
import com.foreach.common.spring.convert.HierarchicalConversionService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;

@Configuration
public class ConversionServiceConfiguration {
    public static final String CONVERSION_SERVICE_BEAN = "propertiesConversionService";
    @Autowired
    @Module(value="across.currentModule")
    private AcrossModuleInfo currentModuleInfo;
    @Autowired
    private PropertiesModuleSettings settings;
    @Autowired
    private ApplicationContext applicationContext;

    @Bean(name={"propertiesConversionService"})
    public ConversionService propertiesConversionService() {
        ConversionService conversionServiceToUse = this.settings.getConversionService();
        if (conversionServiceToUse == null) {
            String beanName = this.settings.getConversionServiceBean();
            if (beanName != null) {
                try {
                    conversionServiceToUse = (ConversionService)this.applicationContext.getBean(beanName);
                }
                catch (NoSuchBeanDefinitionException nsbde) {
                    throw new AcrossException("A ConversionService bean name was specified but there was a problem wiring it", (Throwable)nsbde);
                }
            } else {
                HierarchicalConversionService conversionService = HierarchicalConversionService.defaultConversionService((ConversionService)this.getConversionServiceBeanFromParent());
                if (conversionService.getParent() == null) {
                    this.currentModuleInfo.getBootstrapConfiguration().addExposeFilter(new BeanFilter[]{new ClassBeanFilter(new Class[]{ConversionService.class})});
                }
                conversionServiceToUse = conversionService;
            }
        }
        return conversionServiceToUse;
    }

    private ConversionService getConversionServiceBeanFromParent() {
        try {
            return (ConversionService)this.applicationContext.getBean("conversionService", ConversionService.class);
        }
        catch (BeansException be) {
            return null;
        }
    }
}

