/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.properties.registries;

import com.foreach.across.core.context.AcrossModuleEntity;
import com.foreach.across.modules.properties.config.EntityPropertiesDescriptor;
import com.foreach.across.modules.properties.repositories.PropertyTrackingRepository;
import com.foreach.common.spring.properties.PropertyFactory;
import com.foreach.common.spring.properties.PropertyTypeRegistry;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.Assert;

public abstract class EntityPropertiesRegistry {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final PropertyTypeRegistry<String> propertyTypeRegistry;
    private final EntityPropertiesDescriptor descriptor;
    private final PropertyTrackingRepository propertyTrackingRepository;

    protected EntityPropertiesRegistry(EntityPropertiesDescriptor descriptor) {
        this(descriptor, null);
    }

    protected EntityPropertiesRegistry(EntityPropertiesDescriptor descriptor, Class classForUnknownProperties) {
        this.descriptor = descriptor;
        this.propertyTypeRegistry = classForUnknownProperties != null ? new PropertyTypeRegistry(classForUnknownProperties, descriptor.conversionService()) : new PropertyTypeRegistry(descriptor.conversionService());
        this.propertyTrackingRepository = descriptor.trackingRepository();
        Assert.notNull((Object)descriptor.conversionService(), (String)"EntityPropertiesRegistry requires a valid ConversionService");
    }

    public PropertyTypeRegistry<String> getPropertyTypeRegistry() {
        return this.propertyTypeRegistry;
    }

    public ConversionService getDefaultConversionService() {
        return this.propertyTypeRegistry.getDefaultConversionService();
    }

    public void register(AcrossModuleEntity acrossModule, String propertyKey, Class<?> propertyClass) {
        this.register(acrossModule, propertyKey, TypeDescriptor.valueOf(propertyClass));
    }

    public void register(AcrossModuleEntity acrossModule, String propertyKey, TypeDescriptor propertyType) {
        this.register(acrossModule.getName(), propertyKey, propertyType, null, null);
    }

    public <A> void register(AcrossModuleEntity acrossModule, String propertyKey, Class<A> propertyClass, PropertyFactory<String, A> defaultValue) {
        this.register(acrossModule, propertyKey, TypeDescriptor.valueOf(propertyClass), defaultValue);
    }

    public void register(AcrossModuleEntity acrossModule, String propertyKey, TypeDescriptor propertyType, PropertyFactory<String, ?> defaultValue) {
        this.register(acrossModule.getName(), propertyKey, propertyType, defaultValue, null);
    }

    public <A> void register(AcrossModuleEntity acrossModule, String propertyKey, Class<A> propertyClass, PropertyFactory<String, A> defaultValue, ConversionService conversionService) {
        this.register(acrossModule, propertyKey, TypeDescriptor.valueOf(propertyClass), defaultValue, conversionService);
    }

    public <A> void register(AcrossModuleEntity acrossModule, String propertyKey, TypeDescriptor propertyType, PropertyFactory<String, A> defaultValue, ConversionService conversionService) {
        this.register(acrossModule.getName(), propertyKey, propertyType, defaultValue, conversionService);
    }

    private void trackProperty(String owner, String propertyKey) {
        if (this.propertyTrackingRepository != null) {
            try {
                this.propertyTrackingRepository.register(owner, this.descriptor, propertyKey);
            }
            catch (Exception e) {
                this.LOG.warn("Tracking property registration failed", (Throwable)e);
            }
        }
    }

    private <A> void register(String owner, String propertyKey, TypeDescriptor typeDescriptor, PropertyFactory<String, A> propertyValue, ConversionService conversionService) {
        Assert.notNull((Object)owner, (String)"An owner is required for a registered property.");
        this.trackProperty(owner, propertyKey);
        this.propertyTypeRegistry.register((Object)propertyKey, typeDescriptor, propertyValue, conversionService);
    }

    public void unregister(String propertyKey) {
        this.propertyTypeRegistry.unregister((Object)propertyKey);
    }

    public TypeDescriptor getTypeForProperty(String propertyKey) {
        return this.propertyTypeRegistry.getTypeForProperty((Object)propertyKey);
    }

    public Object getDefaultValueForProperty(String propertyKey) {
        return this.propertyTypeRegistry.getDefaultValueForProperty((Object)propertyKey);
    }

    public Class getClassForUnknownProperties() {
        return this.propertyTypeRegistry.getClassForUnknownProperties();
    }

    public void setClassForUnknownProperties(Class classForUnknownProperties) {
        this.propertyTypeRegistry.setClassForUnknownProperties(classForUnknownProperties);
    }

    public boolean isRegistered(String propertyKey) {
        return this.propertyTypeRegistry.isRegistered((Object)propertyKey);
    }

    public Collection<String> getRegisteredProperties() {
        return this.propertyTypeRegistry.getRegisteredProperties();
    }

    public boolean isEmpty() {
        return this.propertyTypeRegistry.isEmpty();
    }

    public void clear() {
        this.propertyTypeRegistry.clear();
    }
}

