/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.properties.repositories;

import com.foreach.across.modules.properties.business.StringPropertiesSource;
import com.foreach.across.modules.properties.config.EntityPropertiesDescriptor;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.ConversionService;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;

public class EntityPropertiesRepository<T> {
    private final Class<T> clazz;
    private final String SQL_INSERT_PROPERTY;
    private final String SQL_SELECT_PROPERTIES;
    private final String SQL_DROP_PROPERTIES;
    private final String SQL_SELECT_ENTITIES_WITH_PROPERTY;
    private final String keyColumn;
    private final ConversionService conversionService;
    private final JdbcTemplate jdbcTemplate;

    public EntityPropertiesRepository(EntityPropertiesDescriptor configuration) {
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.clazz = (Class)genericSuperclass.getActualTypeArguments()[0];
        this.jdbcTemplate = new JdbcTemplate(configuration.dataSource());
        String table = configuration.tableName();
        this.keyColumn = configuration.keyColumnName();
        this.conversionService = configuration.conversionService();
        this.SQL_INSERT_PROPERTY = String.format("INSERT INTO %s (%s,property_name,property_value) VALUES (?,?,?)", table, this.keyColumn);
        this.SQL_SELECT_PROPERTIES = String.format("SELECT property_name, property_value FROM %s WHERE %s = ?", table, this.keyColumn);
        this.SQL_DROP_PROPERTIES = String.format("DELETE FROM %s WHERE %s = ?", table, this.keyColumn);
        this.SQL_SELECT_ENTITIES_WITH_PROPERTY = String.format("SELECT DISTINCT %s FROM %s WHERE property_name = ? AND property_value = ?", this.keyColumn, table);
    }

    @Transactional(readOnly=true)
    public Collection<T> getEntityIdsForPropertyValue(String propertyName, Object propertyValue) {
        String valueAsString = propertyValue != null ? (String)this.conversionService.convert(propertyValue, String.class) : null;
        List rows = this.jdbcTemplate.queryForList(this.SQL_SELECT_ENTITIES_WITH_PROPERTY, new Object[]{propertyName, valueAsString});
        ArrayList<T> entityIdList = new ArrayList<T>(rows.size());
        for (Map entry : rows) {
            entityIdList.add(this.convertObjectToRequiredType(entry.get(this.keyColumn)));
        }
        return entityIdList;
    }

    private T convertObjectToRequiredType(Object value) {
        if (this.clazz.isInstance(value)) {
            return (T)value;
        }
        return (T)this.conversionService.convert(value, this.clazz);
    }

    @Transactional(readOnly=true)
    public StringPropertiesSource loadProperties(T entityId) {
        List properties = this.jdbcTemplate.queryForList(this.SQL_SELECT_PROPERTIES, new Object[]{entityId});
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        for (Map entry : properties) {
            sourceMap.put((String)entry.get("property_name"), (String)entry.get("property_value"));
        }
        return new StringPropertiesSource(sourceMap);
    }

    @Transactional
    public void saveProperties(T entityId, StringPropertiesSource properties) {
        this.deleteProperties(entityId);
        for (Map.Entry entry : properties.getProperties().entrySet()) {
            this.jdbcTemplate.update(this.SQL_INSERT_PROPERTY, new Object[]{entityId, entry.getKey(), entry.getValue()});
        }
    }

    @Transactional
    public void deleteProperties(T entityId) {
        this.jdbcTemplate.update(this.SQL_DROP_PROPERTIES, new Object[]{entityId});
    }
}

