/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.properties.repositories;

import com.foreach.across.modules.properties.config.EntityPropertiesDescriptor;
import java.util.Date;
import java.util.UUID;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;

@Repository
public class PropertyTrackingRepository {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyTrackingRepository.class);
    private static final String SQL_SELECT = "SELECT uuid FROM across_property_tracking WHERE hash_code = ? AND module = ? AND properties_id = ? AND database_table = ? AND property_name = ?";
    private static final String SQL_INSERT = "INSERT INTO across_property_tracking (uuid, hash_code, module, properties_id, database_table, property_name, first_registration, last_registration) VALUES (?,?,?,?,?,?,?,?)";
    private static final String SQL_UPDATE = "UPDATE across_property_tracking SET last_registration = ? WHERE uuid = ?";
    private JdbcTemplate jdbcTemplate;

    public PropertyTrackingRepository(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized void register(String moduleName, EntityPropertiesDescriptor descriptor, String propertyName) {
        LOG.debug("Registering {} property {} for module {}", new Object[]{descriptor.propertiesId(), propertyName, moduleName});
        String hashCode = this.hashCode(moduleName, descriptor.propertiesId(), descriptor.tableName(), propertyName);
        String id = this.existingRecordId(hashCode, moduleName, descriptor.propertiesId(), descriptor.tableName(), propertyName);
        if (id == null) {
            this.createRecord(hashCode, moduleName, descriptor.propertiesId(), descriptor.tableName(), propertyName);
        } else {
            this.updateRegistrationTimestamp(id);
        }
    }

    private void createRecord(String hashCode, String moduleName, String propertiesId, String databaseTable, String propertyName) {
        String id = UUID.randomUUID().toString();
        Date timestamp = new Date();
        this.jdbcTemplate.update(SQL_INSERT, new Object[]{id, hashCode, moduleName, propertiesId, databaseTable, propertyName, timestamp, timestamp});
    }

    private void updateRegistrationTimestamp(String id) {
        this.jdbcTemplate.update(SQL_UPDATE, new Object[]{new Date(), id});
    }

    private String existingRecordId(String hashCode, String moduleName, String propertiesId, String databaseTable, String propertyName) {
        try {
            return (String)this.jdbcTemplate.queryForObject(SQL_SELECT, String.class, new Object[]{hashCode, moduleName, propertiesId, databaseTable, propertyName});
        }
        catch (EmptyResultDataAccessException erdae) {
            return null;
        }
    }

    private String hashCode(String moduleName, String propertiesId, String databaseTable, String propertyName) {
        String hashString = moduleName + propertiesId + databaseTable + propertyName;
        return DigestUtils.md5DigestAsHex((byte[])hashString.getBytes());
    }
}

