/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.properties.repositories;

import com.foreach.across.core.revision.Revision;
import com.foreach.across.core.revision.RevisionBasedEntity;
import com.foreach.across.core.revision.RevisionBasedEntityManager;
import com.foreach.across.modules.properties.business.StringPropertiesSource;
import com.foreach.across.modules.properties.config.EntityPropertiesDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;

public class RevisionBasedEntityPropertiesRepository<T, R extends Revision<T>>
extends RevisionBasedEntityManager<PropertyRevision<T>, T, R> {
    private static final String FILTER_FOR_REVISION = "first_revision >= 0 and first_revision <= ? and (removal_revision = 0 or removal_revision > ?)";
    private static final String FILTER_FOR_LATEST = "first_revision >= 0 and removal_revision = 0";
    private static final String FILTER_FOR_LATEST_AND_DRAFTS = "(first_revision = -1 or removal_revision = 0)";
    private final String SQL_INSERT_PROPERTY;
    private final String SQL_SELECT_PROPERTIES;
    private final String SQL_DROP_PROPERTIES;
    private final String SQL_UPDATE_PROPERTY;
    private final String SQL_DELETE_PROPERTY;
    private final JdbcTemplate jdbcTemplate;

    public RevisionBasedEntityPropertiesRepository(EntityPropertiesDescriptor configuration) {
        this.jdbcTemplate = new JdbcTemplate(configuration.dataSource());
        String table = configuration.tableName();
        String keyColumn = configuration.keyColumnName();
        this.SQL_INSERT_PROPERTY = String.format("INSERT INTO %s (%s,property_name,property_value,first_revision,removal_revision,delete_for_revision) VALUES (?,?,?,?,?,?)", table, keyColumn);
        this.SQL_SELECT_PROPERTIES = String.format("SELECT property_name, property_value,first_revision,removal_revision,delete_for_revision FROM %s WHERE %s = ?", table, keyColumn) + " AND %s";
        this.SQL_UPDATE_PROPERTY = String.format("UPDATE %s SET property_value = ?, first_revision = ?, removal_revision = ?, delete_for_revision = ? WHERE %s = ? AND property_name = ? AND first_revision = ? AND removal_revision = ?", table, keyColumn);
        this.SQL_DELETE_PROPERTY = String.format("DELETE FROM %s WHERE %s = ? AND property_name = ? AND first_revision = ? AND removal_revision = ?", table, keyColumn);
        this.SQL_DROP_PROPERTIES = String.format("DELETE FROM %s WHERE %s = ?", table, keyColumn);
    }

    protected void insert(PropertyRevision<T> entity) {
        this.jdbcTemplate.update(this.SQL_INSERT_PROPERTY, new Object[]{entity.getOwner(), entity.getName(), entity.getValue(), entity.getFirstRevision(), entity.getRemovalRevision(), entity.isDeleteForRevision()});
    }

    protected void update(PropertyRevision<T> entity, int currentFirstRevision, int currentLastRevision) {
        this.jdbcTemplate.update(this.SQL_UPDATE_PROPERTY, new Object[]{entity.getValue(), entity.getFirstRevision(), entity.getRemovalRevision(), entity.isDeleteForRevision(), entity.getOwner(), entity.getName(), currentFirstRevision, currentLastRevision});
    }

    protected void delete(PropertyRevision<T> entity) {
        this.jdbcTemplate.update(this.SQL_DELETE_PROPERTY, new Object[]{entity.getOwner(), entity.getName(), entity.getFirstRevision(), entity.getRemovalRevision()});
    }

    protected void deleteAllForOwner(T owner) {
        this.jdbcTemplate.update(this.SQL_DROP_PROPERTIES, new Object[]{owner});
    }

    protected Collection<PropertyRevision<T>> getAllForLatestRevision(T owner) {
        return this.buildProperties(owner, this.jdbcTemplate.queryForList(String.format(this.SQL_SELECT_PROPERTIES, FILTER_FOR_LATEST), new Object[]{owner}));
    }

    protected Collection<PropertyRevision<T>> getAllForSpecificRevision(T owner, int revisionNumber) {
        return this.buildProperties(owner, this.jdbcTemplate.queryForList(String.format(this.SQL_SELECT_PROPERTIES, FILTER_FOR_REVISION), new Object[]{owner, revisionNumber, revisionNumber}));
    }

    protected Collection<PropertyRevision<T>> getAllForDraftRevision(T owner) {
        return this.buildProperties(owner, this.jdbcTemplate.queryForList(String.format(this.SQL_SELECT_PROPERTIES, FILTER_FOR_LATEST_AND_DRAFTS), new Object[]{owner}));
    }

    protected PropertyRevision<T> createEntityFromExisting(PropertyRevision<T> existing) {
        PropertyRevision<T> candidate = new PropertyRevision<T>();
        candidate.setOwner(existing.getOwner());
        candidate.setName(existing.getName());
        candidate.setValue(existing.getValue());
        candidate.setDeleteForRevision(existing.isDeleteForRevision());
        return candidate;
    }

    protected void copyEntityValuesFromExisting(PropertyRevision<T> entity, PropertyRevision<T> existing) {
        entity.setValue(existing.getValue());
    }

    @Transactional(readOnly=true)
    public StringPropertiesSource loadProperties(T owner, int revisionNumber) {
        Collection entities = this.getEntitiesForRevision(owner, revisionNumber);
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        for (PropertyRevision property : entities) {
            sourceMap.put(property.getName(), property.getValue());
        }
        return new StringPropertiesSource(sourceMap);
    }

    @Transactional
    public StringPropertiesSource checkoutProperties(T owner, int revisionNumber) {
        Collection entities = this.checkout(owner, revisionNumber);
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        for (PropertyRevision property : entities) {
            sourceMap.put(property.getName(), property.getValue());
        }
        return new StringPropertiesSource(sourceMap);
    }

    @Transactional
    public void saveProperties(StringPropertiesSource properties, T owner, int revisionNumber) {
        LinkedList entities = new LinkedList();
        for (Map.Entry entry : properties.getProperties().entrySet()) {
            PropertyRevision<T> candidate = new PropertyRevision<T>();
            candidate.setOwner(owner);
            candidate.setFirstRevision(revisionNumber);
            candidate.setRemovalRevision(revisionNumber);
            candidate.setName((String)entry.getKey());
            Object value = entry.getValue();
            candidate.setValue(value != null ? value.toString() : null);
            entities.add(candidate);
        }
        this.saveEntitiesForRevision(entities, owner, revisionNumber);
    }

    protected Collection<PropertyRevision<T>> convertToNewDtos(Collection<PropertyRevision<T>> entitiesForRevision) {
        return entitiesForRevision;
    }

    private Collection<PropertyRevision<T>> buildProperties(T owner, List<Map<String, Object>> properties) {
        LinkedList<PropertyRevision<T>> props = new LinkedList<PropertyRevision<T>>();
        for (Map<String, Object> entry : properties) {
            PropertyRevision<T> propertyRevision = new PropertyRevision<T>();
            propertyRevision.setOwner(owner);
            propertyRevision.setName((String)entry.get("property_name"));
            propertyRevision.setValue((String)entry.get("property_value"));
            propertyRevision.setFirstRevision(this.toInteger(entry.get("first_revision")));
            propertyRevision.setRemovalRevision(this.toInteger(entry.get("removal_revision")));
            propertyRevision.setDeleteForRevision(this.toBoolean(entry.get("delete_for_revision")));
            props.add(propertyRevision);
        }
        return props;
    }

    private boolean toBoolean(Object instance) {
        if (instance instanceof Boolean) {
            return (Boolean)instance;
        }
        if (instance instanceof Number) {
            return ((Number)instance).intValue() == 1;
        }
        return false;
    }

    private int toInteger(Object numericObject) {
        if (numericObject instanceof Number) {
            return ((Number)numericObject).intValue();
        }
        return numericObject != null ? Integer.valueOf(numericObject.toString()) : 0;
    }

    static class PropertyRevision<T>
    implements RevisionBasedEntity<PropertyRevision<T>> {
        private T owner;
        private String name;
        private String value;
        private int firstRevision;
        private int removalRevision;
        private boolean deleteForRevision;

        PropertyRevision() {
        }

        public T getOwner() {
            return this.owner;
        }

        public void setOwner(T owner) {
            this.owner = owner;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setFirstRevision(int firstRevision) {
            this.firstRevision = firstRevision;
        }

        public void setRemovalRevision(int removalRevision) {
            this.removalRevision = removalRevision;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int getFirstRevision() {
            return this.firstRevision;
        }

        public int getRemovalRevision() {
            return this.removalRevision;
        }

        public boolean isDeleteForRevision() {
            return this.deleteForRevision;
        }

        public void setDeleteForRevision(boolean deleteForRevision) {
            this.deleteForRevision = deleteForRevision;
        }

        public boolean isDraft() {
            return this.firstRevision == -1;
        }

        public Object getEntityIdentifier() {
            return this.getName();
        }

        public boolean isDifferentVersionOf(PropertyRevision other) {
            return !StringUtils.equals((CharSequence)this.value, (CharSequence)other.value);
        }
    }
}

