/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.properties.services;

import com.foreach.across.modules.properties.business.EntityProperties;
import com.foreach.across.modules.properties.business.StringPropertiesSource;
import com.foreach.across.modules.properties.registries.EntityPropertiesRegistry;
import com.foreach.across.modules.properties.repositories.EntityPropertiesRepository;
import com.foreach.across.modules.properties.services.EntityPropertiesService;
import com.foreach.common.spring.properties.PropertyTypeRegistry;
import java.util.Collection;

public abstract class AbstractEntityPropertiesService<T extends EntityProperties<U>, U>
implements EntityPropertiesService<T, U> {
    private final EntityPropertiesRegistry entityPropertiesRegistry;
    private final EntityPropertiesRepository<U> entityPropertiesRepository;

    protected AbstractEntityPropertiesService(EntityPropertiesRegistry entityPropertiesRegistry, EntityPropertiesRepository<U> entityPropertiesRepository) {
        this.entityPropertiesRegistry = entityPropertiesRegistry;
        this.entityPropertiesRepository = entityPropertiesRepository;
    }

    @Override
    public T getProperties(U entityId) {
        StringPropertiesSource source = this.entityPropertiesRepository.loadProperties(entityId);
        return this.createEntityProperties(entityId, this.entityPropertiesRegistry.getPropertyTypeRegistry(), source.detach());
    }

    @Override
    public Collection<U> getEntityIdsForPropertyValue(String propertyName, Object propertyValue) {
        return this.entityPropertiesRepository.getEntityIdsForPropertyValue(propertyName, propertyValue);
    }

    @Override
    public void saveProperties(T entityProperties) {
        this.entityPropertiesRepository.saveProperties(((EntityProperties)((Object)entityProperties)).getId(), ((EntityProperties)((Object)entityProperties)).getSource());
    }

    @Override
    public void deleteProperties(U entityId) {
        this.entityPropertiesRepository.deleteProperties(entityId);
    }

    protected abstract T createEntityProperties(U var1, PropertyTypeRegistry<String> var2, StringPropertiesSource var3);
}

