/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.properties.services;

import com.foreach.across.core.revision.Revision;
import com.foreach.across.modules.properties.business.EntityProperties;
import com.foreach.across.modules.properties.business.StringPropertiesSource;
import com.foreach.across.modules.properties.registries.EntityPropertiesRegistry;
import com.foreach.across.modules.properties.repositories.RevisionBasedEntityPropertiesRepository;
import com.foreach.across.modules.properties.services.RevisionBasedEntityPropertiesService;
import com.foreach.common.spring.properties.PropertyTypeRegistry;
import java.util.HashMap;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractRevisionBasedEntityPropertiesService<T extends EntityProperties<U>, U, R extends Revision<U>>
implements RevisionBasedEntityPropertiesService<T, U, R> {
    private final EntityPropertiesRegistry entityPropertiesRegistry;
    private final RevisionBasedEntityPropertiesRepository<U, R> entityPropertiesRepository;

    protected AbstractRevisionBasedEntityPropertiesService(EntityPropertiesRegistry entityPropertiesRegistry, RevisionBasedEntityPropertiesRepository<U, R> entityPropertiesRepository) {
        this.entityPropertiesRegistry = entityPropertiesRegistry;
        this.entityPropertiesRepository = entityPropertiesRepository;
    }

    @Override
    @Transactional(readOnly=true)
    public T getProperties(R revision) {
        return this.getProperties(revision.getRevisionOwner(), revision.getRevisionNumber());
    }

    @Override
    @Transactional(readOnly=true)
    public T getProperties(U entityId, int revisionNumber) {
        StringPropertiesSource source = this.entityPropertiesRepository.loadProperties(entityId, revisionNumber);
        return this.createEntityProperties(entityId, this.entityPropertiesRegistry.getPropertyTypeRegistry(), source);
    }

    @Override
    @Transactional
    public void saveProperties(T entityProperties, R revision) {
        this.saveProperties(entityProperties, revision.getRevisionOwner(), revision.getRevisionNumber());
    }

    @Override
    @Transactional
    public void saveProperties(T entityProperties, U entityId, int revisionNumber) {
        this.entityPropertiesRepository.saveProperties(((EntityProperties)((Object)entityProperties)).getSource(), entityId, revisionNumber);
    }

    @Override
    @Transactional
    public void deleteProperties(R revision) {
        this.deleteProperties(revision.getRevisionOwner(), revision.getRevisionNumber());
    }

    @Override
    @Transactional
    public void deleteProperties(U entityId, int revisionNumber) {
        this.entityPropertiesRepository.deleteEntities(entityId, revisionNumber);
    }

    @Override
    @Transactional
    public void deleteProperties(U entityId) {
        this.entityPropertiesRepository.deleteEntities(entityId);
    }

    @Override
    @Transactional
    public void checkin(R revision, int newRevisionNumber) {
        this.checkin(revision.getRevisionOwner(), revision.getRevisionNumber(), newRevisionNumber);
    }

    @Override
    @Transactional
    public void checkin(U entityId, int revisionNumber, int newRevisionNumber) {
        this.entityPropertiesRepository.checkin(entityId, revisionNumber, newRevisionNumber);
    }

    @Override
    @Transactional
    public T checkout(R revision) {
        return this.checkout(revision.getRevisionOwner(), revision.getRevisionNumber());
    }

    @Override
    @Transactional
    public T checkout(U entityId, int revisionNumber) {
        StringPropertiesSource source = this.entityPropertiesRepository.checkoutProperties(entityId, revisionNumber);
        return this.createEntityProperties(entityId, this.entityPropertiesRegistry.getPropertyTypeRegistry(), source);
    }

    @Override
    public T createProperties(R revision) {
        return this.createProperties((U)revision.getRevisionOwner());
    }

    @Override
    public T createProperties(U entityId) {
        return this.createEntityProperties(entityId, this.entityPropertiesRegistry.getPropertyTypeRegistry(), new StringPropertiesSource(new HashMap()));
    }

    protected abstract T createEntityProperties(U var1, PropertyTypeRegistry<String> var2, StringPropertiesSource var3);
}

