/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.config;

import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.core.context.support.AcrossModuleMessageSource;
import com.foreach.across.modules.hibernate.jpa.repositories.config.EnableAcrossJpaRepositories;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.article.WebCmsArticleType;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentType;
import com.foreach.across.modules.webcms.domain.page.WebCmsPageType;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublicationType;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@Configuration
@EnableAcrossJpaRepositories(basePackageClasses={WebCmsObject.class})
public class WebCmsModuleDomainConfiguration {
    @Autowired
    public void registerDefaultTypes(WebCmsTypeRegistry typeRegistry) {
        typeRegistry.register("component", WebCmsComponentType.class, WebCmsComponentType::new);
        typeRegistry.register("article", WebCmsArticleType.class, WebCmsArticleType::new);
        typeRegistry.register("publication", WebCmsPublicationType.class, WebCmsPublicationType::new);
        typeRegistry.register("page", WebCmsPageType.class, WebCmsPageType::new);
    }

    @Bean(name={"entityValidator"})
    @Exposed
    @ConditionalOnMissingBean(name={"entityValidator"}, search=SearchStrategy.ANCESTORS)
    public SmartValidator entityValidator() {
        LocalValidatorFactoryBean localValidatorFactoryBean = new LocalValidatorFactoryBean();
        localValidatorFactoryBean.setValidationMessageSource(this.messageSource());
        return localValidatorFactoryBean;
    }

    @Bean
    @ConditionalOnMissingBean(name={"entityValidator"}, search=SearchStrategy.ANCESTORS)
    public MessageSource messageSource() {
        AcrossModuleMessageSource messageSource = new AcrossModuleMessageSource();
        messageSource.setBasenames(new String[]{"classpath:/org/hibernate/validator/ValidationMessages", "classpath:/messages/WebCmsModule/default"});
        return messageSource;
    }
}

