/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.data;

import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.data.WebCmsDataImportAction;
import com.foreach.across.modules.webcms.data.WebCmsDataImportException;
import com.foreach.across.modules.webcms.data.WebCmsDataImporter;
import com.foreach.across.modules.webcms.data.WebCmsPropertyDataImportService;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainBound;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.infrastructure.ValidationFailedException;
import com.foreach.across.modules.webcms.infrastructure.WebCmsUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;

public abstract class AbstractWebCmsDataImporter<T, U>
implements WebCmsDataImporter {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private MessageSource messageSource;
    private WebCmsDataConversionService conversionService;
    private WebCmsMultiDomainService multiDomainService;
    private WebCmsPropertyDataImportService propertyDataImportService;

    @Override
    public final void importData(WebCmsDataEntry data) {
        try {
            this.LOG.trace("Importing data entry {} {}", (Object)data.getImportAction(), (Object)data);
            T existing = this.retrieveExistingInstance(data);
            WebCmsDataAction action = this.resolveAction(data.getImportAction(), existing);
            this.LOG.trace("Resolved import action {} to {}, existing item: {}", new Object[]{data.getImportAction(), action, existing != null});
            if (action != null) {
                if (action == WebCmsDataAction.DELETE) {
                    this.deleteInstance(existing, data);
                } else {
                    LinkedHashMap<String, Object> dataValues = new LinkedHashMap<String, Object>(data.getMapData());
                    U dto = this.createDto(data, existing, action, dataValues);
                    if (existing == null && dto instanceof WebCmsDomainBound) {
                        ((WebCmsDomainBound)dto).setDomain(this.multiDomainService.getCurrentDomain());
                    }
                    if (dto != null) {
                        boolean dataValuesApplied = data.isSingleValue() ? this.applySingleValue(data.getSingleValue(), dto) : this.applyDataValues(dataValues, dto);
                        boolean customPropertyDataApplied = this.propertyDataImportService.executeBeforeAssetSaved(data, dataValues, dto, action);
                        if (existing == null || dataValuesApplied || customPropertyDataApplied) {
                            this.save(dto, action, data);
                        } else {
                            this.LOG.trace("Skipping saving DTO as no actual values have been updated");
                        }
                        this.propertyDataImportService.executeAfterAssetSaved(data, data.getMapData(), dto, action);
                    }
                }
            } else {
                this.LOG.trace("Skipping data entry as no valid action was resolved");
            }
        }
        catch (WebCmsDataImportException die) {
            throw die;
        }
        catch (Exception e) {
            throw new WebCmsDataImportException(data, (Throwable)e);
        }
    }

    protected WebCmsDomain retrieveDomainForDataEntry(WebCmsDataEntry item, Class<?> entityType) {
        return item.getMapData().containsKey("domain") ? (WebCmsDomain)this.conversionService.convert(item.getMapData().get("domain"), WebCmsDomain.class) : this.multiDomainService.getCurrentDomainForType(entityType);
    }

    protected boolean applyDataValues(Map<String, Object> values, U dto) {
        return this.conversionService.convertToPropertyValues(values, dto);
    }

    private boolean applySingleValue(Object value, U dto) {
        return this.conversionService.convertSingleValue(value, dto);
    }

    protected WebCmsDataAction resolveAction(WebCmsDataImportAction requested, T existing) {
        return WebCmsUtils.convertImportActionToDataAction(existing, requested);
    }

    private void save(U dto, WebCmsDataAction action, WebCmsDataEntry data) {
        U itemToSave = this.prepareForSaving(dto, data);
        if (itemToSave != null) {
            this.validateForSaving(itemToSave);
            this.saveDto(itemToSave, action, data);
        } else {
            this.LOG.trace("Skipping data import {} import for {} - prepareForSaving returned null", (Object)data);
        }
    }

    protected final void validateForSaving(U itemToSave) {
        if (itemToSave != null) {
            BeanPropertyBindingResult errors = new BeanPropertyBindingResult(itemToSave, itemToSave.getClass().getSimpleName());
            this.validate(itemToSave, (Errors)errors);
            if (errors.hasErrors()) {
                throw new ValidationFailedException(this.messageSource, "Validation failed for " + itemToSave.getClass(), (Errors)errors);
            }
        } else {
            throw new IllegalArgumentException("Attempting to validate null object");
        }
    }

    protected U prepareForSaving(U itemToBeSaved, WebCmsDataEntry data) {
        return itemToBeSaved;
    }

    protected void validate(U itemToBeSaved, Errors errors) {
    }

    protected abstract T retrieveExistingInstance(WebCmsDataEntry var1);

    protected abstract U createDto(WebCmsDataEntry var1, T var2, WebCmsDataAction var3, Map<String, Object> var4);

    protected abstract void deleteInstance(T var1, WebCmsDataEntry var2);

    protected abstract void saveDto(U var1, WebCmsDataAction var2, WebCmsDataEntry var3);

    protected final void addForceUpdateProperty(Map<String, Object> dataValues) {
        dataValues.put("wcm:force-update", true);
    }

    @Autowired
    void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Autowired
    void setConversionService(WebCmsDataConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Autowired
    void setMultiDomainService(WebCmsMultiDomainService multiDomainService) {
        this.multiDomainService = multiDomainService;
    }

    @Autowired
    public void setPropertyDataImportService(WebCmsPropertyDataImportService propertyDataImportService) {
        this.propertyDataImportService = propertyDataImportService;
    }
}

